/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;

public class InviteFriendsScreen
extends Screen {
    private final Screen parent;
    private final String serverId;
    private FriendListWidget friendList;
    private String statusMessage = "\u00a7eLoading friends...";
    private int statusColor = 0xFFFF00;

    public InviteFriendsScreen(Screen parent, String serverId) {
        super((Component)Component.m_237113_((String)"Invite Friends"));
        this.parent = parent;
        this.serverId = serverId;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.friendList = new FriendListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 50, this.f_96544_ - 60, 35);
        this.m_7787_((GuiEventListener)this.friendList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd04 Refresh"), button -> this.loadFriends()).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 50, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 55, this.f_96544_ - 50, 100, 20).m_253136_());
        this.loadFriends();
    }

    private void loadFriends() {
        System.out.println("[Tunnely UI] ===== LOADING FRIENDS FOR INVITE =====");
        this.statusMessage = "\u00a7eLoading friends...";
        this.statusColor = 0xFFFF00;
        this.friendList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.FriendListResult result = client.getFriends();
                this.f_96541_.execute(() -> {
                    block13: {
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing friends for invite...");
                                JsonArray friends = JsonParser.parseString((String)result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + friends.size() + " total friend(s)");
                                int acceptedCount = 0;
                                if (friends.size() == 0) {
                                    this.statusMessage = "\u00a77No friends to invite";
                                    this.statusColor = 0xAAAAAA;
                                    break block13;
                                }
                                for (JsonElement element : friends) {
                                    JsonObject friend = element.getAsJsonObject();
                                    if (!friend.has("status") || !friend.get("status").getAsString().equals("accepted")) continue;
                                    String minecraftName = "Unknown";
                                    String friendEmail = "unknown@example.com";
                                    if (friend.has("friend") && !friend.get("friend").isJsonNull()) {
                                        JsonObject friendProfile = friend.getAsJsonObject("friend");
                                        if (friendProfile.has("minecraft_name")) {
                                            minecraftName = friendProfile.get("minecraft_name").getAsString();
                                        }
                                    } else if (friend.has("friend_name")) {
                                        minecraftName = friend.get("friend_name").getAsString();
                                    }
                                    if (friend.has("friend_email")) {
                                        friendEmail = friend.get("friend_email").getAsString();
                                    }
                                    System.out.println("[Tunnely UI] Available to invite: " + minecraftName);
                                    this.friendList.addFriend(friendEmail, minecraftName);
                                    ++acceptedCount;
                                }
                                if (acceptedCount == 0) {
                                    this.statusMessage = "\u00a77No accepted friends to invite";
                                    this.statusColor = 0xAAAAAA;
                                } else {
                                    this.statusMessage = "\u00a7aSelect friends to invite";
                                    this.statusColor = 65280;
                                }
                                System.out.println("[Tunnely UI] " + acceptedCount + " accepted friend(s) available");
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse friends";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing friends: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load friends: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading friends: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadFriendsInvite").start();
    }

    private void inviteFriend(String friendEmail, String friendName) {
        System.out.println("[Tunnely UI] ===== INVITING FRIEND =====");
        System.out.println("[Tunnely UI] Friend: " + friendName + " (" + friendEmail + ")");
        System.out.println("[Tunnely UI] Server ID: " + this.serverId);
        this.statusMessage = "\u00a7eSending invite to " + friendName + "...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.sendInvite(this.serverId, friendEmail);
                this.f_96541_.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aInvite sent to " + friendName + "!";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Invite sent successfully");
                    } else {
                        this.statusMessage = "\u00a7cFailed to send invite";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to send invite");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception sending invite: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-SendInvite").start();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.friendList.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, "\u00a76\u00a7lInvite Friends to Server", this.f_96543_ / 2, 20, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, 35, this.statusColor);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class FriendListWidget
    extends ObjectSelectionList<FriendEntry> {
        public FriendListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
        }

        public void clear() {
            this.m_93516_();
        }

        public void addFriend(String email, String name) {
            this.m_7085_((AbstractSelectionList.Entry)new FriendEntry(email, name));
        }

        class FriendEntry
        extends ObjectSelectionList.Entry<FriendEntry> {
            private final String email;
            private final String name;
            private final Button inviteButton;

            public FriendEntry(String email, String name) {
                this.email = email;
                this.name = name;
                this.inviteButton = Button.m_253074_((Component)Component.m_237113_((String)"Invite"), button -> InviteFriendsScreen.this.inviteFriend(email, name)).m_252987_(0, 0, 60, 20).m_253136_();
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                graphics.m_280488_(InviteFriendsScreen.this.f_96547_, "\u00a7b" + this.name, left + 5, top + 8, 0xFFFFFF);
                this.inviteButton.m_252865_(left + width - 70);
                this.inviteButton.m_253211_(top + 7);
                this.inviteButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.inviteButton.m_6375_(mouseX, mouseY, button);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.name);
            }
        }
    }
}

