/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;

public class JoinFriendsScreen
extends Screen {
    private final Screen parent;
    private ServerListWidget serverList;
    private String statusMessage = "\u00a7eLoading servers...";
    private int statusColor = 0xFFFF00;
    private boolean isLoading = true;

    public JoinFriendsScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Join Friends"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.serverList = new ServerListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 50, this.f_96544_ - 60, 40);
        this.m_7787_((GuiEventListener)this.serverList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd04 Refresh"), button -> this.loadServers()).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 50, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 55, this.f_96544_ - 50, 100, 20).m_253136_());
        this.loadServers();
    }

    private void loadServers() {
        System.out.println("[Tunnely UI] ===== LOADING FRIEND SERVERS =====");
        this.isLoading = true;
        this.statusMessage = "\u00a7eLoading servers...";
        this.statusColor = 0xFFFF00;
        this.serverList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.ServerListResult result = client.getFriendServers();
                this.f_96541_.execute(() -> {
                    block10: {
                        this.isLoading = false;
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing server data...");
                                JsonArray servers = JsonParser.parseString((String)result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + servers.size() + " server(s)");
                                if (servers.size() == 0) {
                                    this.statusMessage = "\u00a77No active servers from friends";
                                    this.statusColor = 0xAAAAAA;
                                    break block10;
                                }
                                for (JsonElement element : servers) {
                                    JsonObject server = element.getAsJsonObject();
                                    String serverId = server.get("id").getAsString();
                                    String endpoint = server.has("public_endpoint") ? server.get("public_endpoint").getAsString() : "N/A";
                                    String gameMode = server.has("game_mode") ? server.get("game_mode").getAsString() : "survival";
                                    String hostName = "Unknown";
                                    if (server.has("host") && !server.get("host").isJsonNull()) {
                                        JsonObject hostProfile = server.getAsJsonObject("host");
                                        if (hostProfile.has("minecraft_name")) {
                                            hostName = hostProfile.get("minecraft_name").getAsString();
                                        }
                                    } else if (server.has("host_name")) {
                                        hostName = server.get("host_name").getAsString();
                                    }
                                    System.out.println("[Tunnely UI] Server: " + hostName + " @ " + endpoint + " (" + gameMode + ")");
                                    this.serverList.addServer(serverId, hostName, endpoint, gameMode);
                                }
                                this.statusMessage = "\u00a7aFound " + servers.size() + " server(s)";
                                this.statusColor = 65280;
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse server list";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing servers: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load servers: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading servers: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.isLoading = false;
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadServers").start();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.serverList.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, "\u00a76\u00a7lJoin Friends", this.f_96543_ / 2, 20, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, 35, this.statusColor);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class ServerListWidget
    extends ObjectSelectionList<ServerEntry> {
        public ServerListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
        }

        public void clear() {
            this.m_93516_();
        }

        public void addServer(String id, String hostName, String endpoint, String gameMode) {
            this.m_7085_((AbstractSelectionList.Entry)new ServerEntry(id, hostName, endpoint, gameMode));
        }

        class ServerEntry
        extends ObjectSelectionList.Entry<ServerEntry> {
            private final String id;
            private final String hostName;
            private final String endpoint;
            private final String gameMode;
            private final Button joinButton;

            public ServerEntry(String id, String hostName, String endpoint, String gameMode) {
                this.id = id;
                this.hostName = hostName;
                this.endpoint = endpoint;
                this.gameMode = gameMode;
                this.joinButton = Button.m_253074_((Component)Component.m_237113_((String)"Join"), button -> this.joinServer()).m_252987_(0, 0, 60, 20).m_253136_();
            }

            /*
             * Enabled aggressive block sorting
             */
            private void joinServer() {
                String sessionId;
                Object relayUrl;
                block5: {
                    System.out.println("[Tunnely UI] Join server requested for: " + this.endpoint);
                    if (this.endpoint == null || this.endpoint.equals("N/A") || !this.endpoint.contains("/")) {
                        JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid server endpoint";
                        JoinFriendsScreen.this.statusColor = 0xFF0000;
                        return;
                    }
                    if (this.endpoint.contains("://")) {
                        int lastSlash = this.endpoint.lastIndexOf(47);
                        if (lastSlash > 0 && lastSlash < this.endpoint.length() - 1) {
                            relayUrl = this.endpoint.substring(0, lastSlash);
                            sessionId = this.endpoint.substring(lastSlash + 1);
                            break block5;
                        } else {
                            JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid endpoint format";
                            JoinFriendsScreen.this.statusColor = 0xFF0000;
                            return;
                        }
                    }
                    String[] parts = this.endpoint.split("/", 2);
                    if (parts.length != 2) {
                        JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid endpoint format";
                        JoinFriendsScreen.this.statusColor = 0xFF0000;
                        return;
                    }
                    String relayHostPort = parts[0];
                    sessionId = parts[1];
                    relayUrl = "wss://" + relayHostPort;
                    System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
                }
                JoinFriendsScreen.this.statusMessage = "\u00a7eConnecting to " + this.hostName + "'s server...";
                JoinFriendsScreen.this.statusColor = 0xFFFF00;
                ClientTunnelManager clientManager = ClientTunnelManager.getInstance();
                clientManager.connectToServer((String)relayUrl, sessionId, () -> JoinFriendsScreen.this.f_96541_.execute(() -> {
                    JoinFriendsScreen.this.statusMessage = "\u00a7aConnecting to Minecraft server...";
                    JoinFriendsScreen.this.statusColor = 65280;
                    System.out.println("[Tunnely UI] Successfully connected to " + this.hostName + "'s server");
                }), error -> JoinFriendsScreen.this.f_96541_.execute(() -> {
                    System.err.println("[Tunnely UI] Connection error: " + error);
                    String errorType = this.categorizeError((String)error);
                    JoinFriendsScreen.this.f_96541_.m_91152_((Screen)new ConnectionInfoScreen(JoinFriendsScreen.this.parent, this.hostName + "'s Server", errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::joinServer : null));
                }));
            }

            private String categorizeError(String error) {
                if (error == null) {
                    return "GENERIC";
                }
                String lowerError = error.toLowerCase();
                if (lowerError.contains("full") || lowerError.contains("capacity")) {
                    return "FULL";
                }
                if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
                    return "NOT_AUTHORIZED";
                }
                if (lowerError.contains("not found") || lowerError.contains("session not found")) {
                    return "NOT_FOUND";
                }
                if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
                    return "CONNECTION_FAILED";
                }
                if (lowerError.contains("incompatible") || lowerError.contains("version")) {
                    return "INCOMPATIBLE";
                }
                return "GENERIC";
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                graphics.m_280488_(JoinFriendsScreen.this.f_96547_, "\u00a7b" + this.hostName, left + 5, top + 5, 0xFFFFFF);
                graphics.m_280488_(JoinFriendsScreen.this.f_96547_, "\u00a77" + this.endpoint, left + 5, top + 18, 0xAAAAAA);
                graphics.m_280488_(JoinFriendsScreen.this.f_96547_, "\u00a7e" + this.gameMode, left + 5, top + 28, 0xFFFFFF);
                this.joinButton.m_252865_(left + width - 70);
                this.joinButton.m_253211_(top + 10);
                this.joinButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.joinButton.m_6375_(mouseX, mouseY, button);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)(this.hostName + " - " + this.endpoint));
            }
        }
    }
}

