/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;

public class TermsOfServiceScreen
extends Screen {
    private final Screen parent;
    private final Runnable onAccept;
    private TosContentWidget contentWidget;
    private Checkbox acceptCheckbox;
    private Button acceptButton;
    private Button declineButton;
    private Button exportButton;
    private String tosVersion = "";
    private String tosTitle = "";
    private String acceptanceText = "";
    private String footer = "";
    private List<TosSection> sections = new ArrayList<TosSection>();

    public TermsOfServiceScreen(Screen parent, Runnable onAccept) {
        super((Component)Component.m_237113_((String)"Terms of Service"));
        this.parent = parent;
        this.onAccept = onAccept;
        this.loadTosFromJson();
    }

    private void loadTosFromJson() {
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/terms-of-service.json");
            if (stream == null) {
                System.err.println("[Tunnely] Could not load terms-of-service.json");
                this.tosTitle = "Terms of Service";
                this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
                return;
            }
            InputStreamReader reader = new InputStreamReader(stream);
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            this.tosVersion = json.has("version") ? json.get("version").getAsString() : "1.0.0";
            this.tosTitle = json.has("title") ? json.get("title").getAsString() : "Terms of Service";
            this.acceptanceText = json.has("acceptance_text") ? json.get("acceptance_text").getAsString() : "I accept the Terms of Service";
            String string = this.footer = json.has("footer") ? json.get("footer").getAsString() : "";
            if (json.has("sections")) {
                JsonArray sectionsArray = json.getAsJsonArray("sections");
                for (int i = 0; i < sectionsArray.size(); ++i) {
                    JsonObject section = sectionsArray.get(i).getAsJsonObject();
                    String title = section.has("title") ? section.get("title").getAsString() : "";
                    String content = section.has("content") ? section.get("content").getAsString() : "";
                    this.sections.add(new TosSection(title, content));
                }
            }
            System.out.println("[Tunnely] Loaded TOS version " + this.tosVersion + " with " + this.sections.size() + " sections");
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading TOS: " + e.getMessage());
            e.printStackTrace();
            this.tosTitle = "Terms of Service";
            this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int footerHeight = 0;
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.f_96543_ - 40);
            footerHeight = footerLines.size() * 11 + 10;
        }
        int topMargin = 55;
        int bottomMargin = 75 + footerHeight;
        int maxSectionHeight = 50;
        for (TosSection section : this.sections) {
            List<String> wrapped = this.wrapText(section.content, this.f_96543_ - 100);
            int sectionHeight = 12 + wrapped.size() * 11 + 15;
            maxSectionHeight = Math.max(maxSectionHeight, sectionHeight);
        }
        this.contentWidget = new TosContentWidget(this.f_96541_, this.f_96543_, this.f_96544_, topMargin, this.f_96544_ - bottomMargin, maxSectionHeight);
        this.contentWidget.setSections(this.sections);
        this.m_7787_((GuiEventListener)this.contentWidget);
        int buttonY = this.f_96544_ - 30;
        int checkboxY = buttonY - 35;
        int footerY = checkboxY - 15;
        this.acceptCheckbox = new Checkbox(this.f_96543_ / 2 - 100, checkboxY, 200, 20, (Component)Component.m_237113_((String)this.acceptanceText), false);
        this.m_142416_((GuiEventListener)this.acceptCheckbox);
        this.acceptButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7aI Agree"), button -> this.acceptTos()).m_252987_(this.f_96543_ / 2 - 155, buttonY, 100, 20).m_253136_();
        this.acceptButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.acceptButton);
        this.declineButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cDecline"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 - 50, buttonY, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.declineButton);
        this.exportButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7e\ud83d\udcc4 Export"), button -> this.exportTos()).m_252987_(this.f_96543_ / 2 + 55, buttonY, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.exportButton);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
            if (this.f_96547_.m_92895_(testLine) > maxWidth) {
                if (line.length() > 0) {
                    lines.add(line.toString());
                    line = new StringBuilder(word);
                    continue;
                }
                lines.add(word);
                continue;
            }
            line.append(line.length() > 0 ? " " : "").append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public void m_86600_() {
        super.m_86600_();
        this.acceptButton.f_93623_ = this.acceptCheckbox.m_93840_();
    }

    private void acceptTos() {
        System.out.println("[Tunnely] TOS accepted - version " + this.tosVersion);
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAcceptedTosVersion(this.tosVersion);
        if (this.onAccept != null) {
            this.onAccept.run();
        }
    }

    private void exportTos() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String filename = String.format("Tunnely_TOS_%s_%s.txt", this.tosVersion.replace(".", "_"), dateFormat.format(new Date()));
            File exportFile = new File(filename);
            try (PrintWriter writer = new PrintWriter(new FileWriter(exportFile));){
                writer.println("=".repeat(80));
                writer.println(this.tosTitle);
                writer.println("Version: " + this.tosVersion);
                writer.println("Exported: " + String.valueOf(new Date()));
                writer.println("=".repeat(80));
                writer.println();
                for (TosSection section : this.sections) {
                    writer.println("-".repeat(80));
                    writer.println(section.title);
                    writer.println("-".repeat(80));
                    writer.println();
                    writer.println(section.content);
                    writer.println();
                }
                if (!this.footer.isEmpty()) {
                    writer.println("=".repeat(80));
                    writer.println("ACCEPTANCE NOTICE");
                    writer.println("=".repeat(80));
                    writer.println();
                    writer.println(this.footer);
                    writer.println();
                }
                writer.println("=".repeat(80));
                writer.println("End of Terms of Service");
                writer.println("=".repeat(80));
            }
            System.out.println("[Tunnely] \u2713 TOS exported to: " + exportFile.getAbsolutePath());
            this.f_96541_.execute(() -> System.out.println("[Tunnely] TOS saved to game directory: " + filename));
        }
        catch (IOException e) {
            System.err.println("[Tunnely] \u2717 Failed to export TOS: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.contentWidget.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, "\u00a76\u00a7l" + this.tosTitle, this.f_96543_ / 2, 15, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Version " + this.tosVersion, this.f_96543_ / 2, 30, 0xAAAAAA);
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.f_96543_ - 40);
            int startY = this.f_96544_ - 75 - footerLines.size() * 11;
            for (int i = 0; i < footerLines.size(); ++i) {
                graphics.m_280137_(this.f_96547_, "\u00a77\u00a7o" + footerLines.get(i), this.f_96543_ / 2, startY + i * 11, 0xAAAAAA);
            }
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private static class TosSection {
        final String title;
        final String content;

        TosSection(String title, String content) {
            this.title = title;
            this.content = content;
        }
    }

    private class TosContentWidget
    extends ObjectSelectionList<SectionEntry> {
        public TosContentWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
        }

        public void setSections(List<TosSection> sections) {
            this.m_93516_();
            for (TosSection section : sections) {
                this.m_7085_((AbstractSelectionList.Entry)new SectionEntry(section));
            }
        }

        public int m_5759_() {
            return Math.min(600, this.f_93388_ - 50);
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + this.m_5759_() / 2 + 10;
        }

        public int m_5747_() {
            return this.f_93388_ / 2 - this.m_5759_() / 2;
        }

        class SectionEntry
        extends ObjectSelectionList.Entry<SectionEntry> {
            private final TosSection section;
            private final List<String> wrappedContent;

            public SectionEntry(TosSection section) {
                this.section = section;
                this.wrappedContent = this.wrapContentText(section.content, TosContentWidget.this.m_5759_() - 30);
            }

            private List<String> wrapContentText(String text, int maxWidth) {
                String[] paragraphs;
                ArrayList<String> lines = new ArrayList<String>();
                for (String paragraph : paragraphs = text.split("\\n")) {
                    if (paragraph.trim().isEmpty()) {
                        lines.add("");
                        continue;
                    }
                    String[] words = paragraph.split(" ");
                    StringBuilder line = new StringBuilder();
                    for (String word : words) {
                        String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
                        if (TermsOfServiceScreen.this.f_96547_.m_92895_(testLine) > maxWidth) {
                            if (line.length() > 0) {
                                lines.add(line.toString());
                                line = new StringBuilder(word);
                                continue;
                            }
                            lines.add(word);
                            continue;
                        }
                        line.append(line.length() > 0 ? " " : "").append(word);
                    }
                    if (line.length() <= 0) continue;
                    lines.add(line.toString());
                }
                return lines;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                graphics.m_280488_(TermsOfServiceScreen.this.f_96547_, "\u00a76\u00a7l" + this.section.title, left + 10, top + 8, 0xFFFFFF);
                int yOffset = top + 22;
                for (String line : this.wrappedContent) {
                    if (!line.isEmpty()) {
                        graphics.m_280488_(TermsOfServiceScreen.this.f_96547_, "\u00a77" + line, left + 20, yOffset, 0xFFFFFF);
                    }
                    yOffset += 11;
                }
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.section.title);
            }
        }
    }
}

