/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;

public class UsernameSelectionScreen
extends Screen {
    private final Screen parent;
    private final boolean isFirstTime;
    private EditBox usernameBox;
    private Button confirmButton;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private boolean isChecking = false;

    public UsernameSelectionScreen(Screen parent, boolean isFirstTime) {
        super((Component)Component.m_237113_((String)(isFirstTime ? "Choose Your Username" : "Change Username")));
        this.parent = parent;
        this.isFirstTime = isFirstTime;
    }

    protected void m_7856_() {
        super.m_7856_();
        int inputWidth = 200;
        int inputHeight = 20;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.f_96543_ / 2 - inputWidth / 2;
        int startY = this.f_96544_ / 2 - 40;
        this.usernameBox = new EditBox(this.f_96547_, centerX, startY, inputWidth, inputHeight, (Component)Component.m_237113_((String)"Username"));
        this.usernameBox.m_94199_(16);
        this.usernameBox.m_257771_((Component)Component.m_237113_((String)"Enter username"));
        if (!this.isFirstTime) {
            TunnelConfig config = TunnelConfig.getInstance();
            SupabaseClient client = new SupabaseClient();
            JsonObject profile = client.getOwnProfile();
            if (profile != null && profile.has("minecraft_name")) {
                this.usernameBox.m_94144_(profile.get("minecraft_name").getAsString());
            }
        }
        this.m_142416_((GuiEventListener)this.usernameBox);
        this.m_264313_((GuiEventListener)this.usernameBox);
        this.confirmButton = Button.m_253074_((Component)Component.m_237113_((String)(this.isFirstTime ? "Continue" : "Save")), button -> this.handleConfirm()).m_252987_(centerX, startY + 35, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.confirmButton);
        if (!this.isFirstTime) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX, startY + 60, buttonWidth, buttonHeight).m_253136_());
        }
    }

    private void handleConfirm() {
        if (this.isChecking) {
            return;
        }
        String username = this.usernameBox.m_94155_().trim();
        if (username.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a username";
            this.statusColor = 0xFF5555;
            return;
        }
        if (username.length() < 3) {
            this.statusMessage = "\u00a7cUsername must be at least 3 characters";
            this.statusColor = 0xFF5555;
            return;
        }
        if (username.length() > 16) {
            this.statusMessage = "\u00a7cUsername must be 16 characters or less";
            this.statusColor = 0xFF5555;
            return;
        }
        if (!username.matches("^[a-zA-Z0-9_]+$")) {
            this.statusMessage = "\u00a7cUsername can only contain letters, numbers, and underscores";
            this.statusColor = 0xFF5555;
            return;
        }
        this.isChecking = true;
        this.confirmButton.f_93623_ = false;
        this.statusMessage = "\u00a7eChecking username availability...";
        this.statusColor = 0xFFFF55;
        String finalUsername = username;
        new Thread(() -> {
            try {
                boolean success;
                SupabaseClient client = new SupabaseClient();
                TunnelConfig config = TunnelConfig.getInstance();
                JsonObject currentProfile = client.getOwnProfile();
                String currentUsername = null;
                if (currentProfile != null && currentProfile.has("minecraft_name")) {
                    currentUsername = currentProfile.get("minecraft_name").getAsString();
                }
                if (currentUsername != null && currentUsername.equals(finalUsername)) {
                    this.f_96541_.execute(() -> {
                        this.statusMessage = "\u00a7aUsername unchanged";
                        this.statusColor = 0x55FF55;
                        this.isChecking = false;
                        this.confirmButton.f_93623_ = true;
                        new Thread(() -> {
                            try {
                                Thread.sleep(1000L);
                                this.f_96541_.execute(() -> this.f_96541_.m_91152_(this.parent));
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }).start();
                    });
                    return;
                }
                boolean available = client.isUsernameAvailable(finalUsername);
                if (!available) {
                    this.f_96541_.execute(() -> {
                        this.statusMessage = "\u00a7cUsername is already taken";
                        this.statusColor = 0xFF5555;
                        this.isChecking = false;
                        this.confirmButton.f_93623_ = true;
                    });
                    return;
                }
                String userId = config.getSupabaseUserId();
                String minecraftUuid = "";
                if (this.f_96541_.f_91074_ != null) {
                    minecraftUuid = this.f_96541_.f_91074_.m_20149_();
                }
                if (success = client.createOrUpdateProfile(userId, finalUsername, minecraftUuid)) {
                    this.f_96541_.execute(() -> {
                        this.statusMessage = "\u00a7aUsername set successfully!";
                        this.statusColor = 0x55FF55;
                        this.isChecking = false;
                        new Thread(() -> {
                            try {
                                Thread.sleep(1000L);
                                this.f_96541_.execute(() -> {
                                    if (this.isFirstTime) {
                                        this.f_96541_.m_91152_((Screen)new TunnelyMainScreen(this.parent));
                                    } else {
                                        this.f_96541_.m_91152_(this.parent);
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }).start();
                    });
                } else {
                    this.f_96541_.execute(() -> {
                        this.statusMessage = "\u00a7cFailed to set username. Please try again.";
                        this.statusColor = 0xFF5555;
                        this.isChecking = false;
                        this.confirmButton.f_93623_ = true;
                    });
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error setting username: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                    this.isChecking = false;
                    this.confirmButton.f_93623_ = true;
                });
            }
        }, "Tunnely-SetUsername").start();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        String title = this.isFirstTime ? "\u00a76\u00a7lChoose Your Username" : "\u00a76\u00a7lChange Username";
        graphics.m_280137_(this.f_96547_, title, this.f_96543_ / 2, 30, 0xFFFFFF);
        if (this.isFirstTime) {
            graphics.m_280137_(this.f_96547_, "\u00a77Welcome! Please choose a username for Tunnely.", this.f_96543_ / 2, 60, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a77This will be visible to your friends.", this.f_96543_ / 2, 75, 0xAAAAAA);
        } else {
            graphics.m_280137_(this.f_96547_, "\u00a77Enter your new username below.", this.f_96543_ / 2, 60, 0xAAAAAA);
        }
        int requirementsY = this.f_96544_ / 2 + 30;
        graphics.m_280137_(this.f_96547_, "\u00a78Requirements:", this.f_96543_ / 2, requirementsY, 0x555555);
        graphics.m_280137_(this.f_96547_, "\u00a783-16 characters, letters/numbers/underscores only", this.f_96543_ / 2, requirementsY + 12, 0x555555);
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, this.f_96544_ - 40, this.statusColor);
        }
    }

    public void m_7379_() {
        if (!this.isFirstTime) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_6913_() {
        return !this.isFirstTime;
    }

    public boolean m_7043_() {
        return false;
    }
}

