/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.WorldEditScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class WorldUpdateScreen
extends Screen {
    private final Screen parent;
    private final WorldInfo existingWorld;
    private final WorldManager worldManager;
    private List<String> localWorlds = new ArrayList<String>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 40;
    private int maxScrollOffset = 0;
    private String selectedWorld = null;
    private String statusMessage = "";
    private boolean updating = false;
    private int uploadProgress = 0;

    public WorldUpdateScreen(Screen parent, WorldInfo existingWorld) {
        super((Component)Component.m_237113_((String)"Update World"));
        this.parent = parent;
        this.existingWorld = existingWorld;
        this.worldManager = new WorldManager();
    }

    public Screen getParent() {
        return this.parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Update World"), button -> this.updateWorld()).m_252987_(centerX - 105, this.f_96544_ - 30, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 10, this.f_96544_ - 30, 100, 20).m_253136_());
        this.loadLocalWorlds();
    }

    private void loadLocalWorlds() {
        try {
            Path savesDir = Paths.get("saves", new String[0]);
            if (Files.exists(savesDir, new LinkOption[0]) && Files.isDirectory(savesDir, new LinkOption[0])) {
                this.localWorlds = Files.list(savesDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).sorted().collect(Collectors.toList());
                this.updateMaxScroll();
            }
        }
        catch (IOException e) {
            this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
        }
    }

    private void updateWorld() {
        if (this.selectedWorld == null) {
            this.statusMessage = "\u00a7cPlease select a world first";
            return;
        }
        this.f_96541_.m_91152_((Screen)new WorldEditScreen(this, this.existingWorld, this.selectedWorld));
    }

    private void updateMaxScroll() {
        int visibleHeight = this.f_96544_ - 180;
        int contentHeight = this.localWorlds.size() * 40;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280137_(this.f_96547_, "Update: " + this.existingWorld.getName(), this.f_96543_ / 2, 15, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Select a local world to replace the uploaded version", this.f_96543_ / 2, 35, 0xAAAAAA);
        graphics.m_280137_(this.f_96547_, "\u00a77This will keep ratings, comments, and download count", this.f_96543_ / 2, 48, 0xAAAAAA);
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, 65, 0xFFFFFF);
        }
        if (this.updating && this.uploadProgress > 0) {
            int barWidth = 300;
            int barX = this.f_96543_ / 2 - barWidth / 2;
            int barY = 80;
            graphics.m_280509_(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.m_280509_(barX, barY, barX + barWidth * this.uploadProgress / 100, barY + 10, -2147439873);
            graphics.m_280509_(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.m_280509_(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
        if (!this.updating) {
            this.renderWorldList(graphics, mouseX, mouseY);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderWorldList(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 100;
        int endY = this.f_96544_ - 50;
        int centerX = this.f_96543_ / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.m_280588_(0, startY, this.f_96543_, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.localWorlds.size(); ++i) {
            String worldName = this.localWorlds.get(i);
            int entryY = yOffset + i * 40;
            if (entryY + 40 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, worldName, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.m_280618_();
    }

    private void renderWorldEntry(GuiGraphics graphics, String worldName, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered;
        boolean isSelected = worldName.equals(this.selectedWorld);
        boolean bl = hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 40 - 5;
        int bgColor = isSelected ? -2147461752 : (hovered ? -2143272896 : -2145378272);
        graphics.m_280509_(x, y, x + width, y + 40 - 5, bgColor);
        graphics.m_280509_(x, y, x + width, y + 1, -12566464);
        graphics.m_280509_(x, y + 40 - 5, x + width, y + 40 - 4, -12566464);
        Object displayName = isSelected ? "\u00a7b\u2713 " + worldName : worldName;
        graphics.m_280488_(this.f_96547_, (String)displayName, x + 5, y + 10, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a77saves/" + worldName, x + 5, y + 22, 0x888888);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.updating) {
            int startY = 100;
            int endY = this.f_96544_ - 50;
            int centerX = this.f_96543_ / 2;
            int entryWidth = 400;
            int entryX = centerX - entryWidth / 2;
            if (mouseX >= (double)entryX && mouseX <= (double)(entryX + entryWidth) && mouseY >= (double)startY && mouseY <= (double)endY) {
                int yOffset = startY - this.scrollOffset;
                for (int i = 0; i < this.localWorlds.size(); ++i) {
                    int entryY = yOffset + i * 40;
                    if (!(mouseY >= (double)entryY) || !(mouseY <= (double)(entryY + 40 - 5))) continue;
                    this.selectedWorld = this.localWorlds.get(i);
                    this.statusMessage = "\u00a7aSelected: " + this.selectedWorld;
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.updating) {
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - (int)(delta * 20.0)));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

