/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.MediaType;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.OkHttpClient;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.Request;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.RequestBody;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.Response;
import org.texboobcat.tunnelyrefab.worlds.WorldNotification;

public class NotificationManager {
    private static final Gson GSON = new Gson();
    private static final MediaType JSON = MediaType.get("application/json; charset=utf-8");
    private final OkHttpClient httpClient;
    private final SupabaseConfig config;

    public NotificationManager(OkHttpClient httpClient, SupabaseConfig config) {
        this.httpClient = httpClient;
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WorldNotification> getUnreadNotifications() {
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/notifications?read=eq.false&order=created_at.desc&limit=50";
            Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserToken()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return Collections.emptyList();
                if (response.body() == null) return Collections.emptyList();
                String responseBody = response.body().string();
                List list = (List)GSON.fromJson(responseBody, new TypeToken<List<WorldNotification>>(){}.getType());
                return list;
            }
        }
        catch (Exception e) {
            System.err.println("[NotificationManager] Failed to fetch notifications: " + e.getMessage());
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WorldNotification> getAllNotifications(int limit) {
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/notifications?order=created_at.desc&limit=" + limit;
            Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserToken()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return Collections.emptyList();
                if (response.body() == null) return Collections.emptyList();
                String responseBody = response.body().string();
                List list = (List)GSON.fromJson(responseBody, new TypeToken<List<WorldNotification>>(){}.getType());
                return list;
            }
        }
        catch (Exception e) {
            System.err.println("[NotificationManager] Failed to fetch all notifications: " + e.getMessage());
        }
        return Collections.emptyList();
    }

    public boolean markAsRead(String notificationId) {
        String url = this.config.getSupabaseUrl() + "/rest/v1/notifications?id=eq." + notificationId;
        String jsonBody = "{\"read\":true}";
        RequestBody body = RequestBody.create(JSON, jsonBody);
        Request request = new Request.Builder().url(url).patch(body).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserToken()).addHeader("Content-Type", "application/json").addHeader("Prefer", "return=minimal").build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("[NotificationManager] Failed to mark notification as read: " + e.getMessage());
                return false;
            }
        }
    }

    public boolean markAllAsRead() {
        String url = this.config.getSupabaseUrl() + "/rest/v1/notifications?read=eq.false";
        String jsonBody = "{\"read\":true}";
        RequestBody body = RequestBody.create(JSON, jsonBody);
        Request request = new Request.Builder().url(url).patch(body).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserToken()).addHeader("Content-Type", "application/json").addHeader("Prefer", "return=minimal").build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("[NotificationManager] Failed to mark all as read: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUnreadCount() {
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/notifications?read=eq.false&select=count";
            Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserToken()).addHeader("Content-Type", "application/json").addHeader("Prefer", "count=exact").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return 0;
                String countHeader = response.header("Content-Range");
                if (countHeader == null) return 0;
                if (!countHeader.contains("/")) return 0;
                String[] parts = countHeader.split("/");
                int n = Integer.parseInt(parts[1]);
                return n;
            }
        }
        catch (Exception e) {
            System.err.println("[NotificationManager] Failed to get unread count: " + e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WorldNotification> getSecurityNotifications() {
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/notifications?type=eq.world_scan_failed&order=created_at.desc&limit=20";
            Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserToken()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return Collections.emptyList();
                if (response.body() == null) return Collections.emptyList();
                String responseBody = response.body().string();
                List list = (List)GSON.fromJson(responseBody, new TypeToken<List<WorldNotification>>(){}.getType());
                return list;
            }
        }
        catch (Exception e) {
            System.err.println("[NotificationManager] Failed to fetch security notifications: " + e.getMessage());
        }
        return Collections.emptyList();
    }

    public boolean deleteNotification(String notificationId) {
        String url = this.config.getSupabaseUrl() + "/rest/v1/notifications?id=eq." + notificationId;
        Request request = new Request.Builder().url(url).delete().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserToken()).addHeader("Content-Type", "application/json").build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("[NotificationManager] Failed to delete notification: " + e.getMessage());
                return false;
            }
        }
    }

    public static interface SupabaseConfig {
        public String getSupabaseUrl();

        public String getSupabaseAnonKey();

        public String getUserToken();
    }
}

