/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.messaging;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.shaded.org.java_websocket.client.WebSocketClient;
import org.texboobcat.tunnelyrefab.shaded.org.java_websocket.handshake.ServerHandshake;

public class SupabaseRealtimeClient
extends WebSocketClient {
    private final TunnelConfig config = TunnelConfig.getInstance();
    private final Consumer<JsonObject> messageCallback;
    private final ScheduledExecutorService heartbeatScheduler;
    private long messageRef = 0L;
    private String channelTopic;
    private boolean isSubscribed = false;
    private static final int MAX_RECONNECT_ATTEMPTS = 5;
    private static final long RECONNECT_DELAY_MS = 5000L;
    private int reconnectAttempts = 0;

    public SupabaseRealtimeClient(String supabaseUrl, String apiKey, String accessToken, String userId, Consumer<JsonObject> messageCallback) {
        super(SupabaseRealtimeClient.buildWebSocketUri(supabaseUrl, apiKey, accessToken));
        this.messageCallback = messageCallback;
        this.channelTopic = "realtime:public:messages:recipient_id=eq." + userId;
        this.heartbeatScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "Tunnely-RealtimeHeartbeat");
            thread.setDaemon(true);
            return thread;
        });
    }

    private static URI buildWebSocketUri(String supabaseUrl, String apiKey, String accessToken) {
        try {
            String wsUrl = supabaseUrl.replace("https://", "wss://").replace("http://", "ws://");
            String uri = wsUrl + "/realtime/v1/websocket?apikey=" + apiKey + "&vsn=1.0.0";
            return new URI(uri);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build Realtime WebSocket URI", e);
        }
    }

    @Override
    public void onOpen(ServerHandshake handshake) {
        System.out.println("[Tunnely Realtime] \u2713 WebSocket connected");
        this.reconnectAttempts = 0;
        this.subscribeToMessages();
        this.heartbeatScheduler.scheduleAtFixedRate(this::sendHeartbeat, 30L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void onMessage(String message) {
        try {
            String event;
            JsonObject json = JsonParser.parseString(message).getAsJsonObject();
            switch (event = json.has("event") ? json.get("event").getAsString() : "") {
                case "phx_reply": {
                    this.handlePhxReply(json);
                    break;
                }
                case "postgres_changes": {
                    this.handlePostgresChange(json);
                    break;
                }
                case "system": {
                    System.out.println("[Tunnely Realtime] System: " + String.valueOf(json));
                    break;
                }
                default: {
                    System.out.println("[Tunnely Realtime] Unknown event: " + event);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely Realtime] Error parsing message: " + e.getMessage());
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        System.out.println("[Tunnely Realtime] \u2717 WebSocket closed: " + reason + " (code: " + code + ")");
        this.isSubscribed = false;
        this.heartbeatScheduler.shutdownNow();
        if (remote && this.reconnectAttempts < 5) {
            this.scheduleReconnect();
        }
    }

    @Override
    public void onError(Exception ex) {
        System.err.println("[Tunnely Realtime] WebSocket error: " + ex.getMessage());
    }

    private void subscribeToMessages() {
        JsonObject subscribeMsg = new JsonObject();
        subscribeMsg.addProperty("topic", this.channelTopic);
        subscribeMsg.addProperty("event", "phx_join");
        subscribeMsg.addProperty("payload", "{}");
        subscribeMsg.addProperty("ref", String.valueOf(++this.messageRef));
        this.send(subscribeMsg.toString());
        System.out.println("[Tunnely Realtime] Subscribing to: " + this.channelTopic);
    }

    private void sendHeartbeat() {
        if (this.isOpen()) {
            JsonObject heartbeat = new JsonObject();
            heartbeat.addProperty("topic", "phoenix");
            heartbeat.addProperty("event", "heartbeat");
            heartbeat.addProperty("payload", "{}");
            heartbeat.addProperty("ref", String.valueOf(++this.messageRef));
            this.send(heartbeat.toString());
        }
    }

    private void handlePhxReply(JsonObject json) {
        if (json.has("payload")) {
            String status;
            JsonObject payload = json.getAsJsonObject("payload");
            String string = status = payload.has("status") ? payload.get("status").getAsString() : "";
            if ("ok".equals(status)) {
                this.isSubscribed = true;
                System.out.println("[Tunnely Realtime] \u2713 Subscribed to messages channel");
            } else {
                System.err.println("[Tunnely Realtime] Subscription failed: " + String.valueOf(payload));
            }
        }
    }

    private void handlePostgresChange(JsonObject json) {
        try {
            String type;
            if (!json.has("payload")) {
                return;
            }
            JsonObject payload = json.getAsJsonObject("payload");
            if (!payload.has("data")) {
                return;
            }
            JsonObject data = payload.getAsJsonObject("data");
            String string = type = data.has("type") ? data.get("type").getAsString() : "";
            if ("INSERT".equals(type) && data.has("record")) {
                JsonObject record = data.getAsJsonObject("record");
                System.out.println("[Tunnely Realtime] \ud83d\udcac New message received!");
                this.messageCallback.accept(record);
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely Realtime] Error handling postgres change: " + e.getMessage());
        }
    }

    private void scheduleReconnect() {
        ++this.reconnectAttempts;
        System.out.println("[Tunnely Realtime] Reconnecting in 5 seconds... (attempt " + this.reconnectAttempts + "/5)");
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
                this.reconnect();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, "Tunnely-RealtimeReconnect").start();
    }

    public boolean isSubscribed() {
        return this.isOpen() && this.isSubscribed;
    }

    public void disconnect() {
        this.heartbeatScheduler.shutdownNow();
        this.close();
    }
}

