/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.security;

import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.security.TrustedRelay;

public class RelayValidator {
    private static final List<TrustedRelay> OFFICIAL_RELAYS = new ArrayList<TrustedRelay>();

    public static boolean isTrustedRelay(String relayUrl) {
        if (relayUrl == null || relayUrl.isEmpty()) {
            return false;
        }
        for (TrustedRelay relay : OFFICIAL_RELAYS) {
            if (!relay.matchesUrl(relayUrl)) continue;
            return true;
        }
        return false;
    }

    public static TrustedRelay getTrustedRelay(String relayUrl) {
        if (relayUrl == null || relayUrl.isEmpty()) {
            return null;
        }
        for (TrustedRelay relay : OFFICIAL_RELAYS) {
            if (!relay.matchesUrl(relayUrl)) continue;
            return relay;
        }
        return null;
    }

    public static List<TrustedRelay> getOfficialRelays() {
        return new ArrayList<TrustedRelay>(OFFICIAL_RELAYS);
    }

    public static RelaySecurityStatus validateRelayConfig() {
        TunnelConfig config = TunnelConfig.getInstance();
        String relayUrl = config.getRelayServerUrl();
        if (relayUrl == null || relayUrl.isEmpty()) {
            return new RelaySecurityStatus(SecurityLevel.ERROR, "No relay server configured", null);
        }
        TrustedRelay trustedRelay = RelayValidator.getTrustedRelay(relayUrl);
        if (trustedRelay != null) {
            return new RelaySecurityStatus(SecurityLevel.TRUSTED, "Connected to official Tunnely relay: " + trustedRelay.getRegion(), trustedRelay);
        }
        return new RelaySecurityStatus(SecurityLevel.UNTRUSTED, "\u26a0\ufe0f WARNING: Custom relay server detected!\nCurrent relay: " + relayUrl + "\n\nThis relay is NOT operated by Tunnely.\nThe relay operator can see:\n  \u2022 Your IP address and connection metadata\n  \u2022 All game traffic (chat, coordinates, etc.)\n\nOnly use custom relays from people you trust!\n\nOfficial relays: See /tunnel relays", null);
    }

    static {
        OFFICIAL_RELAYS.add(new TrustedRelay("relay-na-1", "NA", "wss://na-1.tunnely.org:8080", "F2:AA:1E:E0:72:88:E3:5D:35:B0:7E:9D:48:01:B5:31:04:16:4F:61:67:9F:81:10:39:4C:9D:BD:BA:9E:8F:EA"));
        OFFICIAL_RELAYS.add(new TrustedRelay("relay-eu-1", "EU", "wss://eu-1.tunnely.org:8080", "AB:D1:67:71:9D:0B:84:FB:BA:6F:EF:2E:54:6B:00:E0:7D:AD:76:FB:50:FD:EB:21:D7:DC:D8:20:D6:BB:51:9E"));
        OFFICIAL_RELAYS.add(new TrustedRelay("relay-apc-1", "APC", "wss://apc-1.tunnely.org:8080", "20:9C:EC:58:83:FE:D0:F0:E1:78:52:AA:AD:33:9D:77:02:67:A4:86:06:FB:23:12:BF:1A:12:F1:3D:DB:C2:37"));
    }

    public static class RelaySecurityStatus {
        public final SecurityLevel level;
        public final String message;
        public final TrustedRelay trustedRelay;

        public RelaySecurityStatus(SecurityLevel level, String message, TrustedRelay trustedRelay) {
            this.level = level;
            this.message = message;
            this.trustedRelay = trustedRelay;
        }

        public boolean isTrusted() {
            return this.level == SecurityLevel.TRUSTED;
        }

        public boolean isWarning() {
            return this.level == SecurityLevel.UNTRUSTED;
        }

        public boolean isError() {
            return this.level == SecurityLevel.ERROR;
        }
    }

    public static enum SecurityLevel {
        TRUSTED,
        UNTRUSTED,
        ERROR;

    }
}

