/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

public class BandwidthThrottle {
    private final long maxBytesPerSecond;
    private long tokensAvailable;
    private long lastRefillTime;
    private final Object lock = new Object();

    public BandwidthThrottle(long maxBytesPerSecond) {
        this.maxBytesPerSecond = maxBytesPerSecond;
        this.tokensAvailable = maxBytesPerSecond;
        this.lastRefillTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throttle(int bytesTransferred) {
        if (this.maxBytesPerSecond <= 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.refillTokens();
            this.tokensAvailable -= (long)bytesTransferred;
            if (this.tokensAvailable < 0L) {
                long tokensNeeded = Math.abs(this.tokensAvailable);
                long sleepTimeNanos = tokensNeeded * 1000000000L / this.maxBytesPerSecond;
                try {
                    long sleepMillis = sleepTimeNanos / 1000000L;
                    int sleepNanos = (int)(sleepTimeNanos % 1000000L);
                    if (sleepMillis > 0L || sleepNanos > 0) {
                        Thread.sleep(sleepMillis, sleepNanos);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.refillTokens();
            }
        }
    }

    private void refillTokens() {
        long tokensToAdd;
        long currentTime = System.nanoTime();
        long elapsedNanos = currentTime - this.lastRefillTime;
        if (elapsedNanos > 0L && (tokensToAdd = elapsedNanos * this.maxBytesPerSecond / 1000000000L) > 0L) {
            this.tokensAvailable = Math.min(this.maxBytesPerSecond, this.tokensAvailable + tokensToAdd);
            this.lastRefillTime = currentTime;
        }
    }

    public long getMaxBytesPerSecond() {
        return this.maxBytesPerSecond;
    }

    public boolean isEnabled() {
        return this.maxBytesPerSecond > 0L;
    }

    public String getSpeedLimitFormatted() {
        if (this.maxBytesPerSecond <= 0L) {
            return "Unlimited";
        }
        return BandwidthThrottle.formatBytesPerSecond(this.maxBytesPerSecond);
    }

    private static String formatBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond < 1024L) {
            return bytesPerSecond + " B/s";
        }
        int exp = (int)(Math.log(bytesPerSecond) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB/s", (double)bytesPerSecond / Math.pow(1024.0, exp), pre);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.tokensAvailable = this.maxBytesPerSecond;
            this.lastRefillTime = System.nanoTime();
        }
    }
}

