/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class ScanResultDetails {
    @SerializedName(value="safe")
    private boolean safe;
    @SerializedName(value="blockedFiles")
    private List<String> blockedFiles = new ArrayList<String>();
    @SerializedName(value="warnings")
    private List<String> warnings = new ArrayList<String>();
    @SerializedName(value="scannedFileCount")
    private int scannedFileCount;
    @SerializedName(value="scanDate")
    private String scanDate;
    @SerializedName(value="threatLevel")
    private String threatLevel;
    @SerializedName(value="detectionDetails")
    private List<DetectionDetail> detectionDetails = new ArrayList<DetectionDetail>();

    public boolean isSafe() {
        return this.safe;
    }

    public List<String> getBlockedFiles() {
        return this.blockedFiles != null ? this.blockedFiles : new ArrayList<String>();
    }

    public List<String> getWarnings() {
        return this.warnings != null ? this.warnings : new ArrayList<String>();
    }

    public int getScannedFileCount() {
        return this.scannedFileCount;
    }

    public String getScanDate() {
        return this.scanDate;
    }

    public String getThreatLevel() {
        return this.threatLevel != null ? this.threatLevel : "none";
    }

    public List<DetectionDetail> getDetectionDetails() {
        return this.detectionDetails != null ? this.detectionDetails : new ArrayList<DetectionDetail>();
    }

    public String getFormattedThreatLevel() {
        switch (this.getThreatLevel()) {
            case "critical": {
                return "\ud83d\udd34 CRITICAL";
            }
            case "high": {
                return "\ud83d\udfe0 HIGH";
            }
            case "medium": {
                return "\ud83d\udfe1 MEDIUM";
            }
            case "low": {
                return "\ud83d\udfe2 LOW";
            }
        }
        return "\u2705 NONE";
    }

    public boolean hasWarnings() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    public boolean hasBlockedFiles() {
        return this.blockedFiles != null && !this.blockedFiles.isEmpty();
    }

    public String getSummary() {
        if (this.safe) {
            if (this.hasWarnings()) {
                return String.format("Clean with %d warning(s)", this.warnings.size());
            }
            return "Clean - No threats detected";
        }
        return String.format("Quarantined - %d threat(s) detected", this.blockedFiles.size());
    }

    public String getDetailedReport() {
        StringBuilder report = new StringBuilder();
        report.append("=== Scan Report ===\n");
        report.append("Status: ").append(this.safe ? "SAFE" : "QUARANTINED").append("\n");
        report.append("Threat Level: ").append(this.getFormattedThreatLevel()).append("\n");
        report.append("Files Scanned: ").append(this.scannedFileCount).append("\n\n");
        if (this.hasBlockedFiles()) {
            report.append("\ud83d\udeab Blocked Threats:\n");
            for (String blocked : this.blockedFiles) {
                report.append("  \u2022 ").append(blocked).append("\n");
            }
            report.append("\n");
        }
        if (this.hasWarnings()) {
            report.append("\u26a0\ufe0f Warnings:\n");
            for (String warning : this.warnings) {
                report.append("  \u2022 ").append(warning).append("\n");
            }
            report.append("\n");
        }
        if (!this.detectionDetails.isEmpty()) {
            report.append("\ud83d\udd0d Detection Details:\n");
            for (DetectionDetail detail : this.detectionDetails) {
                report.append("  \u2022 [").append(detail.getSeverity().toUpperCase()).append("] ");
                report.append(detail.getDescription()).append("\n");
            }
        }
        return report.toString();
    }

    public static class DetectionDetail {
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="description")
        private String description;
        @SerializedName(value="severity")
        private String severity;

        public String getType() {
            return this.type != null ? this.type : "unknown";
        }

        public String getDescription() {
            return this.description != null ? this.description : "No description";
        }

        public String getSeverity() {
            return this.severity != null ? this.severity : "medium";
        }

        public String getFormattedSeverity() {
            switch (this.getSeverity().toLowerCase()) {
                case "critical": {
                    return "\ud83d\udd34 CRITICAL";
                }
                case "high": {
                    return "\ud83d\udfe0 HIGH";
                }
                case "medium": {
                    return "\ud83d\udfe1 MEDIUM";
                }
                case "low": {
                    return "\ud83d\udfe2 LOW";
                }
            }
            return "\u2139\ufe0f INFO";
        }
    }
}

