/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.SettingsScreen;

public class TermsOfServiceScreen
extends class_437 {
    private final class_437 parent;
    private final Runnable onAccept;
    private class_4286 acceptCheckbox;
    private class_4185 acceptButton;
    private class_4185 declineButton;
    private class_4185 exportButton;
    private class_4185 settingsButton;
    private String tosVersion = "";
    private String tosTitle = "";
    private String acceptanceText = "";
    private String footer = "";
    private List<TosSection> sections = new ArrayList<TosSection>();
    private List<RenderedSection> renderedSections = new ArrayList<RenderedSection>();
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;

    public TermsOfServiceScreen(class_437 parent, Runnable onAccept) {
        super((class_2561)class_2561.method_43470((String)"Terms of Service"));
        this.parent = parent;
        this.onAccept = onAccept;
        this.loadTosFromJson();
    }

    private void loadTosFromJson() {
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/terms-of-service.json");
            if (stream == null) {
                System.err.println("[Tunnely] Could not load terms-of-service.json");
                this.tosTitle = "Terms of Service";
                this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
                return;
            }
            InputStreamReader reader = new InputStreamReader(stream);
            JsonObject json = JsonParser.parseReader(reader).getAsJsonObject();
            this.tosVersion = json.has("version") ? json.get("version").getAsString() : "1.0.0";
            this.tosTitle = json.has("title") ? json.get("title").getAsString() : "Terms of Service";
            this.acceptanceText = json.has("acceptance_text") ? json.get("acceptance_text").getAsString() : "I accept the Terms of Service";
            String string = this.footer = json.has("footer") ? json.get("footer").getAsString() : "";
            if (json.has("sections")) {
                JsonArray sectionsArray = json.getAsJsonArray("sections");
                for (int i = 0; i < sectionsArray.size(); ++i) {
                    JsonObject section = sectionsArray.get(i).getAsJsonObject();
                    String title = section.has("title") ? section.get("title").getAsString() : "";
                    String content = section.has("content") ? section.get("content").getAsString() : "";
                    this.sections.add(new TosSection(title, content));
                }
            }
            System.out.println("[Tunnely] Loaded TOS version " + this.tosVersion + " with " + this.sections.size() + " sections");
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading TOS: " + e.getMessage());
            e.printStackTrace();
            this.tosTitle = "Terms of Service";
            this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
        }
    }

    protected void method_25426() {
        super.method_25426();
        int footerHeight = 0;
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.field_22789 - 40);
            footerHeight = footerLines.size() * 11 + 10;
        }
        int buttonY = this.field_22790 - 30;
        int checkboxY = buttonY - 35;
        this.prepareRenderedSections();
        this.acceptCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)this.acceptanceText), (class_327)this.field_22793).method_54789(this.field_22789 / 2 - 100, checkboxY).method_54794(false).method_54791((checkbox, selected) -> {
            this.acceptButton.field_22763 = selected;
        }).method_54788();
        this.method_37063((class_364)this.acceptCheckbox);
        this.acceptButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7aI Agree"), button -> this.acceptTos()).method_46434(this.field_22789 / 2 - 155, buttonY, 100, 20).method_46431();
        this.acceptButton.field_22763 = false;
        this.method_37063((class_364)this.acceptButton);
        this.declineButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7cDecline"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - 50, buttonY, 100, 20).method_46431();
        this.method_37063((class_364)this.declineButton);
        this.exportButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7e\ud83d\udcc4 Export"), button -> this.exportTos()).method_46434(this.field_22789 / 2 + 55, buttonY, 100, 20).method_46431();
        this.method_37063((class_364)this.exportButton);
        this.settingsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699"), button -> this.field_22787.method_1507((class_437)new SettingsScreen(this))).method_46434(this.field_22789 - 30, 5, 25, 20).method_46431();
        this.method_37063((class_364)this.settingsButton);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
            if (this.field_22793.method_1727(testLine) > maxWidth) {
                if (line.length() > 0) {
                    lines.add(line.toString());
                    line = new StringBuilder(word);
                    continue;
                }
                lines.add(word);
                continue;
            }
            line.append(line.length() > 0 ? " " : "").append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public void method_25393() {
        super.method_25393();
        this.acceptButton.field_22763 = this.acceptCheckbox.method_20372();
    }

    private void acceptTos() {
        System.out.println("[Tunnely] TOS accepted - version " + this.tosVersion);
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAcceptedTosVersion(this.tosVersion);
        if (this.onAccept != null) {
            this.onAccept.run();
        }
    }

    private void exportTos() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String filename = String.format("Tunnely_TOS_%s_%s.txt", this.tosVersion.replace(".", "_"), dateFormat.format(new Date()));
            File exportFile = new File(filename);
            try (PrintWriter writer = new PrintWriter(new FileWriter(exportFile));){
                writer.println("=".repeat(80));
                writer.println(this.tosTitle);
                writer.println("Version: " + this.tosVersion);
                writer.println("Exported: " + String.valueOf(new Date()));
                writer.println("=".repeat(80));
                writer.println();
                for (TosSection section : this.sections) {
                    writer.println("-".repeat(80));
                    writer.println(section.title);
                    writer.println("-".repeat(80));
                    writer.println();
                    writer.println(section.content);
                    writer.println();
                }
                if (!this.footer.isEmpty()) {
                    writer.println("=".repeat(80));
                    writer.println("ACCEPTANCE NOTICE");
                    writer.println("=".repeat(80));
                    writer.println();
                    writer.println(this.footer);
                    writer.println();
                }
                writer.println("=".repeat(80));
                writer.println("End of Terms of Service");
                writer.println("=".repeat(80));
            }
            System.out.println("[Tunnely] \u2713 TOS exported to: " + exportFile.getAbsolutePath());
            this.field_22787.execute(() -> System.out.println("[Tunnely] TOS saved to game directory: " + filename));
        }
        catch (IOException e) {
            System.err.println("[Tunnely] \u2717 Failed to export TOS: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void prepareRenderedSections() {
        this.renderedSections.clear();
        int contentWidth = Math.min(600, this.field_22789 - 50);
        for (TosSection tosSection : this.sections) {
            List<String> wrappedContent = this.wrapContentText(tosSection.content, contentWidth - 30);
            this.renderedSections.add(new RenderedSection(tosSection.title, wrappedContent));
        }
        int totalHeight = 0;
        for (RenderedSection rs : this.renderedSections) {
            totalHeight += 22 + rs.wrappedContent.size() * 11 + 10;
        }
        int n = 55;
        int contentBottom = this.field_22790 - 75;
        int viewHeight = contentBottom - n;
        this.maxScrollOffset = Math.max(0, totalHeight - viewHeight);
    }

    private List<String> wrapContentText(String text, int maxWidth) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs = text.split("\\n")) {
            if (paragraph.trim().isEmpty()) {
                lines.add("");
                continue;
            }
            String[] words = paragraph.split(" ");
            StringBuilder line = new StringBuilder();
            for (String word : words) {
                String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
                if (this.field_22793.method_1727(testLine) > maxWidth) {
                    if (line.length() > 0) {
                        lines.add(line.toString());
                        line = new StringBuilder(word);
                        continue;
                    }
                    lines.add(word);
                    continue;
                }
                line.append(line.length() > 0 ? " " : "").append(word);
            }
            if (line.length() <= 0) continue;
            lines.add(line.toString());
        }
        return lines;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25300(this.field_22793, "\u00a76\u00a7l" + this.tosTitle, this.field_22789 / 2, 15, ColorUtil.opaque(0xFFFFFF));
        graphics.method_25300(this.field_22793, "\u00a77Version " + this.tosVersion, this.field_22789 / 2, 30, ColorUtil.opaque(0xAAAAAA));
        int contentTop = 55;
        int contentBottom = this.field_22790 - 75;
        int contentWidth = Math.min(600, this.field_22789 - 50);
        int contentLeft = this.field_22789 / 2 - contentWidth / 2;
        graphics.method_44379(0, contentTop, this.field_22789, contentBottom);
        int y = contentTop - this.scrollOffset;
        for (RenderedSection rs : this.renderedSections) {
            if (y + 8 >= contentTop - 20 && y <= contentBottom) {
                graphics.method_25303(this.field_22793, "\u00a76\u00a7l" + rs.title, contentLeft + 10, y + 8, ColorUtil.opaque(0xFFAA00));
            }
            int yOffset = y + 22;
            for (String line : rs.wrappedContent) {
                if (yOffset >= contentTop - 20 && yOffset <= contentBottom && !line.isEmpty()) {
                    graphics.method_25303(this.field_22793, "\u00a77" + line, contentLeft + 20, yOffset, ColorUtil.opaque(0xAAAAAA));
                }
                yOffset += 11;
            }
            y += 22 + rs.wrappedContent.size() * 11 + 10;
        }
        graphics.method_44380();
        if (this.maxScrollOffset > 0) {
            int scrollbarX = contentLeft + contentWidth + 10;
            int scrollbarHeight = contentBottom - contentTop;
            int scrollbarThumbHeight = Math.max(20, (int)((float)scrollbarHeight * (float)scrollbarHeight / (float)(scrollbarHeight + this.maxScrollOffset)));
            int scrollbarThumbY = contentTop + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)(scrollbarHeight - scrollbarThumbHeight));
            graphics.method_25294(scrollbarX, contentTop, scrollbarX + 6, contentBottom, 0x44FFFFFF);
            graphics.method_25294(scrollbarX, scrollbarThumbY, scrollbarX + 6, scrollbarThumbY + scrollbarThumbHeight, -1426063361);
        }
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.field_22789 - 40);
            int startY = this.field_22790 - 75 - footerLines.size() * 11;
            for (int i = 0; i < footerLines.size(); ++i) {
                graphics.method_25300(this.field_22793, "\u00a77\u00a7o" + footerLines.get(i), this.field_22789 / 2, startY + i * 11, ColorUtil.opaque(0xAAAAAA));
            }
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.maxScrollOffset > 0) {
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - (int)(scrollY * 20.0)));
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private static class TosSection {
        final String title;
        final String content;

        TosSection(String title, String content) {
            this.title = title;
            this.content = content;
        }
    }

    private static class RenderedSection {
        final String title;
        final List<String> wrappedContent;

        RenderedSection(String title, List<String> wrappedContent) {
            this.title = title;
            this.wrappedContent = wrappedContent;
        }
    }
}

