/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.DirectJoinServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.ToastNotificationManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;
import org.texboobcat.tunnelyrefab.util.TunnelyResolver;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={DirectJoinServerScreen.class})
public abstract class DirectJoinServerScreenMixin {
    @Shadow
    private Button f_95953_;
    @Shadow
    private EditBox f_95955_;
    private boolean tunnelyrefab$lastWasEndpoint = false;
    private boolean tunnelyrefab$normalizing = false;

    @Shadow
    private void m_95987_() {
    }

    @Inject(method={"updateSelectButtonStatus"}, at={@At(value="TAIL")})
    private void tunnelyrefab$allowTunnelyUrls(CallbackInfo ci) {
        String input = this.f_95955_.m_94155_();
        if (!this.f_95953_.f_93623_ && TunnelyResolver.isEndpoint(input)) {
            this.f_95953_.f_93623_ = true;
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void tunnelyrefab$wireResponder(CallbackInfo ci) {
        this.f_95955_.m_94151_(s -> {
            this.m_95987_();
            this.tunnelyrefab$onInputChanged();
        });
    }

    @Inject(method={"onSelect"}, at={@At(value="HEAD")}, cancellable=true)
    private void tunnelyrefab$interceptTunnelyEndpoint(CallbackInfo ci) {
        String input = this.f_95955_.m_94155_();
        TunnelyResolver.ParsedEndpoint endpoint = TunnelyResolver.parseEndpoint(input);
        if (endpoint == null) {
            return;
        }
        this.tunnelyrefab$setNormalizedText(endpoint);
        ToastNotificationManager.getInstance().showWarning("Tunnely", "Connecting via relay " + endpoint.relayUrl + " (session " + endpoint.sessionId + ")");
        ClientTunnelManager.getInstance().connectToServer(endpoint.relayUrl, endpoint.sessionId, () -> {}, err -> {
            ToastNotificationManager.getInstance().showWarning("Tunnely", "Connection failed: " + err);
            String type = DirectJoinServerScreenMixin.tunnelyrefab$categorizeError(err);
            Minecraft.m_91087_().execute(() -> {
                Minecraft mc = Minecraft.m_91087_();
                mc.m_91152_((Screen)new ConnectionInfoScreen(mc.f_91080_, "Direct Connection", type, (String)err, () -> ClientTunnelManager.getInstance().connectToServer(endpoint.relayUrl, endpoint.sessionId, () -> {}, e -> {})));
            });
        });
        ci.cancel();
    }

    private void tunnelyrefab$onInputChanged() {
        String value = this.f_95955_.m_94155_();
        boolean isEndpoint = TunnelyResolver.isEndpoint(value);
        if (isEndpoint != this.tunnelyrefab$lastWasEndpoint) {
            this.tunnelyrefab$lastWasEndpoint = isEndpoint;
            if (isEndpoint) {
                this.f_95953_.m_93666_((Component)Component.m_237113_((String)"Join via Tunnely"));
                ToastNotificationManager.getInstance().showWarning("Tunnely", "Endpoint detected. Press Join to connect via relay.");
                TunnelyResolver.ParsedEndpoint parsed = TunnelyResolver.parseEndpoint(value);
                if (parsed != null) {
                    this.tunnelyrefab$setNormalizedText(parsed);
                }
            } else {
                this.f_95953_.m_93666_((Component)Component.m_237115_((String)"selectServer.select"));
            }
        }
    }

    private void tunnelyrefab$setNormalizedText(TunnelyResolver.ParsedEndpoint endpoint) {
        if (this.tunnelyrefab$normalizing) {
            return;
        }
        this.tunnelyrefab$normalizing = true;
        try {
            String normalized = endpoint.relayUrl + "/" + endpoint.sessionId;
            if (!normalized.equals(this.f_95955_.m_94155_())) {
                this.f_95955_.m_94144_(normalized);
            }
        }
        finally {
            this.tunnelyrefab$normalizing = false;
        }
    }

    private static String tunnelyrefab$categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lower = error.toLowerCase();
        if (lower.contains("full") || lower.contains("capacity")) {
            return "FULL";
        }
        if (lower.contains("not authorized") || lower.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lower.contains("not found") || lower.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lower.contains("connection") || lower.contains("timeout") || lower.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lower.contains("incompatible") || lower.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }
}

