/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.security;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class KeyStorage {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Path getKeyFilePath() {
        String appData = System.getenv("APPDATA");
        if (appData != null && !appData.isEmpty()) {
            return Paths.get(appData, "TunnelyRefab", "keys.json");
        }
        String userHome = System.getProperty("user.home");
        return Paths.get(userHome, ".tunnelyrefab", "keys.json");
    }

    public static boolean keysExist() {
        Keys k = KeyStorage.loadKeys();
        return k != null && k.privateKey != null && !k.privateKey.isEmpty() && k.publicKey != null && !k.publicKey.isEmpty();
    }

    public static Keys loadKeys() {
        Keys keys;
        block9: {
            Path p = KeyStorage.getKeyFilePath();
            if (!Files.exists(p, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(p);
            try {
                Keys k;
                keys = k = (Keys)GSON.fromJson((Reader)reader, Keys.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return keys;
    }

    public static boolean saveKeys(String privateKey, String publicKey) {
        try {
            Path p = KeyStorage.getKeyFilePath();
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Keys k = new Keys();
            k.privateKey = privateKey != null ? privateKey : "";
            k.publicKey = publicKey != null ? publicKey : "";
            try (BufferedWriter writer = Files.newBufferedWriter(p, new OpenOption[0]);){
                GSON.toJson((Object)k, (Appendable)writer);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static class Keys {
        public String privateKey;
        public String publicKey;
    }
}

