/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.EncryptionKeyManager;
import org.texboobcat.tunnelyrefab.messaging.Message;
import org.texboobcat.tunnelyrefab.messaging.MessageEncryption;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;

public class ChatScreen
extends Screen {
    private final Screen parent;
    private final String friendId;
    private final String friendName;
    private final TunnelConfig config;
    private EditBox messageInput;
    private List<Message> messages = new ArrayList<Message>();
    private int scrollOffset = 0;
    private final int MESSAGE_HEIGHT = 35;
    private int maxScrollOffset = 0;
    private boolean autoScroll = true;
    private long lastMessageTime = 0L;
    private String statusMessage = "";
    private int statusColor = 0xAAAAAA;
    private long statusMessageTime = 0L;
    private final long STATUS_DISPLAY_DURATION = 3000L;
    private boolean encryptionReady = false;
    private String encryptionStatus = "Initializing encryption...";

    public ChatScreen(Screen parent, String friendId, String friendName) {
        super((Component)Component.m_237113_((String)("Chat with " + friendName)));
        this.parent = parent;
        this.friendId = friendId;
        this.friendName = friendName;
        this.config = TunnelConfig.getInstance();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        this.messageInput = new EditBox(this.f_96547_, centerX - 150, this.f_96544_ - 45, 250, 20, (Component)Component.m_237113_((String)"Message"));
        this.messageInput.m_94199_(1000);
        this.messageInput.m_257771_((Component)Component.m_237113_((String)"Type a message..."));
        this.m_142416_((GuiEventListener)this.messageInput);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Send"), button -> this.sendMessage()).m_252987_(centerX + 105, this.f_96544_ - 45, 45, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> {
            MessageManager.getInstance().unsubscribeFromConversation(this.friendId);
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 25, 100, 20).m_253136_());
        this.loadMessages();
        MessageManager.getInstance().subscribeToConversation(this.friendId, this::onNewMessage);
        this.initializeEncryption();
    }

    private void loadMessages() {
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.MessagesResult result = client.getMessages(this.friendId, 50);
                if (result.success && result.data != null) {
                    ArrayList<Message> loadedMessages = new ArrayList<Message>();
                    JsonArray messagesArray = JsonParser.parseString((String)result.data).getAsJsonArray();
                    for (JsonElement element : messagesArray) {
                        JsonObject msgObj = element.getAsJsonObject();
                        Message msg = this.parseMessage(msgObj);
                        if (msg == null) continue;
                        loadedMessages.add(msg);
                    }
                    Collections.reverse(loadedMessages);
                    this.f_96541_.execute(() -> {
                        this.messages = loadedMessages;
                        this.updateScrollBounds();
                        this.scrollToBottom();
                        this.markMessagesAsRead();
                    });
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely Chat] Error loading messages: " + e.getMessage());
            }
        }, "Tunnely-LoadMessages").start();
    }

    private void initializeEncryption() {
        new Thread(() -> {
            System.out.println("[Tunnely E2EE] Initializing encryption for chat with: " + this.friendName);
            if (!EncryptionKeyManager.initializeKeys()) {
                this.f_96541_.execute(() -> {
                    this.encryptionReady = false;
                    this.encryptionStatus = "Failed to initialize your encryption keys";
                    System.err.println("[Tunnely E2EE] Failed to initialize own keys");
                });
                return;
            }
            EncryptionKeyManager.SyncResult syncResult = EncryptionKeyManager.synchronizeKeysWithFriend(this.friendId);
            this.f_96541_.execute(() -> {
                this.encryptionReady = syncResult.success;
                this.encryptionStatus = syncResult.message;
                if (syncResult.success) {
                    System.out.println("[Tunnely E2EE] \u2713 Encryption ready for chat");
                    this.setStatusMessage("\ud83d\udd12 End-to-end encryption enabled", 0x55FF55);
                } else {
                    System.out.println("[Tunnely E2EE] \u26a0 Encryption not available: " + syncResult.message);
                    this.setStatusMessage("\u26a0 " + syncResult.message, 0xFFAA00);
                }
            });
        }, "Tunnely-InitE2EE").start();
    }

    private void sendMessage() {
        String content = this.messageInput.m_94155_().trim();
        if (content.isEmpty()) {
            return;
        }
        if (content.length() > 1000) {
            this.setStatusMessage("\u00a7cMessage too long (max 1000 chars)", 0xFF5555);
            return;
        }
        this.messageInput.m_94144_("");
        this.setStatusMessage("\u00a7eSending...", 0xFFFF55);
        new Thread(() -> {
            try {
                String contentToSend;
                boolean isEncrypted = false;
                if (this.encryptionReady) {
                    EncryptionKeyManager.EncryptionResult encResult = EncryptionKeyManager.encryptMessage(content, this.friendId);
                    if (encResult.success) {
                        contentToSend = encResult.encryptedMessage;
                        isEncrypted = true;
                        System.out.println("[Tunnely E2EE] \u2713 Message encrypted before sending");
                    } else {
                        contentToSend = content;
                        System.err.println("[Tunnely E2EE] \u2717 Encryption failed: " + encResult.errorMessage);
                        this.f_96541_.execute(() -> this.setStatusMessage("\u26a0 Sending unencrypted (" + encResult.errorMessage + ")", 0xFFAA00));
                    }
                } else {
                    contentToSend = content;
                    System.out.println("[Tunnely E2EE] Sending unencrypted (encryption not ready)");
                }
                SupabaseClient client = new SupabaseClient();
                String messageId = client.sendMessage(this.friendId, contentToSend);
                boolean finalIsEncrypted = isEncrypted;
                this.f_96541_.execute(() -> {
                    if (messageId != null) {
                        if (finalIsEncrypted) {
                            this.setStatusMessage("\ud83d\udd12 Sent (encrypted)", 0x55FF55);
                        } else {
                            this.setStatusMessage("\u00a7aSent", 0x55FF55);
                        }
                        String userId = this.config.getSupabaseUserId();
                        String conversationId = this.generateConversationId(userId, this.friendId);
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
                        Message sentMessage = new Message(messageId, userId, this.friendId, content, dateFormat.format(new Date()), null, conversationId);
                        this.messages.add(sentMessage);
                        this.updateScrollBounds();
                        this.scrollToBottom();
                    } else {
                        this.setStatusMessage("\u00a7cFailed to send", 0xFF5555);
                    }
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> this.setStatusMessage("\u00a7cError: " + e.getMessage(), 0xFF5555));
                e.printStackTrace();
            }
        }, "Tunnely-SendMessage").start();
    }

    private void onNewMessage(Message message) {
        this.f_96541_.execute(() -> {
            for (Message existingMsg : this.messages) {
                if (!existingMsg.getId().equals(message.getId())) continue;
                return;
            }
            this.messages.add(message);
            this.lastMessageTime = System.currentTimeMillis();
            this.updateScrollBounds();
            if (this.autoScroll) {
                this.scrollToBottom();
            } else {
                this.setStatusMessage("\u00a7eNew message received", 0xFFFF55);
            }
            if (!message.isSentByUser(this.config.getSupabaseUserId())) {
                new Thread(() -> {
                    SupabaseClient client = new SupabaseClient();
                    client.markMessageAsRead(message.getId());
                }, "Tunnely-MarkRead").start();
            }
        });
    }

    private void markMessagesAsRead() {
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                String userId = this.config.getSupabaseUserId();
                for (Message msg : this.messages) {
                    if (msg.isSentByUser(userId) || msg.isRead()) continue;
                    client.markMessageAsRead(msg.getId());
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely Chat] Error marking messages as read: " + e.getMessage());
            }
        }, "Tunnely-MarkRead").start();
    }

    private Message parseMessage(JsonObject json) {
        try {
            String id = json.get("id").getAsString();
            String senderId = json.get("sender_id").getAsString();
            String recipientId = json.get("recipient_id").getAsString();
            String content = json.get("content").getAsString();
            String sentAt = json.get("sent_at").getAsString();
            String readAt = json.has("read_at") && !json.get("read_at").isJsonNull() ? json.get("read_at").getAsString() : null;
            String conversationId = json.get("conversation_id").getAsString();
            String userId = this.config.getSupabaseUserId();
            String displayContent = userId != null && senderId.equals(userId) ? (MessageEncryption.isEncrypted(content) ? "\ud83d\udd12 Sent (encrypted)" : content) : EncryptionKeyManager.decryptMessage(content);
            return new Message(id, senderId, recipientId, displayContent, sentAt, readAt, conversationId);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String generateConversationId(String userId1, String userId2) {
        if (userId1.compareTo(userId2) < 0) {
            return userId1 + "_" + userId2;
        }
        return userId2 + "_" + userId1;
    }

    private void updateScrollBounds() {
        int totalHeight = this.messages.size() * 35;
        int visibleHeight = this.f_96544_ - 110;
        this.maxScrollOffset = Math.max(0, totalHeight - visibleHeight);
    }

    private void scrollToBottom() {
        this.scrollOffset = this.maxScrollOffset;
        this.autoScroll = true;
    }

    private void setStatusMessage(String message, int color) {
        this.statusMessage = message;
        this.statusColor = color;
        this.statusMessageTime = System.currentTimeMillis();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        graphics.m_280137_(this.f_96547_, "\u00a76\u00a7l\ud83d\udcac Chat with " + this.friendName, centerX, 10, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int messagesTop = 30;
        int messagesBottom = this.f_96544_ - 70;
        graphics.m_280588_(0, messagesTop, this.f_96543_, messagesBottom);
        this.renderMessages(graphics, messagesTop, messagesBottom);
        graphics.m_280618_();
        if (this.maxScrollOffset > 0) {
            this.renderScrollbar(graphics, messagesTop, messagesBottom);
        }
        if (!this.statusMessage.isEmpty()) {
            long timeSinceStatus = System.currentTimeMillis() - this.statusMessageTime;
            if (timeSinceStatus < 3000L) {
                float alpha = 1.0f;
                if (timeSinceStatus > 2500L) {
                    alpha = (float)(3000L - timeSinceStatus) / 500.0f;
                }
                int alphaInt = (int)(alpha * 255.0f);
                int colorWithAlpha = alphaInt << 24 | this.statusColor & 0xFFFFFF;
                graphics.m_280137_(this.f_96547_, this.statusMessage, centerX, this.f_96544_ - 60, colorWithAlpha);
            } else {
                this.statusMessage = "";
            }
        }
        if (!this.autoScroll && this.maxScrollOffset > 0) {
            graphics.m_280137_(this.f_96547_, "\u00a7e\u25bc New messages below", centerX, messagesBottom - 15, 0xFFFF55);
        }
    }

    private void renderScrollbar(GuiGraphics graphics, int top, int bottom) {
        int scrollbarX = this.f_96543_ - 10;
        int scrollbarHeight = bottom - top;
        int visibleRatio = scrollbarHeight * 100 / (scrollbarHeight + this.maxScrollOffset);
        int thumbHeight = Math.max(20, scrollbarHeight * visibleRatio / 100);
        int thumbY = top + (int)((float)(scrollbarHeight - thumbHeight) * ((float)this.scrollOffset / (float)this.maxScrollOffset));
        graphics.m_280509_(scrollbarX, top, scrollbarX + 6, bottom, 0x40FFFFFF);
        graphics.m_280509_(scrollbarX, thumbY, scrollbarX + 6, thumbY + thumbHeight, -1426063361);
    }

    private void renderMessages(GuiGraphics graphics, int top, int bottom) {
        int y = top - this.scrollOffset;
        int centerX = this.f_96543_ / 2;
        String userId = this.config.getSupabaseUserId();
        if (this.messages.isEmpty()) {
            graphics.m_280137_(this.f_96547_, "\u00a77No messages yet", centerX, top + 50, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a77Send a message to start chatting!", centerX, top + 65, 0xAAAAAA);
            return;
        }
        for (Message msg : this.messages) {
            if (y > top - 35 && y < bottom) {
                boolean sentByMe = msg.isSentByUser(userId);
                this.renderMessage(graphics, msg, y, centerX, sentByMe);
            }
            y += 35;
        }
    }

    private void renderMessage(GuiGraphics graphics, Message msg, int y, int centerX, boolean sentByMe) {
        int messageWidth = 220;
        int messageX = sentByMe ? centerX + 10 : centerX - 230;
        int bgColor = sentByMe ? -2142996566 : -2141891243;
        int borderColor = sentByMe ? -11171636 : -8947849;
        graphics.m_280509_(messageX - 1, y - 1, messageX + messageWidth + 1, y + 35 - 4, borderColor);
        graphics.m_280509_(messageX, y, messageX + messageWidth, y + 35 - 5, bgColor);
        if (!sentByMe) {
            graphics.m_280488_(this.f_96547_, "\u00a7e" + this.friendName, messageX + 5, y + 3, 0xFFFF55);
        }
        String content = msg.getContent();
        int contentY = sentByMe ? y + 5 : y + 15;
        String timeStr = msg.getFormattedTime();
        String readReceipt = sentByMe && msg.isRead() ? " \u00a7a\u2713\u2713" : (sentByMe ? " \u00a77\u2713" : "");
        String timeDisplay = "\u00a77" + timeStr + readReceipt;
        int timeWidth = this.f_96547_.m_92895_(timeDisplay);
        int textAreaWidth = messageWidth - 10;
        int textWithTimestampWidth = messageWidth - timeWidth - 15;
        List<String> lines = this.wrapTextWithTimestampSpace(content, textAreaWidth, textWithTimestampWidth);
        for (int i = 0; i < Math.min(lines.size(), 2); ++i) {
            graphics.m_280488_(this.f_96547_, "\u00a7f" + lines.get(i), messageX + 5, contentY + i * 10, 0xFFFFFF);
        }
        graphics.m_280488_(this.f_96547_, timeDisplay, messageX + messageWidth - timeWidth - 5, y + 35 - 15, 0x888888);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private List<String> wrapTextWithTimestampSpace(String text, int fullWidth, int widthWithTimestamp) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        if (words.length == 0) {
            return lines;
        }
        StringBuilder line1 = new StringBuilder();
        StringBuilder line2 = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = line1.length() == 0 ? word : String.valueOf(line1) + " " + word;
            if (this.f_96547_.m_92895_(testLine) > widthWithTimestamp) break;
            if (line1.length() > 0) {
                line1.append(" ");
            }
            line1.append(word);
        }
        if (line1.toString().equals(text) || line1.length() == text.length()) {
            lines.add(line1.toString());
            return lines;
        }
        line1 = new StringBuilder();
        line2 = new StringBuilder();
        boolean onLine2 = false;
        for (String word : words) {
            String testLine;
            if (!onLine2) {
                String string = testLine = line1.length() == 0 ? word : String.valueOf(line1) + " " + word;
                if (this.f_96547_.m_92895_(testLine) <= fullWidth) {
                    if (line1.length() > 0) {
                        line1.append(" ");
                    }
                    line1.append(word);
                    continue;
                }
                onLine2 = true;
                line2.append(word);
                continue;
            }
            String string = testLine = line2.length() == 0 ? word : String.valueOf(line2) + " " + word;
            if (this.f_96547_.m_92895_(testLine) > widthWithTimestamp) break;
            if (line2.length() > 0) {
                line2.append(" ");
            }
            line2.append(word);
        }
        lines.add(line1.toString());
        if (line2.length() > 0) {
            lines.add(line2.toString());
        }
        return lines;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.messageInput.m_93696_()) {
            this.sendMessage();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.maxScrollOffset == 0) {
            return false;
        }
        int oldOffset = this.scrollOffset;
        this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - (int)(scrollDelta * 20.0)));
        this.autoScroll = this.scrollOffset >= this.maxScrollOffset - 10;
        return oldOffset != this.scrollOffset;
    }

    public void m_7379_() {
        MessageManager.getInstance().unsubscribeFromConversation(this.friendId);
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

