/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;

public class DirectJoinScreen
extends Screen {
    private final Screen parent;
    private EditBox endpointInput;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private Button connectButton;
    private Button helpButton;
    private boolean showHelpTooltip = false;

    public DirectJoinScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Direct Join"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 50;
        this.endpointInput = new EditBox(this.f_96547_, centerX - 150, startY, 300, 20, (Component)Component.m_237113_((String)"Tunnel Endpoint"));
        this.endpointInput.m_94199_(200);
        this.endpointInput.m_257771_((Component)Component.m_237113_((String)"relay-host:port/session-id"));
        this.endpointInput.m_94144_("");
        this.m_142416_((GuiEventListener)this.endpointInput);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udccb Paste"), button -> {
            String clipboard = this.f_96541_.f_91068_.m_90876_();
            this.endpointInput.m_94144_(clipboard);
            this.validateEndpoint(clipboard);
        }).m_252987_(centerX - 155, startY + 30, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Clear"), button -> {
            this.endpointInput.m_94144_("");
            this.statusMessage = "";
        }).m_252987_(centerX + 55, startY + 30, 100, 20).m_253136_());
        this.connectButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd17 Connect"), button -> this.connectToServer()).m_252987_(centerX - 100, startY + 60, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.connectButton);
        this.helpButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2139\ufe0f How to use"), button -> {}).m_252987_(centerX - 100, startY + 90, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.helpButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX - 100, this.f_96544_ - 30, 200, 20).m_253136_());
    }

    private boolean validateEndpoint(String endpoint) {
        if (endpoint == null || endpoint.trim().isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a tunnel endpoint";
            this.statusColor = 0xFF0000;
            return false;
        }
        if (!(endpoint = endpoint.trim()).contains(":") || !endpoint.contains("/")) {
            this.statusMessage = "\u00a7cInvalid format. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        String[] parts = endpoint.split("/", 2);
        if (parts.length != 2) {
            this.statusMessage = "\u00a7cInvalid format. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        String hostPort = parts[0];
        String sessionId = parts[1];
        if (!hostPort.contains(":")) {
            this.statusMessage = "\u00a7cMissing port. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        if (sessionId.trim().isEmpty()) {
            this.statusMessage = "\u00a7cMissing session ID";
            this.statusColor = 0xFF0000;
            return false;
        }
        this.statusMessage = "\u00a7aValid endpoint format \u2713";
        this.statusColor = 65280;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void connectToServer() {
        String sessionId;
        Object relayUrl;
        block5: {
            String endpoint = this.endpointInput.m_94155_().trim();
            if (!this.validateEndpoint(endpoint)) {
                return;
            }
            System.out.println("[Tunnely UI] Direct joining to endpoint: " + endpoint);
            if (endpoint.contains("://")) {
                int lastSlash = endpoint.lastIndexOf(47);
                if (lastSlash > 0 && lastSlash < endpoint.length() - 1) {
                    relayUrl = endpoint.substring(0, lastSlash);
                    sessionId = endpoint.substring(lastSlash + 1);
                    break block5;
                } else {
                    this.statusMessage = "\u00a7cInvalid endpoint format";
                    this.statusColor = 0xFF0000;
                    return;
                }
            }
            String[] parts = endpoint.split("/", 2);
            if (parts.length != 2) {
                this.statusMessage = "\u00a7cInvalid endpoint format";
                this.statusColor = 0xFF0000;
                return;
            }
            String relayHostPort = parts[0];
            sessionId = parts[1];
            relayUrl = "wss://" + relayHostPort;
            System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
        }
        this.statusMessage = "\u00a7eConnecting to server...";
        this.statusColor = 0xFFFF00;
        ClientTunnelManager clientManager = ClientTunnelManager.getInstance();
        clientManager.connectToServer((String)relayUrl, sessionId, () -> this.f_96541_.execute(() -> {
            this.statusMessage = "\u00a7aConnecting to Minecraft server...";
            this.statusColor = 65280;
            System.out.println("[Tunnely UI] Successfully connected through tunnel!");
        }), error -> this.f_96541_.execute(() -> {
            System.err.println("[Tunnely UI] Connection error: " + error);
            String errorType = this.categorizeError((String)error);
            this.f_96541_.m_91152_((Screen)new ConnectionInfoScreen(this.parent, "Direct Connection", errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::connectToServer : null));
        }));
    }

    private String categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lowerError = error.toLowerCase();
        if (lowerError.contains("full") || lowerError.contains("capacity")) {
            return "FULL";
        }
        if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lowerError.contains("not found") || lowerError.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lowerError.contains("incompatible") || lowerError.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Enter a tunnel endpoint to connect directly", this.f_96543_ / 2, 35, 0xAAAAAA);
        graphics.m_280488_(this.f_96547_, "\u00a7eTunnel Endpoint:", this.f_96543_ / 2 - 150, this.f_96544_ / 2 - 65, 0xFFFF00);
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, this.f_96544_ / 2 + 20, this.statusColor);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.showHelpTooltip = this.helpButton.m_5953_((double)mouseX, (double)mouseY);
        if (this.showHelpTooltip) {
            int tooltipX = mouseX + 10;
            int tooltipY = mouseY - 10;
            int tooltipWidth = 280;
            int tooltipHeight = 80;
            if (tooltipX + tooltipWidth > this.f_96543_) {
                tooltipX = this.f_96543_ - tooltipWidth - 5;
            }
            if (tooltipY + tooltipHeight > this.f_96544_) {
                tooltipY = this.f_96544_ - tooltipHeight - 5;
            }
            if (tooltipY < 5) {
                tooltipY = 5;
            }
            graphics.m_280509_(tooltipX - 5, tooltipY - 5, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -267386864);
            graphics.m_280637_(tooltipX - 5, tooltipY - 5, tooltipWidth + 5, tooltipHeight + 5, -11513776);
            int textY = tooltipY;
            graphics.m_280488_(this.f_96547_, "\u00a76How to use Direct Join:", tooltipX, textY, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "\u00a771. Get endpoint from a friend", tooltipX, textY += 14, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, "\u00a772. Paste it in the box above", tooltipX, textY += 12, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, "\u00a773. Click Connect", tooltipX, textY += 12, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, "\u00a774. Add server in multiplayer menu", tooltipX, textY += 12, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, "\u00a78Example: relay.example.com:8080/abc-123", tooltipX, textY += 16, 0x888888);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.endpointInput.m_94120_();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String text = this.endpointInput.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.endpointInput.m_94144_(text);
    }

    public boolean m_7043_() {
        return false;
    }
}

