/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;

public class FriendsScreen
extends Screen {
    private final Screen parent;
    private FriendListWidget friendList;
    private EditBox friendEmailBox;
    private String statusMessage = "\u00a7eLoading friends...";
    private int statusColor = 0xFFFF00;

    public FriendsScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Friends"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int inputWidth = 200;
        int centerX = this.f_96543_ / 2 - inputWidth / 2;
        this.friendEmailBox = new EditBox(this.f_96547_, centerX, this.f_96544_ - 95, inputWidth - 70, 20, (Component)Component.m_237113_((String)"Minecraft Username"));
        this.friendEmailBox.m_94199_(16);
        this.friendEmailBox.m_257771_((Component)Component.m_237113_((String)"Minecraft username"));
        this.m_142416_((GuiEventListener)this.friendEmailBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Add"), button -> this.addFriend()).m_252987_(centerX + inputWidth - 65, this.f_96544_ - 95, 60, 20).m_253136_());
        this.friendList = new FriendListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 50, this.f_96544_ - 110, 35);
        this.m_7787_((GuiEventListener)this.friendList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd04 Refresh"), button -> this.loadFriends()).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 50, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 55, this.f_96544_ - 50, 100, 20).m_253136_());
        this.loadFriends();
    }

    private void addFriend() {
        String username = this.friendEmailBox.m_94155_().trim();
        if (username.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a username";
            this.statusColor = 0xFF0000;
            return;
        }
        if (!username.matches("^[a-zA-Z0-9_]{3,16}$")) {
            this.statusMessage = "\u00a7cInvalid Minecraft username";
            this.statusColor = 0xFF0000;
            System.err.println("[Tunnely UI] Invalid username format: " + username);
            return;
        }
        System.out.println("[Tunnely UI] ===== ADDING FRIEND =====");
        System.out.println("[Tunnely UI] Username: " + username);
        this.statusMessage = "\u00a7eSending friend request...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.sendFriendRequestByUsername(username);
                this.f_96541_.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aFriend request sent to " + username + "!";
                        this.statusColor = 65280;
                        this.friendEmailBox.m_94144_("");
                        System.out.println("[Tunnely UI] \u2713 Friend request succeeded, reloading list");
                        this.loadFriends();
                    } else {
                        this.statusMessage = "\u00a7cUser not found or request failed";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Friend request failed for: " + username);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception adding friend: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-AddFriend").start();
    }

    private void loadFriends() {
        System.out.println("[Tunnely UI] ===== LOADING FRIENDS =====");
        this.statusMessage = "\u00a7eLoading friends...";
        this.statusColor = 0xFFFF00;
        this.friendList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.FriendListResult result = client.getFriends();
                this.f_96541_.execute(() -> {
                    block7: {
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing friends data...");
                                JsonArray friends = JsonParser.parseString((String)result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + friends.size() + " friend(s)");
                                if (friends.size() == 0) {
                                    this.statusMessage = "\u00a77No friends yet. Add some above!";
                                    this.statusColor = 0xAAAAAA;
                                    break block7;
                                }
                                for (JsonElement element : friends) {
                                    JsonObject friendProfile;
                                    JsonObject friend = element.getAsJsonObject();
                                    String friendId = friend.get("id").getAsString();
                                    String minecraftName = "Unknown";
                                    if (friend.has("friend") && !friend.get("friend").isJsonNull() && (friendProfile = friend.getAsJsonObject("friend")).has("minecraft_name")) {
                                        minecraftName = friendProfile.get("minecraft_name").getAsString();
                                    }
                                    String status = friend.has("status") ? friend.get("status").getAsString() : "unknown";
                                    System.out.println("[Tunnely UI] Friend: " + minecraftName + " (status: " + status + ")");
                                    this.friendList.addFriend(friendId, minecraftName, status);
                                }
                                this.statusMessage = "\u00a7a" + friends.size() + " friend(s)";
                                this.statusColor = 65280;
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse friends list";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing friends: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load friends: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading friends: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadFriends").start();
    }

    private void removeFriend(String friendId) {
        System.out.println("[Tunnely UI] ===== REMOVING FRIEND =====");
        System.out.println("[Tunnely UI] Friend ID: " + friendId);
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.removeFriend(friendId);
                this.f_96541_.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aFriend removed";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Friend removed successfully");
                        this.loadFriends();
                    } else {
                        this.statusMessage = "\u00a7cFailed to remove friend";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to remove friend");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception removing friend: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-RemoveFriend").start();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.friendList.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, "\u00a76\u00a7lManage Friends", this.f_96543_ / 2, 20, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, 35, this.statusColor);
        graphics.m_280488_(this.f_96547_, "Add Friend (Minecraft name):", this.f_96543_ / 2 - 100, this.f_96544_ - 110, 0xFFFFFF);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class FriendListWidget
    extends ObjectSelectionList<FriendEntry> {
        public FriendListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
        }

        public void clear() {
            this.m_93516_();
        }

        public void addFriend(String id, String name, String status) {
            this.m_7085_((AbstractSelectionList.Entry)new FriendEntry(id, name, status));
        }

        class FriendEntry
        extends ObjectSelectionList.Entry<FriendEntry> {
            private final String id;
            private final String name;
            private final String status;
            private final Button removeButton;

            public FriendEntry(String id, String name, String status) {
                this.id = id;
                this.name = name;
                this.status = status;
                this.removeButton = Button.m_253074_((Component)Component.m_237113_((String)"Remove"), button -> FriendsScreen.this.removeFriend(id)).m_252987_(0, 0, 70, 20).m_253136_();
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                graphics.m_280488_(FriendsScreen.this.f_96547_, "\u00a7b" + this.name, left + 5, top + 5, 0xFFFFFF);
                String statusText = this.status.equals("accepted") ? "\u00a7a\u2713 Friends" : (this.status.equals("pending") ? "\u00a7e\u23f3 Pending" : "\u00a77Unknown");
                graphics.m_280488_(FriendsScreen.this.f_96547_, statusText, left + 5, top + 18, 0xFFFFFF);
                this.removeButton.m_252865_(left + width - 80);
                this.removeButton.m_253211_(top + 7);
                this.removeButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.removeButton.m_6375_(mouseX, mouseY, button);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)(this.name + " - " + this.status));
            }
        }
    }
}

