/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.worlds.WorldNotification;
import org.texboobcat.tunnelyrefab.worlds.ui.NotificationBell;
import org.texboobcat.tunnelyrefab.worlds.ui.NotificationPanelData;

public class NotificationPanelScreen
extends Screen {
    private final Screen parent;
    private final NotificationBell notificationBell;
    private List<NotificationPanelData.NotificationItem> items;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private NotificationPanelData.NotificationItem hoveredItem = null;

    public NotificationPanelScreen(Screen parent, NotificationBell notificationBell) {
        super((Component)Component.m_237113_((String)"Notifications"));
        this.parent = parent;
        this.notificationBell = notificationBell;
        List<WorldNotification> notifications = notificationBell.getNotifications();
        this.items = NotificationPanelData.formatNotifications(notifications);
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int buttonY = this.f_96544_ - 30;
        if (this.notificationBell.getUnreadCount() > 0) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Mark All Read"), button -> this.markAllRead()).m_252987_(centerX - 105, buttonY, 100, 20).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 5, buttonY, 100, 20).m_253136_());
        this.updateMaxScroll();
    }

    private void markAllRead() {
        this.notificationBell.markAllAsRead();
        this.f_96541_.m_91152_((Screen)new NotificationPanelScreen(this.parent, this.notificationBell));
    }

    private void updateMaxScroll() {
        int contentHeight = this.items.size() * 70;
        int visibleHeight = this.f_96544_ - 120;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        String title = NotificationPanelData.getPanelHeader(this.notificationBell.getUnreadCount());
        graphics.m_280137_(this.f_96547_, title, this.f_96543_ / 2, 15, 0xFFFFFF);
        this.renderNotifications(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.maxScrollOffset > 0) {
            graphics.m_280488_(this.f_96547_, "\u2195 Scroll for more", this.f_96543_ / 2 - 40, this.f_96544_ - 50, 0x888888);
        }
    }

    private void renderNotifications(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 40;
        int endY = this.f_96544_ - 60;
        int centerX = this.f_96543_ / 2;
        int contentWidth = Math.min(500, this.f_96543_ - 40);
        int contentX = centerX - contentWidth / 2;
        graphics.m_280588_(0, startY, this.f_96543_, endY);
        if (this.items.isEmpty()) {
            graphics.m_280137_(this.f_96547_, NotificationPanelData.getEmptyMessage(), centerX, startY + 30, 0x888888);
        } else {
            int y = startY - this.scrollOffset;
            this.hoveredItem = null;
            for (NotificationPanelData.NotificationItem item : this.items) {
                boolean hovered;
                boolean bl = hovered = mouseX >= contentX && mouseX <= contentX + contentWidth && mouseY >= y && mouseY <= y + 65;
                if (hovered) {
                    this.hoveredItem = item;
                }
                this.renderNotificationItem(graphics, item, contentX, y, contentWidth, hovered);
                y += 70;
            }
        }
        graphics.m_280618_();
    }

    private void renderNotificationItem(GuiGraphics graphics, NotificationPanelData.NotificationItem item, int x, int y, int width, boolean hovered) {
        Object message;
        int bgColor = item.backgroundColor;
        if (bgColor == 0) {
            bgColor = hovered ? 0x40404040 : 0x40202020;
        }
        graphics.m_280509_(x, y, x + width, y + 65, bgColor);
        graphics.m_280509_(x, y, x + width, y + 1, -12566464);
        graphics.m_280488_(this.f_96547_, item.icon, x + 5, y + 5, item.textColor);
        graphics.m_280488_(this.f_96547_, item.title, x + 25, y + 5, item.textColor);
        if (!item.isRead) {
            graphics.m_280509_(x + width - 10, y + 5, x + width - 5, y + 10, -13408513);
        }
        if (this.f_96547_.m_92895_((String)(message = item.message)) > width - 30) {
            while (this.f_96547_.m_92895_((String)message + "...") > width - 30 && ((String)message).length() > 0) {
                message = ((String)message).substring(0, ((String)message).length() - 1);
            }
            message = (String)message + "...";
        }
        graphics.m_280488_(this.f_96547_, (String)message, x + 25, y + 20, 0xAAAAAA);
        graphics.m_280488_(this.f_96547_, "\u00a77" + item.time, x + 25, y + 35, 0x888888);
        if (item.isCritical) {
            graphics.m_280488_(this.f_96547_, "\u00a7c\u00a7l!", x + width - 20, y + 5, -52429);
        }
        if (hovered) {
            graphics.m_280488_(this.f_96547_, "\u00a77Click to mark as read", x + 5, y + 50, 0x666666);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredItem != null) {
            if (!this.hoveredItem.isRead) {
                this.notificationBell.markAsRead(this.hoveredItem.id);
                this.f_96541_.m_91152_((Screen)new NotificationPanelScreen(this.parent, this.notificationBell));
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }
}

