/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUpdateScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.WorldUploadRequest;

public class WorldEditScreen
extends Screen {
    private final Screen parent;
    private final WorldInfo existingWorld;
    private final String selectedLocalWorld;
    private final WorldManager worldManager;
    private EditBox nameBox;
    private EditBox descriptionBox;
    private EditBox tagsBox;
    private EditBox minecraftVersionBox;
    private String worldType;
    private boolean isPublic;
    private boolean pruneChunks = true;
    private String statusMessage = "";
    private boolean updating = false;
    private int uploadProgress = 0;
    private static final String[] WORLD_TYPES = new String[]{"Survival", "Creative", "Adventure", "Hardcore", "Skyblock", "Modded"};
    private int worldTypeIndex = 0;

    public WorldEditScreen(Screen parent, WorldInfo existingWorld, String selectedLocalWorld) {
        super((Component)Component.m_237113_((String)"Edit World Metadata"));
        this.parent = parent;
        this.existingWorld = existingWorld;
        this.selectedLocalWorld = selectedLocalWorld;
        this.worldManager = new WorldManager();
        this.worldType = existingWorld.getWorldType();
        this.isPublic = existingWorld.isPublic();
        for (int i = 0; i < WORLD_TYPES.length; ++i) {
            if (!WORLD_TYPES[i].equals(this.worldType)) continue;
            this.worldTypeIndex = i;
            break;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int fieldWidth = 300;
        this.nameBox = new EditBox(this.f_96547_, centerX - fieldWidth / 2, startY, fieldWidth, 20, (Component)Component.m_237113_((String)"World Name"));
        this.nameBox.m_94199_(100);
        this.nameBox.m_94144_(this.existingWorld.getName());
        this.m_142416_((GuiEventListener)this.nameBox);
        this.descriptionBox = new EditBox(this.f_96547_, centerX - fieldWidth / 2, startY + 40, fieldWidth, 20, (Component)Component.m_237113_((String)"Description"));
        this.descriptionBox.m_94199_(500);
        this.descriptionBox.m_94144_(this.existingWorld.getDescription());
        this.m_142416_((GuiEventListener)this.descriptionBox);
        this.tagsBox = new EditBox(this.f_96547_, centerX - fieldWidth / 2, startY + 80, fieldWidth, 20, (Component)Component.m_237113_((String)"Tags"));
        this.tagsBox.m_94199_(200);
        this.tagsBox.m_94144_(String.join((CharSequence)", ", this.existingWorld.getTags()));
        this.m_142416_((GuiEventListener)this.tagsBox);
        this.minecraftVersionBox = new EditBox(this.f_96547_, centerX - fieldWidth / 2, startY + 120, fieldWidth, 20, (Component)Component.m_237113_((String)"Minecraft Version"));
        this.minecraftVersionBox.m_94199_(20);
        this.minecraftVersionBox.m_94144_(this.existingWorld.getMinecraftVersion());
        this.m_142416_((GuiEventListener)this.minecraftVersionBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Type: " + this.worldType)), button -> {
            this.worldTypeIndex = (this.worldTypeIndex + 1) % WORLD_TYPES.length;
            this.worldType = WORLD_TYPES[this.worldTypeIndex];
            button.m_93666_((Component)Component.m_237113_((String)("Type: " + this.worldType)));
        }).m_252987_(centerX - fieldWidth / 2, startY + 160, fieldWidth / 2 - 5, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.isPublic ? "Public" : "Private")), button -> {
            this.isPublic = !this.isPublic;
            button.m_93666_((Component)Component.m_237113_((String)(this.isPublic ? "Public" : "Private")));
        }).m_252987_(centerX + 5, startY + 160, fieldWidth / 2 - 5, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Prune: " + (this.pruneChunks ? "ON" : "OFF"))), button -> {
            this.pruneChunks = !this.pruneChunks;
            button.m_93666_((Component)Component.m_237113_((String)("Prune: " + (this.pruneChunks ? "ON" : "OFF"))));
        }).m_252987_(centerX - fieldWidth / 2, startY + 190, fieldWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Update World"), button -> this.updateWorld()).m_252987_(centerX - 105, this.f_96544_ - 30, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 10, this.f_96544_ - 30, 100, 20).m_253136_());
    }

    private void updateWorld() {
        if (this.updating) {
            return;
        }
        String name = this.nameBox.m_94155_().trim();
        if (name.isEmpty()) {
            this.statusMessage = "\u00a7cWorld name cannot be empty";
            return;
        }
        String description = this.descriptionBox.m_94155_().trim();
        if (description.isEmpty()) {
            this.statusMessage = "\u00a7cDescription cannot be empty";
            return;
        }
        String version = this.minecraftVersionBox.m_94155_().trim();
        if (version.isEmpty()) {
            this.statusMessage = "\u00a7cMinecraft version cannot be empty";
            return;
        }
        this.updating = true;
        this.statusMessage = "Preparing update...";
        this.uploadProgress = 0;
        new Thread(() -> {
            try {
                String tagsInput = this.tagsBox.m_94155_().trim();
                ArrayList<String> tags = new ArrayList();
                if (!tagsInput.isEmpty()) {
                    tags = Arrays.asList(tagsInput.split("\\s*,\\s*"));
                }
                WorldUploadRequest request = new WorldUploadRequest();
                request.setWorldFolderName(this.selectedLocalWorld);
                request.setWorldName(name);
                request.setDescription(description);
                request.setMinecraftVersion(version);
                request.setWorldType(this.worldType);
                request.setTags(tags);
                request.setPublic(this.isPublic);
                request.setPruneUninhabitedChunks(this.pruneChunks);
                request.setProgressCallback((percentage, currentFile) -> this.f_96541_.execute(() -> {
                    this.uploadProgress = percentage;
                    this.statusMessage = "Updating... " + percentage + "%";
                }));
                WorldManager.UploadResult result = this.worldManager.updateWorld(this.existingWorld.getId(), request);
                this.f_96541_.execute(() -> {
                    this.updating = false;
                    if (result.isSuccess()) {
                        this.statusMessage = "\u00a7a\u2713 World updated successfully!";
                        new Thread(() -> {
                            try {
                                Thread.sleep(2000L);
                                this.f_96541_.execute(() -> this.f_96541_.m_91152_(this.parent instanceof WorldUpdateScreen ? ((WorldUpdateScreen)this.parent).getParent() : this.parent));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }).start();
                    } else {
                        this.statusMessage = "\u00a7c\u2717 " + result.getMessage();
                    }
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.updating = false;
                    this.statusMessage = "\u00a7cUpdate failed: " + e.getMessage();
                });
            }
        }).start();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280137_(this.f_96547_, "Update: " + this.existingWorld.getName(), this.f_96543_ / 2, 15, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Edit metadata and upload new world file", this.f_96543_ / 2, 30, 0xAAAAAA);
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int fieldWidth = 300;
        graphics.m_280488_(this.f_96547_, "World Name:", centerX - fieldWidth / 2, startY - 10, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Description:", centerX - fieldWidth / 2, startY + 30, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Tags (comma separated):", centerX - fieldWidth / 2, startY + 70, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Minecraft Version:", centerX - fieldWidth / 2, startY + 110, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Local world: \u00a7b" + this.selectedLocalWorld, this.f_96543_ / 2, startY + 220, 0xAAAAAA);
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, startY + 240, 0xFFFFFF);
        }
        if (this.updating && this.uploadProgress > 0) {
            int barWidth = 300;
            int barX = this.f_96543_ / 2 - barWidth / 2;
            int barY = startY + 260;
            graphics.m_280509_(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.m_280509_(barX, barY, barX + barWidth * this.uploadProgress / 100, barY + 10, -2147439873);
            graphics.m_280509_(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.m_280509_(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

