/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.util;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ContentModerator {
    private static final List<String> BLOCKED_WORDS = Arrays.asList("nigger", "nigg", "n1gg", "nig", "n1g", "fag", "faggot", "f4g", "fuck", "shit", "bitch", "cunt", "whore", "slut", "hitler", "nazi", "kike", "retard", "retarded", "rape", "rapist");
    private static final Pattern SPECIAL_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9]");
    private static final Map<Character, Character> HOMOGLYPH_MAP = ContentModerator.createHomoglyphMap();

    private static Map<Character, Character> createHomoglyphMap() {
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        map.put(Character.valueOf('\u0131'), Character.valueOf('i'));
        map.put(Character.valueOf('\u0456'), Character.valueOf('i'));
        map.put(Character.valueOf('\u026a'), Character.valueOf('i'));
        map.put(Character.valueOf('\u01d0'), Character.valueOf('i'));
        map.put(Character.valueOf('\u00ec'), Character.valueOf('i'));
        map.put(Character.valueOf('\u00ed'), Character.valueOf('i'));
        map.put(Character.valueOf('\u00ef'), Character.valueOf('i'));
        map.put(Character.valueOf('\u012b'), Character.valueOf('i'));
        map.put(Character.valueOf('\u0268'), Character.valueOf('i'));
        map.put(Character.valueOf('1'), Character.valueOf('i'));
        map.put(Character.valueOf('|'), Character.valueOf('i'));
        map.put(Character.valueOf('!'), Character.valueOf('i'));
        map.put(Character.valueOf('l'), Character.valueOf('i'));
        map.put(Character.valueOf('\u0430'), Character.valueOf('a'));
        map.put(Character.valueOf('\u0103'), Character.valueOf('a'));
        map.put(Character.valueOf('\u03ac'), Character.valueOf('a'));
        map.put(Character.valueOf('\u03b1'), Character.valueOf('a'));
        map.put(Character.valueOf('\u00e0'), Character.valueOf('a'));
        map.put(Character.valueOf('\u00e1'), Character.valueOf('a'));
        map.put(Character.valueOf('\u00e2'), Character.valueOf('a'));
        map.put(Character.valueOf('\u00e4'), Character.valueOf('a'));
        map.put(Character.valueOf('@'), Character.valueOf('a'));
        map.put(Character.valueOf('4'), Character.valueOf('a'));
        map.put(Character.valueOf('\u0435'), Character.valueOf('e'));
        map.put(Character.valueOf('\u0117'), Character.valueOf('e'));
        map.put(Character.valueOf('\u011b'), Character.valueOf('e'));
        map.put(Character.valueOf('\u00e8'), Character.valueOf('e'));
        map.put(Character.valueOf('\u00e9'), Character.valueOf('e'));
        map.put(Character.valueOf('\u00ea'), Character.valueOf('e'));
        map.put(Character.valueOf('\u00eb'), Character.valueOf('e'));
        map.put(Character.valueOf('3'), Character.valueOf('e'));
        map.put(Character.valueOf('\u043e'), Character.valueOf('o'));
        map.put(Character.valueOf('\u03bf'), Character.valueOf('o'));
        map.put(Character.valueOf('\u00f2'), Character.valueOf('o'));
        map.put(Character.valueOf('\u00f3'), Character.valueOf('o'));
        map.put(Character.valueOf('\u00f4'), Character.valueOf('o'));
        map.put(Character.valueOf('\u00f6'), Character.valueOf('o'));
        map.put(Character.valueOf('\u00f8'), Character.valueOf('o'));
        map.put(Character.valueOf('0'), Character.valueOf('o'));
        map.put(Character.valueOf('\u0121'), Character.valueOf('g'));
        map.put(Character.valueOf('\u011f'), Character.valueOf('g'));
        map.put(Character.valueOf('\u0123'), Character.valueOf('g'));
        map.put(Character.valueOf('9'), Character.valueOf('g'));
        map.put(Character.valueOf('q'), Character.valueOf('g'));
        map.put(Character.valueOf('\u0144'), Character.valueOf('n'));
        map.put(Character.valueOf('\u00f1'), Character.valueOf('n'));
        map.put(Character.valueOf('\u0148'), Character.valueOf('n'));
        map.put(Character.valueOf('\u0433'), Character.valueOf('r'));
        map.put(Character.valueOf('\u0159'), Character.valueOf('r'));
        map.put(Character.valueOf('\u0455'), Character.valueOf('s'));
        map.put(Character.valueOf('\u0161'), Character.valueOf('s'));
        map.put(Character.valueOf('\u015b'), Character.valueOf('s'));
        map.put(Character.valueOf('$'), Character.valueOf('s'));
        map.put(Character.valueOf('5'), Character.valueOf('s'));
        map.put(Character.valueOf('\u03c5'), Character.valueOf('u'));
        map.put(Character.valueOf('\u00f9'), Character.valueOf('u'));
        map.put(Character.valueOf('\u00fa'), Character.valueOf('u'));
        map.put(Character.valueOf('\u00fb'), Character.valueOf('u'));
        map.put(Character.valueOf('\u00fc'), Character.valueOf('u'));
        map.put(Character.valueOf('\u0441'), Character.valueOf('c'));
        map.put(Character.valueOf('\u00e7'), Character.valueOf('c'));
        map.put(Character.valueOf('\u0107'), Character.valueOf('c'));
        map.put(Character.valueOf('\u010d'), Character.valueOf('c'));
        map.put(Character.valueOf('\u0137'), Character.valueOf('k'));
        map.put(Character.valueOf('\u0442'), Character.valueOf('t'));
        map.put(Character.valueOf('\u0163'), Character.valueOf('t'));
        map.put(Character.valueOf('\u0165'), Character.valueOf('t'));
        map.put(Character.valueOf('\u01b0'), Character.valueOf('w'));
        map.put(Character.valueOf('\u0445'), Character.valueOf('x'));
        map.put(Character.valueOf('\u0443'), Character.valueOf('y'));
        map.put(Character.valueOf('\u00fd'), Character.valueOf('y'));
        map.put(Character.valueOf('\u00ff'), Character.valueOf('y'));
        map.put(Character.valueOf('\u017e'), Character.valueOf('z'));
        map.put(Character.valueOf('\u017a'), Character.valueOf('z'));
        map.put(Character.valueOf('\u017c'), Character.valueOf('z'));
        return map;
    }

    private static String normalizeText(String text) {
        if (text == null) {
            return "";
        }
        String normalized = Normalizer.normalize(text, Normalizer.Form.NFD);
        normalized = normalized.replaceAll("\\p{M}", "");
        StringBuilder sb = new StringBuilder(normalized.length());
        for (char c : normalized.toLowerCase().toCharArray()) {
            Character replacement = HOMOGLYPH_MAP.get(Character.valueOf(c));
            sb.append(replacement != null ? replacement.charValue() : c);
        }
        return sb.toString();
    }

    public static boolean isAppropriate(String text) {
        if (text == null || text.trim().isEmpty()) {
            return false;
        }
        String normalized = ContentModerator.normalizeText(text);
        String noSpecialChars = SPECIAL_CHAR_PATTERN.matcher(normalized).replaceAll("");
        String leetNormalized = noSpecialChars.replace("1", "i").replace("3", "e").replace("4", "a").replace("5", "s").replace("7", "t").replace("8", "b").replace("9", "g").replace("0", "o");
        for (String blockedWord : BLOCKED_WORDS) {
            if (normalized.contains(blockedWord) || noSpecialChars.contains(blockedWord) || leetNormalized.contains(blockedWord)) {
                return false;
            }
            if (!ContentModerator.containsWordWithSeparators(normalized, blockedWord) && !ContentModerator.containsWordWithSeparators(noSpecialChars, blockedWord)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsWordWithSeparators(String text, String word) {
        if (word.length() < 2) {
            return text.contains(word);
        }
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            pattern.append(Pattern.quote(String.valueOf(word.charAt(i))));
            if (i >= word.length() - 1) continue;
            pattern.append(".{0,3}?");
        }
        return Pattern.compile(pattern.toString()).matcher(text).find();
    }

    public static ValidationResult validateServerName(String serverName) {
        if (serverName == null || serverName.trim().isEmpty()) {
            return new ValidationResult(false, "Server name cannot be empty");
        }
        String trimmed = serverName.trim();
        if (trimmed.length() < 3) {
            return new ValidationResult(false, "Server name must be at least 3 characters");
        }
        if (trimmed.length() > 32) {
            return new ValidationResult(false, "Server name must be 32 characters or less");
        }
        if (!ContentModerator.isAppropriate(trimmed)) {
            return new ValidationResult(false, "Server name contains inappropriate content");
        }
        return new ValidationResult(true, null);
    }

    public static class ValidationResult {
        public final boolean valid;
        public final String errorMessage;

        public ValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }
    }
}

