/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ContentModerator {
    private static final Set<String> BLOCKED_WORDS = new HashSet<String>(Arrays.asList("fuck", "shit", "bitch", "ass", "damn", "hell", "crap", "piss", "bastard", "whore", "slut", "dick", "cock", "pussy", "cunt", "motherfucker", "asshole", "douche", "twat", "wanker", "bollocks"));
    private static final Set<String> HATE_PATTERNS = new HashSet<String>(Arrays.asList("kill yourself", "kys", "end yourself", "hang yourself", "jump off", "slit your wrists", "drink bleach", "overdose", "shoot up", "mass shooting", "bomb", "blow up", "kill them", "murder", "genocide", "ethnic cleansing", "gas chamber", "lynch", "nazi", "hitler", "heil hitler", "white power", "white supremacy", "kkk", "ku klux klan", "master race", "race war", "day of the rope", "rape", "molest", "pedophile", "pedo", "child abuse", "groom", "subhuman", "untermensch", "vermin", "infestation", "plague"));
    private static final Map<Pattern, String> SLUR_PATTERNS = new HashMap<Pattern, String>();
    private static final Pattern EXCESSIVE_CAPS;
    private static final Pattern EXCESSIVE_PUNCTUATION;
    private static final Pattern URL_PATTERN;
    private static final Pattern REPEATED_CHARS;
    private static final Pattern OBFUSCATION_PATTERN;

    public static ModerationResult moderate(String content) {
        if (content == null || content.trim().isEmpty()) {
            return new ModerationResult(false, "Empty content", Collections.emptyList(), "", 0);
        }
        String normalized = ContentModerator.normalizeText(content);
        ArrayList<String> flaggedWords = new ArrayList<String>();
        int severityScore = 0;
        if (content.length() > 500) {
            return new ModerationResult(false, "Comment too long (max 500 characters)", flaggedWords, content, 0);
        }
        if (content.trim().length() < 2) {
            return new ModerationResult(false, "Comment too short", flaggedWords, content, 0);
        }
        for (String string : HATE_PATTERNS) {
            if (!normalized.contains(string.replaceAll("[^a-z0-9]", ""))) continue;
            flaggedWords.add(string);
            severityScore += 100;
        }
        if (severityScore >= 100) {
            return new ModerationResult(false, "Hate speech detected", flaggedWords, content, severityScore);
        }
        for (Map.Entry entry : SLUR_PATTERNS.entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(normalized).find()) continue;
            flaggedWords.add((String)entry.getValue());
            severityScore += 100;
        }
        if (severityScore >= 100) {
            return new ModerationResult(false, "Hateful slur detected", flaggedWords, content, severityScore);
        }
        for (String string : BLOCKED_WORDS) {
            if (!normalized.contains(string)) continue;
            flaggedWords.add(string);
            severityScore += 10;
        }
        if (flaggedWords.size() >= 3) {
            return new ModerationResult(false, "Excessive profanity", flaggedWords, content, severityScore);
        }
        if (EXCESSIVE_CAPS.matcher(content).find()) {
            return new ModerationResult(false, "Excessive caps (spam)", flaggedWords, content, severityScore);
        }
        if (EXCESSIVE_PUNCTUATION.matcher(content).find()) {
            return new ModerationResult(false, "Excessive punctuation (spam)", flaggedWords, content, severityScore);
        }
        if (URL_PATTERN.matcher(content).find()) {
            return new ModerationResult(false, "URLs not allowed", flaggedWords, content, severityScore);
        }
        if (REPEATED_CHARS.matcher(content).find()) {
            return new ModerationResult(false, "Repeated characters (spam)", flaggedWords, content, severityScore);
        }
        if (ContentModerator.containsInvisibleCharacters(content)) {
            return new ModerationResult(false, "Invalid characters detected", flaggedWords, content, severityScore);
        }
        if (ContentModerator.containsSuspiciousUnicode(content)) {
            return new ModerationResult(false, "Suspicious characters detected", flaggedWords, content, severityScore);
        }
        if (ContentModerator.detectObfuscation(content, normalized)) {
            return new ModerationResult(false, "Suspicious character patterns", flaggedWords, content, severityScore);
        }
        String sanitized = ContentModerator.sanitizeContent(content);
        if (!flaggedWords.isEmpty() && severityScore < 30) {
            return new ModerationResult(true, "Approved with warnings", flaggedWords, sanitized, severityScore);
        }
        return new ModerationResult(true, "Approved", flaggedWords, sanitized, severityScore);
    }

    private static String normalizeText(String text) {
        String normalized = ContentModerator.normalizeHomoglyphs(text);
        normalized = normalized.toLowerCase();
        normalized = normalized.replace("0", "o").replace("1", "i").replace("3", "e").replace("4", "a").replace("5", "s").replace("7", "t").replace("8", "b").replace("@", "a").replace("$", "s").replace("!", "i").replace("|", "i").replace("()", "o").replace("[]", "o").replace("ph", "f").replace("&", "and");
        normalized = normalized.replaceAll("[^a-z0-9]", "");
        normalized = normalized.replaceAll("(.)\\1{2,}", "$1$1");
        return normalized;
    }

    private static boolean detectObfuscation(String original, String normalized) {
        double compressionRatio = (double)normalized.length() / (double)original.length();
        if (compressionRatio < 0.5 && original.length() > 10) {
            return true;
        }
        int specialCharCount = 0;
        int letterCount = 0;
        for (char c : original.toCharArray()) {
            if (Character.isLetter(c)) {
                ++letterCount;
                continue;
            }
            if (Character.isWhitespace(c) || Character.isDigit(c)) continue;
            ++specialCharCount;
        }
        return letterCount > 0 && (double)specialCharCount / (double)letterCount > 0.4;
    }

    private static String sanitizeContent(String content) {
        String sanitized = content.trim();
        sanitized = sanitized.replaceAll("\\s+", " ");
        sanitized = sanitized.replaceAll("(?m)^\\s+|\\s+$", "");
        return sanitized;
    }

    private static boolean containsInvisibleCharacters(String text) {
        for (char c : text.toCharArray()) {
            if (c != '\u200b' && c != '\u200c' && c != '\u200d' && c != '\ufeff' && c != '\u00ad' && c != '\u180e' && c != '\u2060' && c != '\u2061' && c != '\u2062' && c != '\u2063' && c != '\u2064') continue;
            return true;
        }
        return false;
    }

    private static String normalizeHomoglyphs(String text) {
        StringBuilder normalized = new StringBuilder();
        block42: for (char c : text.toCharArray()) {
            switch (c) {
                case '\u0410': {
                    normalized.append('a');
                    continue block42;
                }
                case '\u0415': {
                    normalized.append('e');
                    continue block42;
                }
                case '\u0406': {
                    normalized.append('i');
                    continue block42;
                }
                case '\u041e': {
                    normalized.append('o');
                    continue block42;
                }
                case '\u0420': {
                    normalized.append('p');
                    continue block42;
                }
                case '\u0421': {
                    normalized.append('c');
                    continue block42;
                }
                case '\u0425': {
                    normalized.append('x');
                    continue block42;
                }
                case '\u0430': {
                    normalized.append('a');
                    continue block42;
                }
                case '\u0435': {
                    normalized.append('e');
                    continue block42;
                }
                case '\u0456': {
                    normalized.append('i');
                    continue block42;
                }
                case '\u043e': {
                    normalized.append('o');
                    continue block42;
                }
                case '\u0440': {
                    normalized.append('p');
                    continue block42;
                }
                case '\u0441': {
                    normalized.append('c');
                    continue block42;
                }
                case '\u0445': {
                    normalized.append('x');
                    continue block42;
                }
                case '\u0443': {
                    normalized.append('y');
                    continue block42;
                }
                case '\u0391': {
                    normalized.append('a');
                    continue block42;
                }
                case '\u0392': {
                    normalized.append('b');
                    continue block42;
                }
                case '\u0395': {
                    normalized.append('e');
                    continue block42;
                }
                case '\u0396': {
                    normalized.append('z');
                    continue block42;
                }
                case '\u0397': {
                    normalized.append('h');
                    continue block42;
                }
                case '\u0399': {
                    normalized.append('i');
                    continue block42;
                }
                case '\u039a': {
                    normalized.append('k');
                    continue block42;
                }
                case '\u039c': {
                    normalized.append('m');
                    continue block42;
                }
                case '\u039d': {
                    normalized.append('n');
                    continue block42;
                }
                case '\u039f': {
                    normalized.append('o');
                    continue block42;
                }
                case '\u03a1': {
                    normalized.append('p');
                    continue block42;
                }
                case '\u03a4': {
                    normalized.append('t');
                    continue block42;
                }
                case '\u03a5': {
                    normalized.append('y');
                    continue block42;
                }
                case '\u03a7': {
                    normalized.append('x');
                    continue block42;
                }
                case '\u03b1': {
                    normalized.append('a');
                    continue block42;
                }
                case '\u03b5': {
                    normalized.append('e');
                    continue block42;
                }
                case '\u03b9': {
                    normalized.append('i');
                    continue block42;
                }
                case '\u03bf': {
                    normalized.append('o');
                    continue block42;
                }
                case '\u03c1': {
                    normalized.append('p');
                    continue block42;
                }
                case '\u03c5': {
                    normalized.append('y');
                    continue block42;
                }
                case '\u03c7': {
                    normalized.append('x');
                    continue block42;
                }
                case '\u0131': {
                    normalized.append('i');
                    continue block42;
                }
                case '\u0140': {
                    normalized.append('l');
                    continue block42;
                }
                case '\u013f': {
                    normalized.append('l');
                    continue block42;
                }
                case '\u03f2': {
                    normalized.append('c');
                    continue block42;
                }
                default: {
                    normalized.append(c);
                }
            }
        }
        return normalized.toString();
    }

    private static boolean containsSuspiciousUnicode(String text) {
        double nonLatinRatio;
        int totalLetters = 0;
        int nonLatinLetters = 0;
        boolean hasLatin = false;
        boolean hasCyrillic = false;
        boolean hasGreek = false;
        for (char c : text.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            ++totalLetters;
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            if (block == Character.UnicodeBlock.BASIC_LATIN) {
                hasLatin = true;
                continue;
            }
            if (block == Character.UnicodeBlock.CYRILLIC) {
                hasCyrillic = true;
                ++nonLatinLetters;
                continue;
            }
            if (block == Character.UnicodeBlock.GREEK) {
                hasGreek = true;
                ++nonLatinLetters;
                continue;
            }
            ++nonLatinLetters;
        }
        if (hasLatin && (hasCyrillic || hasGreek)) {
            return true;
        }
        return totalLetters > 0 && hasLatin && nonLatinLetters > 0 && (nonLatinRatio = (double)nonLatinLetters / (double)totalLetters) > 0.3;
    }

    public static boolean quickCheck(String content) {
        if (content == null || content.trim().isEmpty()) {
            return false;
        }
        if (content.length() > 500 || content.trim().length() < 2) {
            return false;
        }
        String normalized = ContentModerator.normalizeText(content);
        for (String pattern : HATE_PATTERNS) {
            if (!normalized.contains(pattern.replaceAll("[^a-z0-9]", ""))) continue;
            return false;
        }
        for (Pattern slurPattern : SLUR_PATTERNS.keySet()) {
            if (!slurPattern.matcher(normalized).find()) continue;
            return false;
        }
        return !URL_PATTERN.matcher(content).find();
    }

    static {
        SLUR_PATTERNS.put(Pattern.compile("n+[i1!l|]++[g9]++[e3a@]+r*[sz]*"), "racial slur");
        SLUR_PATTERNS.put(Pattern.compile("n+[i1!l|]++[g9]++[ae@]+"), "racial slur");
        SLUR_PATTERNS.put(Pattern.compile("ch++[i1!]++n+[kc]++"), "racial slur");
        SLUR_PATTERNS.put(Pattern.compile("sp++[i1!]++[ck]++"), "racial slur");
        SLUR_PATTERNS.put(Pattern.compile("wetb++[ae@]++[ck]++"), "racial slur");
        SLUR_PATTERNS.put(Pattern.compile("be++[ae@]++n+[e3]++r+"), "racial slur");
        SLUR_PATTERNS.put(Pattern.compile("[ck]++[i1!y]++[ck]++[e3]++"), "racial slur");
        SLUR_PATTERNS.put(Pattern.compile("r+[ae@]++g++h++[e3]++[ae@]++d++"), "racial slur");
        SLUR_PATTERNS.put(Pattern.compile("f++[ae@]++[g9]++[goeat]*[sz]*"), "homophobic slur");
        SLUR_PATTERNS.put(Pattern.compile("d++[y]++[ck]++[e3]++"), "homophobic slur");
        SLUR_PATTERNS.put(Pattern.compile("tr++[ae@]++nn++[y]++"), "transphobic slur");
        SLUR_PATTERNS.put(Pattern.compile("r++[e3]++t++[ae@]++r++d++[sz]*"), "ableist slur");
        SLUR_PATTERNS.put(Pattern.compile("m++[o0]++ng++[o0]++l++[o0]++[i1!]++d++"), "ableist slur");
        SLUR_PATTERNS.put(Pattern.compile("cr++[i1!]++ppl++[e3]++"), "ableist slur");
        SLUR_PATTERNS.put(Pattern.compile("[ck]++[i1!y]++[ck]++[e3]++"), "religious slur");
        SLUR_PATTERNS.put(Pattern.compile("s++[ae@]++nd++n++[i1!]++g++g++[e3]++r+"), "religious slur");
        EXCESSIVE_CAPS = Pattern.compile("[A-Z]{10,}");
        EXCESSIVE_PUNCTUATION = Pattern.compile("[!?]{5,}");
        URL_PATTERN = Pattern.compile("(?i)\\b(https?://|www\\.|discord\\.gg|bit\\.ly|tinyurl\\.com|t\\.co|goo\\.gl)");
        REPEATED_CHARS = Pattern.compile("(.)\\1{5,}");
        OBFUSCATION_PATTERN = Pattern.compile("[^a-z0-9\\s]{2,}");
    }

    public static class ModerationResult {
        private final boolean approved;
        private final String reason;
        private final List<String> flaggedWords;
        private final String sanitizedContent;
        private final int severityScore;

        public ModerationResult(boolean approved, String reason, List<String> flaggedWords, String sanitizedContent, int severityScore) {
            this.approved = approved;
            this.reason = reason;
            this.flaggedWords = flaggedWords;
            this.sanitizedContent = sanitizedContent;
            this.severityScore = severityScore;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public String getReason() {
            return this.reason;
        }

        public List<String> getFlaggedWords() {
            return this.flaggedWords;
        }

        public String getSanitizedContent() {
            return this.sanitizedContent;
        }

        public int getSeverityScore() {
            return this.severityScore;
        }
    }
}

