/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.texboobcat.tunnelyrefab.worlds.CompressionProgressCallback;
import org.texboobcat.tunnelyrefab.worlds.WorldScannerUtil;

public class WorldChunkPruner {
    private static final int REGION_SIZE = 32;
    private static final int CHUNK_HEADER_SIZE = 8192;

    public static PruneResult pruneWorld(Path worldPath, CompressionProgressCallback callback) {
        long startTime = System.currentTimeMillis();
        AtomicInteger regionsProcessed = new AtomicInteger(0);
        AtomicInteger chunksRemoved = new AtomicInteger(0);
        AtomicInteger chunksKept = new AtomicInteger(0);
        AtomicLong bytesRemoved = new AtomicLong(0L);
        try {
            ArrayList<Path> regionDirs = new ArrayList<Path>();
            Path regionDir = worldPath.resolve("region");
            Path dimNetherRegion = worldPath.resolve("DIM-1").resolve("region");
            Path dimEndRegion = worldPath.resolve("DIM1").resolve("region");
            if (Files.exists(regionDir, new LinkOption[0])) {
                regionDirs.add(regionDir);
            }
            if (Files.exists(dimNetherRegion, new LinkOption[0])) {
                regionDirs.add(dimNetherRegion);
            }
            if (Files.exists(dimEndRegion, new LinkOption[0])) {
                regionDirs.add(dimEndRegion);
            }
            if (regionDirs.isEmpty()) {
                return new PruneResult(false, "No region directories found", 0, 0, 0L);
            }
            int regionCount = 0;
            for (Path path : regionDirs) {
                regionCount += (int)Files.list(path).filter(p -> p.getFileName().toString().endsWith(".mca")).count();
            }
            int totalRegions = regionCount;
            System.out.println("[WorldChunkPruner] Found " + totalRegions + " region files to process");
            for (Path dir : regionDirs) {
                Files.list(dir).filter(p -> p.getFileName().toString().endsWith(".mca")).forEach(regionFile -> {
                    try {
                        long sizeBefore = Files.size(regionFile);
                        PruneRegionResult result = WorldChunkPruner.pruneRegionFile(regionFile);
                        chunksRemoved.addAndGet(result.chunksRemoved);
                        chunksKept.addAndGet(result.chunksKept);
                        if (result.success) {
                            long sizeAfter = Files.size(regionFile);
                            bytesRemoved.addAndGet(sizeBefore - sizeAfter);
                        }
                        int processed = regionsProcessed.incrementAndGet();
                        if (callback != null && totalRegions > 0) {
                            int percentage = processed * 100 / totalRegions;
                            callback.onProgress(percentage, regionFile.getFileName().toString());
                        }
                    }
                    catch (IOException e) {
                        System.err.println("[WorldChunkPruner] Failed to prune region: " + String.valueOf(regionFile.getFileName()));
                    }
                });
            }
            long l = System.currentTimeMillis() - startTime;
            int totalChunks = chunksRemoved.get() + chunksKept.get();
            double removalPercentage = totalChunks > 0 ? (double)chunksRemoved.get() * 100.0 / (double)totalChunks : 0.0;
            String message = String.format("Pruned %d uninhabited chunks (%.1f%%), kept %d chunks, saved %s in %.1f seconds", chunksRemoved.get(), removalPercentage, chunksKept.get(), WorldScannerUtil.formatSize(bytesRemoved.get()), (double)l / 1000.0);
            System.out.println("[WorldChunkPruner] " + message);
            if (callback != null) {
                callback.onComplete(true, message);
            }
            return new PruneResult(true, message, chunksRemoved.get(), chunksKept.get(), bytesRemoved.get());
        }
        catch (Exception e) {
            String errorMsg = "Pruning failed: " + e.getMessage();
            System.err.println("[WorldChunkPruner] " + errorMsg);
            e.printStackTrace();
            if (callback != null) {
                callback.onComplete(false, errorMsg);
            }
            return new PruneResult(false, errorMsg, 0, 0, 0L);
        }
    }

    private static PruneRegionResult pruneRegionFile(Path regionFile) throws IOException {
        int chunksRemoved = 0;
        int chunksKept = 0;
        byte[] regionData = Files.readAllBytes(regionFile);
        if (regionData.length < 8192) {
            return new PruneRegionResult(false, chunksRemoved, chunksKept);
        }
        int[] chunkOffsets = new int[1024];
        int[] chunkSizes = new int[1024];
        boolean[] chunkInhabited = new boolean[1024];
        for (int i = 0; i < 1024; ++i) {
            int locationOffset = i * 4;
            int offsetValue = (regionData[locationOffset] & 0xFF) << 16 | (regionData[locationOffset + 1] & 0xFF) << 8 | regionData[locationOffset + 2] & 0xFF;
            int sectorCount = regionData[locationOffset + 3] & 0xFF;
            chunkOffsets[i] = offsetValue * 4096;
            chunkSizes[i] = sectorCount * 4096;
            if (offsetValue <= 0 || sectorCount <= 0) continue;
            chunkInhabited[i] = WorldChunkPruner.isChunkInhabited(regionData, chunkOffsets[i], chunkSizes[i]);
            if (chunkInhabited[i]) {
                ++chunksKept;
                continue;
            }
            ++chunksRemoved;
        }
        if (chunksRemoved == 0) {
            return new PruneRegionResult(true, chunksRemoved, chunksKept);
        }
        ByteArrayOutputStream newRegionData = new ByteArrayOutputStream();
        byte[] newHeader = new byte[8192];
        newRegionData.write(newHeader);
        int[] newOffsets = new int[1024];
        int[] newSizes = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            if (chunkOffsets[i] <= 0 || !chunkInhabited[i]) continue;
            int currentPos = newRegionData.size();
            int padding = (4096 - currentPos % 4096) % 4096;
            newRegionData.write(new byte[padding]);
            int newOffset = newRegionData.size();
            newOffsets[i] = newOffset / 4096;
            int chunkDataLength = Math.min(chunkSizes[i], regionData.length - chunkOffsets[i]);
            newRegionData.write(regionData, chunkOffsets[i], chunkDataLength);
            newSizes[i] = (chunkDataLength + 4095) / 4096;
        }
        byte[] finalData = newRegionData.toByteArray();
        for (int i = 0; i < 1024; ++i) {
            int locationOffset = i * 4;
            finalData[locationOffset] = (byte)(newOffsets[i] >> 16 & 0xFF);
            finalData[locationOffset + 1] = (byte)(newOffsets[i] >> 8 & 0xFF);
            finalData[locationOffset + 2] = (byte)(newOffsets[i] & 0xFF);
            finalData[locationOffset + 3] = (byte)newSizes[i];
        }
        System.arraycopy(regionData, 4096, finalData, 4096, 4096);
        Files.write(regionFile, finalData, new OpenOption[0]);
        return new PruneRegionResult(true, chunksRemoved, chunksKept);
    }

    private static boolean isChunkInhabited(byte[] regionData, int offset, int size) {
        if (offset + 5 > regionData.length) {
            return false;
        }
        try {
            byte[] decompressedData;
            int chunkLength = (regionData[offset] & 0xFF) << 24 | (regionData[offset + 1] & 0xFF) << 16 | (regionData[offset + 2] & 0xFF) << 8 | regionData[offset + 3] & 0xFF;
            if (chunkLength <= 0 || chunkLength > size - 5) {
                return false;
            }
            int compressionType = regionData[offset + 4] & 0xFF;
            byte[] compressedData = Arrays.copyOfRange(regionData, offset + 5, offset + 5 + chunkLength);
            if (compressionType == 2) {
                decompressedData = WorldChunkPruner.decompress(compressedData);
            } else if (compressionType == 1) {
                decompressedData = WorldChunkPruner.decompressGZip(compressedData);
            } else {
                return true;
            }
            byte[] searchBytes = "InhabitedTime".getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < decompressedData.length - searchBytes.length - 10; ++i) {
                int valueOffset;
                boolean found = true;
                for (int j = 0; j < searchBytes.length; ++j) {
                    if (decompressedData[i + j] == searchBytes[j]) continue;
                    found = false;
                    break;
                }
                if (!found || (valueOffset = i + searchBytes.length) + 8 > decompressedData.length) continue;
                long inhabitedTime = 0L;
                for (int b = 0; b < 8; ++b) {
                    inhabitedTime = inhabitedTime << 8 | (long)(decompressedData[valueOffset + b] & 0xFF);
                }
                return inhabitedTime > 0L;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] decompressGZip(byte[] compressedData) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] decompress(byte[] compressedData) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedData);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
        }
        catch (DataFormatException e) {
            throw new IOException("Failed to decompress chunk data", e);
        }
        finally {
            inflater.end();
        }
        return outputStream.toByteArray();
    }

    public static class PruneResult {
        private final boolean success;
        private final String message;
        private final int chunksRemoved;
        private final int chunksKept;
        private final long bytesRemoved;

        public PruneResult(boolean success, String message, int chunksRemoved, int chunksKept, long bytesRemoved) {
            this.success = success;
            this.message = message;
            this.chunksRemoved = chunksRemoved;
            this.chunksKept = chunksKept;
            this.bytesRemoved = bytesRemoved;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public int getChunksRemoved() {
            return this.chunksRemoved;
        }

        public int getChunksKept() {
            return this.chunksKept;
        }

        public long getBytesRemoved() {
            return this.bytesRemoved;
        }
    }

    private static class PruneRegionResult {
        private final boolean success;
        private final int chunksRemoved;
        private final int chunksKept;

        public PruneRegionResult(boolean success, int chunksRemoved, int chunksKept) {
            this.success = success;
            this.chunksRemoved = chunksRemoved;
            this.chunksKept = chunksKept;
        }
    }
}

