/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import com.google.gson.annotations.SerializedName;
import java.time.Instant;

public class WorldComment {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="world_id")
    private String worldId;
    @SerializedName(value="user_id")
    private String userId;
    @SerializedName(value="username")
    private String username;
    @SerializedName(value="comment")
    private String comment;
    @SerializedName(value="is_moderated")
    private boolean isModerated;
    @SerializedName(value="moderation_status")
    private String moderationStatus;
    @SerializedName(value="moderation_reason")
    private String moderationReason;
    @SerializedName(value="flagged_words")
    private String[] flaggedWords;
    @SerializedName(value="created_at")
    private String createdAt;
    @SerializedName(value="updated_at")
    private String updatedAt;
    @SerializedName(value="edited")
    private boolean edited;

    public WorldComment() {
    }

    public WorldComment(String worldId, String userId, String username, String comment) {
        this.worldId = worldId;
        this.userId = userId;
        this.username = username;
        this.comment = comment;
        this.moderationStatus = "pending";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWorldId() {
        return this.worldId;
    }

    public void setWorldId(String worldId) {
        this.worldId = worldId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isModerated() {
        return this.isModerated;
    }

    public void setModerated(boolean moderated) {
        this.isModerated = moderated;
    }

    public String getModerationStatus() {
        return this.moderationStatus;
    }

    public void setModerationStatus(String moderationStatus) {
        this.moderationStatus = moderationStatus;
    }

    public String getModerationReason() {
        return this.moderationReason;
    }

    public void setModerationReason(String moderationReason) {
        this.moderationReason = moderationReason;
    }

    public String[] getFlaggedWords() {
        return this.flaggedWords;
    }

    public void setFlaggedWords(String[] flaggedWords) {
        this.flaggedWords = flaggedWords;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }

    public boolean isApproved() {
        return "approved".equals(this.moderationStatus);
    }

    public boolean isPending() {
        return "pending".equals(this.moderationStatus);
    }

    public boolean isRejected() {
        return "rejected".equals(this.moderationStatus);
    }

    public String getFormattedTime() {
        if (this.createdAt == null) {
            return "Unknown";
        }
        try {
            Instant instant = Instant.parse(this.createdAt);
            long secondsAgo = (System.currentTimeMillis() - instant.toEpochMilli()) / 1000L;
            if (secondsAgo < 60L) {
                return "Just now";
            }
            if (secondsAgo < 3600L) {
                return secondsAgo / 60L + "m ago";
            }
            if (secondsAgo < 86400L) {
                return secondsAgo / 3600L + "h ago";
            }
            if (secondsAgo < 604800L) {
                return secondsAgo / 86400L + "d ago";
            }
            if (secondsAgo < 2592000L) {
                return secondsAgo / 604800L + "w ago";
            }
            if (secondsAgo < 31536000L) {
                return secondsAgo / 2592000L + "mo ago";
            }
            return secondsAgo / 31536000L + "y ago";
        }
        catch (Exception e) {
            return "Unknown";
        }
    }
}

