/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds.ui;

import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.worlds.ScanResultDetails;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.ui.ScanStatusColors;

public class ScanReportData {
    private final WorldInfo world;
    private final ScanResultDetails details;

    public ScanReportData(WorldInfo world) {
        this.world = world;
        this.details = world != null ? world.getScanResultDetails() : null;
    }

    public String getTitle() {
        return "Security Scan Report";
    }

    public String getWorldName() {
        return this.world != null ? this.world.getName() : "Unknown World";
    }

    public String getAuthor() {
        return this.world != null ? this.world.getAuthorUsername() : "Unknown";
    }

    public String getThreatLevel() {
        return this.details != null ? this.details.getFormattedThreatLevel() : "UNKNOWN";
    }

    public int getThreatColor() {
        if (this.details == null) {
            return -6710887;
        }
        return ScanStatusColors.getThreatColor(this.details.getThreatLevel());
    }

    public String getStatus() {
        if (this.details == null) {
            return "UNKNOWN";
        }
        return this.details.isSafe() ? "SAFE" : "QUARANTINED";
    }

    public int getStatusColor() {
        if (this.details == null) {
            return -6710887;
        }
        return this.details.isSafe() ? -13369549 : -52429;
    }

    public ScanReportSection getBlockedThreats() {
        if (this.details == null || !this.details.hasBlockedFiles()) {
            return null;
        }
        ScanReportSection section = new ScanReportSection();
        section.title = "\ud83d\udeab Detected Threats";
        section.titleColor = -52429;
        section.items = new ArrayList<ScanReportItem>();
        for (String threat : this.details.getBlockedFiles()) {
            ScanReportItem item = new ScanReportItem();
            item.text = threat;
            item.color = -26317;
            section.items.add(item);
        }
        return section;
    }

    public ScanReportSection getWarnings() {
        if (this.details == null || !this.details.hasWarnings()) {
            return null;
        }
        ScanReportSection section = new ScanReportSection();
        section.title = "\u26a0\ufe0f Warnings";
        section.titleColor = -13261;
        section.items = new ArrayList<ScanReportItem>();
        for (String warning : this.details.getWarnings()) {
            ScanReportItem item = new ScanReportItem();
            item.text = warning;
            item.color = -13261;
            section.items.add(item);
        }
        return section;
    }

    public ScanReportSection getDetectionDetails() {
        if (this.details == null || this.details.getDetectionDetails().isEmpty()) {
            return null;
        }
        ScanReportSection section = new ScanReportSection();
        section.title = "\ud83d\udd0d Detection Details";
        section.titleColor = -1;
        section.items = new ArrayList<ScanReportItem>();
        for (ScanResultDetails.DetectionDetail detail : this.details.getDetectionDetails()) {
            ScanReportItem item = new ScanReportItem();
            item.text = "[" + detail.getSeverity().toUpperCase() + "] " + detail.getDescription();
            item.color = ScanStatusColors.getSeverityColor(detail.getSeverity());
            section.items.add(item);
        }
        return section;
    }

    public List<ScanReportSection> getAllSections() {
        ScanReportSection detections;
        ScanReportSection warnings;
        ArrayList<ScanReportSection> sections = new ArrayList<ScanReportSection>();
        ScanReportSection blocked = this.getBlockedThreats();
        if (blocked != null) {
            sections.add(blocked);
        }
        if ((warnings = this.getWarnings()) != null) {
            sections.add(warnings);
        }
        if ((detections = this.getDetectionDetails()) != null) {
            sections.add(detections);
        }
        return sections;
    }

    public boolean isQuarantined() {
        return this.world != null && this.world.isQuarantined();
    }

    public boolean hasDetails() {
        return this.details != null;
    }

    public String getWorldId() {
        return this.world != null ? this.world.getId() : null;
    }

    public static class ScanReportSection {
        public String title;
        public int titleColor;
        public List<ScanReportItem> items;
    }

    public static class ScanReportItem {
        public String text;
        public int color;
    }
}

