/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.ScanReportData;

public class ScanReportScreen
extends class_437 {
    private final class_437 parent;
    private final WorldInfo world;
    private final WorldManager worldManager;
    private final ScanReportData reportData;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;

    public ScanReportScreen(class_437 parent, WorldInfo world) {
        super((class_2561)class_2561.method_43470((String)"Security Scan Report"));
        this.parent = parent;
        this.world = world;
        this.worldManager = new WorldManager();
        this.reportData = new ScanReportData(world);
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int buttonY = this.field_22790 - 30;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX - 105, buttonY, 100, 20).method_46431());
        if (this.reportData.isQuarantined()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete World"), button -> this.confirmDelete()).method_46434(centerX + 5, buttonY, 100, 20).method_46431());
        }
        this.updateMaxScroll();
    }

    private void confirmDelete() {
        this.field_22787.method_1507((class_437)new WarningPopupScreen(this, this, "Delete Quarantined World?", "Are you sure you want to delete \"" + this.world.getName() + "\"?\nThis world failed security scanning and cannot be recovered.", 0xFF0000, () -> this.deleteWorld()));
    }

    private void deleteWorld() {
        new Thread(() -> {
            try {
                this.worldManager.deleteWorld(this.world.getId());
                this.field_22787.execute(() -> this.field_22787.method_1507(this.parent));
            }
            catch (Exception e) {
                this.field_22787.execute(() -> this.field_22787.method_1507((class_437)this));
            }
        }).start();
    }

    private void updateMaxScroll() {
        int contentHeight = this.calculateContentHeight();
        int visibleHeight = this.field_22790 - 120;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    private int calculateContentHeight() {
        int height = 80;
        for (ScanReportData.ScanReportSection section : this.reportData.getAllSections()) {
            height += 30;
            height += section.items.size() * 15;
            height += 10;
        }
        return height;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        graphics.method_25300(this.field_22793, "\ud83d\udd12 Security Scan Report", this.field_22789 / 2, 15, 0xFFFFFF);
        this.renderContent(graphics, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.maxScrollOffset > 0) {
            graphics.method_25303(this.field_22793, "\u2195 Scroll for more", this.field_22789 / 2 - 40, this.field_22790 - 50, 0x888888);
        }
    }

    private void renderContent(class_332 graphics, int mouseX, int mouseY) {
        int startY = 40;
        int endY = this.field_22790 - 60;
        int centerX = this.field_22789 / 2;
        int contentWidth = Math.min(500, this.field_22789 - 40);
        int contentX = centerX - contentWidth / 2;
        graphics.method_44379(0, startY, this.field_22789, endY);
        int y = startY - this.scrollOffset;
        graphics.method_25303(this.field_22793, "\u00a7lWorld: \u00a7r" + this.reportData.getWorldName(), contentX, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Author: " + this.reportData.getAuthor(), contentX, y += 15, 0xAAAAAA);
        String threatText = "Threat Level: " + this.reportData.getThreatLevel();
        graphics.method_25303(this.field_22793, threatText, contentX, y += 20, this.reportData.getThreatColor());
        String statusText = "Status: " + this.reportData.getStatus();
        graphics.method_25303(this.field_22793, statusText, contentX, y += 15, this.reportData.getStatusColor());
        graphics.method_25294(contentX, y += 25, contentX + contentWidth, y + 1, -12566464);
        y += 15;
        if (!this.reportData.hasDetails()) {
            graphics.method_25303(this.field_22793, "\u00a77No scan details available", contentX, y, 0x888888);
        } else {
            for (ScanReportData.ScanReportSection section : this.reportData.getAllSections()) {
                graphics.method_25303(this.field_22793, section.title, contentX, y, section.titleColor);
                y += 18;
                for (ScanReportData.ScanReportItem item : section.items) {
                    List<String> lines = this.wrapText(item.text, contentWidth - 20);
                    for (String line : lines) {
                        graphics.method_25303(this.field_22793, "  \u2022 " + line, contentX + 5, y, item.color);
                        y += 12;
                    }
                }
                y += 10;
            }
        }
        graphics.method_44380();
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.field_22793.method_1727(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }
}

