/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;

public class DownloadState {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private String worldId;
    private String worldName;
    private String fileUrl;
    private long totalBytes;
    private long downloadedBytes;
    private String tempFilePath;
    private String stateFilePath;
    private String startedAt;
    private String lastUpdateAt;
    private boolean paused;
    private boolean completed;
    private String targetFileName;

    public DownloadState() {
    }

    public DownloadState(String worldId, String worldName, String fileUrl, String tempFilePath, String stateFilePath, String targetFileName) {
        this.worldId = worldId;
        this.worldName = worldName;
        this.fileUrl = fileUrl;
        this.tempFilePath = tempFilePath;
        this.stateFilePath = stateFilePath;
        this.targetFileName = targetFileName;
        this.totalBytes = 0L;
        this.downloadedBytes = 0L;
        this.startedAt = Instant.now().toString();
        this.lastUpdateAt = Instant.now().toString();
        this.paused = false;
        this.completed = false;
    }

    public void save() throws IOException {
        this.lastUpdateAt = Instant.now().toString();
        String json = GSON.toJson(this);
        Files.writeString(Paths.get(this.stateFilePath, new String[0]), (CharSequence)json, new OpenOption[0]);
    }

    public static DownloadState load(Path stateFile) throws IOException {
        String json = Files.readString(stateFile);
        return GSON.fromJson(json, DownloadState.class);
    }

    public void cleanup() {
        try {
            Files.deleteIfExists(Paths.get(this.stateFilePath, new String[0]));
        }
        catch (IOException e) {
            System.err.println("Failed to cleanup state file: " + e.getMessage());
        }
    }

    public int getProgressPercentage() {
        if (this.totalBytes == 0L) {
            return 0;
        }
        return (int)(this.downloadedBytes * 100L / this.totalBytes);
    }

    public long getDownloadSpeed() {
        if (this.startedAt == null || this.startedAt.isEmpty()) {
            return 0L;
        }
        try {
            Instant started = Instant.parse(this.startedAt);
            long elapsedSeconds = Instant.now().getEpochSecond() - started.getEpochSecond();
            if (elapsedSeconds == 0L) {
                return 0L;
            }
            return this.downloadedBytes / elapsedSeconds;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public String getDownloadedBytesFormatted() {
        return DownloadState.formatBytes(this.downloadedBytes);
    }

    public String getTotalBytesFormatted() {
        return DownloadState.formatBytes(this.totalBytes);
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), pre);
    }

    public String getWorldId() {
        return this.worldId;
    }

    public void setWorldId(String worldId) {
        this.worldId = worldId;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public long getDownloadedBytes() {
        return this.downloadedBytes;
    }

    public void setDownloadedBytes(long downloadedBytes) {
        this.downloadedBytes = downloadedBytes;
    }

    public String getTempFilePath() {
        return this.tempFilePath;
    }

    public void setTempFilePath(String tempFilePath) {
        this.tempFilePath = tempFilePath;
    }

    public String getStateFilePath() {
        return this.stateFilePath;
    }

    public void setStateFilePath(String stateFilePath) {
        this.stateFilePath = stateFilePath;
    }

    public Instant getStartedAt() {
        try {
            return this.startedAt != null ? Instant.parse(this.startedAt) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setStartedAt(Instant startedAt) {
        this.startedAt = startedAt != null ? startedAt.toString() : null;
    }

    public Instant getLastUpdateAt() {
        try {
            return this.lastUpdateAt != null ? Instant.parse(this.lastUpdateAt) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setLastUpdateAt(Instant lastUpdateAt) {
        this.lastUpdateAt = lastUpdateAt != null ? lastUpdateAt.toString() : null;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }
}

