/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds.ui;

import java.time.Instant;
import java.util.ArrayList;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;

public class WorldBadge {
    public static BadgeInfo getSecurityBadge(WorldInfo world) {
        if (world == null) {
            return null;
        }
        if ("clean".equals(world.getScanStatus())) {
            return new BadgeInfo(BadgeType.VERIFIED, "\u2713 Verified", "This world has passed security scanning", -13369549, -2147457536);
        }
        if (world.isScanning()) {
            return new BadgeInfo(BadgeType.SCANNING, "\u23f3 Scanning...", "Security scan in progress", -13261, -2140772864);
        }
        if (world.isScanPending()) {
            return new BadgeInfo(BadgeType.PENDING, "\u23f1 Pending", "Waiting for security scan", -13261, -2140772864);
        }
        return null;
    }

    public static BadgeInfo[] getFeatureBadges(WorldInfo world) {
        if (world == null) {
            return new BadgeInfo[0];
        }
        ArrayList<BadgeInfo> badges = new ArrayList<BadgeInfo>();
        if (world.isFeatured()) {
            badges.add(new BadgeInfo(BadgeType.FEATURED, "\u2b50 Featured", "Featured by moderators", -10496, -2140777216));
        }
        if (world.getDownloadCount() >= 1000) {
            badges.add(new BadgeInfo(BadgeType.POPULAR, "\ud83d\udd25 Popular", world.getFormattedDownloadCount() + " downloads", -39424, -2140785920));
        }
        if (WorldBadge.isNew(world)) {
            badges.add(new BadgeInfo(BadgeType.NEW, "\ud83c\udd95 New", "Uploaded recently", -16711681, -2147457434));
        }
        return badges.toArray(new BadgeInfo[0]);
    }

    public static BadgeInfo[] getAllBadges(WorldInfo world) {
        BadgeInfo[] featureBadges;
        if (world == null) {
            return new BadgeInfo[0];
        }
        ArrayList<BadgeInfo> allBadges = new ArrayList<BadgeInfo>();
        BadgeInfo securityBadge = WorldBadge.getSecurityBadge(world);
        if (securityBadge != null) {
            allBadges.add(securityBadge);
        }
        for (BadgeInfo badge : featureBadges = WorldBadge.getFeatureBadges(world)) {
            allBadges.add(badge);
        }
        return allBadges.toArray(new BadgeInfo[0]);
    }

    private static boolean isNew(WorldInfo world) {
        if (world.getCreatedAt() == null) {
            return false;
        }
        try {
            Instant created = Instant.parse(world.getCreatedAt());
            long ageMs = System.currentTimeMillis() - created.toEpochMilli();
            long ageDays = ageMs / 86400000L;
            return ageDays <= 7L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class BadgeInfo {
        public final BadgeType type;
        public final String text;
        public final String tooltip;
        public final int textColor;
        public final int backgroundColor;

        public BadgeInfo(BadgeType type, String text, String tooltip, int textColor, int backgroundColor) {
            this.type = type;
            this.text = text;
            this.tooltip = tooltip;
            this.textColor = textColor;
            this.backgroundColor = backgroundColor;
        }
    }

    public static enum BadgeType {
        VERIFIED,
        SCANNING,
        PENDING,
        FEATURED,
        POPULAR,
        NEW;

    }
}

