/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;

public class InvitesScreen
extends Screen {
    private final Screen parent;
    private InviteListWidget inviteList;
    private String statusMessage = "\u00a7eLoading invites...";
    private int statusColor = 0xFFFF00;

    public InvitesScreen(Screen parent) {
        super((Component)Component.literal((String)"Invites"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.inviteList = new InviteListWidget(this.minecraft, this.width, this.height, 50, this.height - 60, 45);
        this.addWidget((GuiEventListener)this.inviteList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udd04 Refresh"), button -> this.loadInvites()).bounds(this.width / 2 - 155, this.height - 50, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 + 55, this.height - 50, 100, 20).build());
        this.loadInvites();
    }

    private void loadInvites() {
        System.out.println("[Tunnely UI] ===== LOADING INVITES =====");
        this.statusMessage = "\u00a7eLoading invites...";
        this.statusColor = 0xFFFF00;
        this.inviteList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.InviteListResult result = client.getPendingInvites();
                this.minecraft.execute(() -> {
                    block6: {
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing invite data...");
                                JsonArray invites = JsonParser.parseString((String)result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + invites.size() + " invite(s)");
                                if (invites.size() == 0) {
                                    this.statusMessage = "\u00a77No pending invites";
                                    this.statusColor = 0xAAAAAA;
                                    break block6;
                                }
                                for (JsonElement element : invites) {
                                    JsonObject invite = element.getAsJsonObject();
                                    String inviteId = invite.get("id").getAsString();
                                    String inviterName = invite.has("inviter_name") ? invite.get("inviter_name").getAsString() : "Unknown";
                                    String serverName = invite.has("server_name") ? invite.get("server_name").getAsString() : "Server";
                                    System.out.println("[Tunnely UI] Invite: " + inviterName + " -> " + serverName);
                                    this.inviteList.addInvite(inviteId, inviterName, serverName);
                                }
                                this.statusMessage = "\u00a7a" + invites.size() + " pending invite(s)";
                                this.statusColor = 65280;
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse invites";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing invites: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load invites: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading invites: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadInvites").start();
    }

    private void acceptInvite(String inviteId) {
        System.out.println("[Tunnely UI] ===== ACCEPTING INVITE =====");
        System.out.println("[Tunnely UI] Invite ID: " + inviteId);
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.acceptInvite(inviteId);
                this.minecraft.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aInvite accepted!";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Invite accepted successfully");
                        this.loadInvites();
                    } else {
                        this.statusMessage = "\u00a7cFailed to accept invite";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to accept invite");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception accepting invite: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-AcceptInvite").start();
    }

    private void declineInvite(String inviteId) {
        System.out.println("[Tunnely UI] ===== DECLINING INVITE =====");
        System.out.println("[Tunnely UI] Invite ID: " + inviteId);
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.declineInvite(inviteId);
                this.minecraft.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aInvite declined";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Invite declined successfully");
                        this.loadInvites();
                    } else {
                        this.statusMessage = "\u00a7cFailed to decline invite";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to decline invite");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception declining invite: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-DeclineInvite").start();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.inviteList.render(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, "\u00a76\u00a7lInvites", this.width / 2, 20, 0xFFFFFF);
        graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, 35, this.statusColor);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private class InviteListWidget
    extends ObjectSelectionList<InviteEntry> {
        public InviteListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom);
        }

        public void clear() {
            this.clearEntries();
        }

        public void addInvite(String id, String inviterName, String serverName) {
            this.addEntry((AbstractSelectionList.Entry)new InviteEntry(id, inviterName, serverName));
        }

        class InviteEntry
        extends ObjectSelectionList.Entry<InviteEntry> {
            private final String id;
            private final String inviterName;
            private final String serverName;
            private final Button acceptButton;
            private final Button declineButton;

            public InviteEntry(String id, String inviterName, String serverName) {
                this.id = id;
                this.inviterName = inviterName;
                this.serverName = serverName;
                this.acceptButton = Button.builder((Component)Component.literal((String)"\u2713"), button -> InvitesScreen.this.acceptInvite(id)).bounds(0, 0, 30, 20).build();
                this.declineButton = Button.builder((Component)Component.literal((String)"\u2717"), button -> InvitesScreen.this.declineInvite(id)).bounds(0, 0, 30, 20).build();
            }

            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                graphics.drawString(InvitesScreen.this.font, "\u00a7bFrom: \u00a7f" + this.inviterName, left + 5, top + 5, 0xFFFFFF);
                graphics.drawString(InvitesScreen.this.font, "\u00a77Server: \u00a7e" + this.serverName, left + 5, top + 18, 0xFFFFFF);
                this.acceptButton.setX(left + width - 70);
                this.acceptButton.setY(top + 10);
                this.acceptButton.render(graphics, mouseX, mouseY, partialTick);
                this.declineButton.setX(left + width - 35);
                this.declineButton.setY(top + 10);
                this.declineButton.render(graphics, mouseX, mouseY, partialTick);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.acceptButton.mouseClicked(mouseX, mouseY, button) || this.declineButton.mouseClicked(mouseX, mouseY, button);
            }

            public Component getNarration() {
                return Component.literal((String)("Invite from " + this.inviterName + " to " + this.serverName));
            }
        }
    }
}

