/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.screens.DirectJoinScreen;
import org.texboobcat.tunnelyrefab.ui.screens.FriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.InvitesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.JoinFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.PublicLobbiesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.SettingsScreen;

public class TunnelyMultiplayerScreen
extends Screen {
    private final Screen parent;
    private final TunnelConfig config;
    private final List<Button> menuButtons = new ArrayList<Button>();
    private int buttonWidth;
    private final int buttonHeight = 20;
    private int safeTop;
    private final int safeBottom = 70;
    private int spacing;
    private int stackStartY;
    private int stackTotalH;
    private boolean scrollable;
    private double scroll;
    private String footerMessage = "";
    private int footerColor = 0xFFFFFF;
    private Button donateButton;
    private Button backButton;

    public TunnelyMultiplayerScreen(Screen parent) {
        super((Component)Component.literal((String)"Tunnely Multiplayer"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
    }

    protected void init() {
        SupabaseClient client;
        super.init();
        this.clearWidgets();
        if (this.config.isAuthenticated() && (client = new SupabaseClient()).needsLogin()) {
            this.minecraft.setScreen((Screen)new LoginScreen(this.parent));
            return;
        }
        this.computeHeaderSafeTop();
        this.computeButtons();
        this.addBottomBar();
    }

    private void computeHeaderSafeTop() {
        this.safeTop = 45;
    }

    private void computeButtons() {
        this.menuButtons.clear();
        this.buttonWidth = Math.min(240, Math.max(160, (int)((double)this.width * 0.3)));
        int centerX = this.width / 2 - this.buttonWidth / 2;
        boolean authed = this.config.isAuthenticated();
        if (!authed) {
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Login / Register"), b -> this.minecraft.setScreen((Screen)new LoginScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.setFooterMessage("\u00a77Please log in to access Tunnely multiplayer features", 0xAAAAAA);
        } else {
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Direct Join"), b -> this.minecraft.setScreen((Screen)new DirectJoinScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Join Friends"), b -> this.minecraft.setScreen((Screen)new JoinFriendsScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Public Lobbies"), b -> this.minecraft.setScreen((Screen)new PublicLobbiesScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Manage Friends"), b -> this.minecraft.setScreen((Screen)new FriendsScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Invites"), b -> this.minecraft.setScreen((Screen)new InvitesScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Settings"), b -> this.minecraft.setScreen((Screen)new SettingsScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
        }
        int count = this.menuButtons.size();
        int areaH = Math.max(0, this.height - this.safeTop - 70);
        int ideal = 22;
        int min = 5;
        this.spacing = ideal;
        int needed = count * 20 + (count - 1) * this.spacing;
        if (needed > areaH) {
            int neededMin = count * 20 + (count - 1) * min;
            this.spacing = neededMin > areaH ? min : (areaH - count * 20) / Math.max(1, count - 1);
        }
        this.stackTotalH = count * 20 + (count - 1) * this.spacing;
        boolean bl = this.scrollable = this.stackTotalH > areaH;
        if (!this.scrollable) {
            this.scroll = 0.0;
        }
        this.stackStartY = this.safeTop + Math.max(0, (areaH - this.stackTotalH) / 2);
        for (Button b2 : this.menuButtons) {
            this.addRenderableWidget((GuiEventListener)b2);
        }
        this.layoutButtons();
    }

    private void layoutButtons() {
        int y = this.stackStartY - (int)Math.max(0.0, this.scroll);
        int centerX = this.width / 2 - this.buttonWidth / 2;
        for (Button b : this.menuButtons) {
            b.setX(centerX);
            b.setY(y);
            y += 20 + this.spacing;
        }
    }

    private void addBottomBar() {
        int centerX = this.width / 2 - this.buttonWidth / 2;
        this.donateButton = Button.builder((Component)Component.literal((String)"Donate"), btn -> this.openDonate()).bounds(centerX, this.height - 55, this.buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.donateButton);
        this.backButton = Button.builder((Component)Component.literal((String)"Back"), btn -> this.minecraft.setScreen(this.parent)).bounds(centerX, this.height - 30, this.buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
    }

    private void openDonate() {
        try {
            Util.getPlatform().openUri("https://modrinth.com/mod/tunnely");
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Failed to open browser: " + e.getMessage());
            this.setFooterMessage("\u00a7cFailed to open browser", 0xFF5555);
        }
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float delta) {
        this.renderBackground(g, mouseX, mouseY, delta);
        g.drawCenteredString(this.font, "\u00a76\u00a7lTunnely Multiplayer", this.width / 2, 15, 0xFFAA00);
        boolean authed = this.config.isAuthenticated();
        if (authed) {
            String username = "Player";
            if (this.minecraft.player != null) {
                username = this.minecraft.player.getName().getString();
            }
            g.drawCenteredString(this.font, "\u00a77Logged in as \u00a7b" + username, this.width / 2, 28, 0xAAAAAA);
        } else {
            g.drawCenteredString(this.font, "\u00a77Join servers and play with friends", this.width / 2, 28, 0xAAAAAA);
        }
        if (!this.footerMessage.isEmpty()) {
            g.drawCenteredString(this.font, this.footerMessage, this.width / 2, this.height - 65, this.footerColor);
        }
        int areaH = Math.max(0, this.height - this.safeTop - 70);
        if (this.scrollable) {
            g.enableScissor(0, this.safeTop, this.width, this.safeTop + areaH);
        }
        for (Button b : this.menuButtons) {
            b.render(g, mouseX, mouseY, delta);
        }
        if (this.scrollable) {
            g.disableScissor();
        }
        this.donateButton.render(g, mouseX, mouseY, delta);
        this.backButton.render(g, mouseX, mouseY, delta);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.scrollable) {
            int areaH = Math.max(0, this.height - this.safeTop - 70);
            int maxScroll = Math.max(0, this.stackTotalH - areaH);
            this.scroll = Math.max(0.0, Math.min((double)maxScroll, this.scroll - scrollY * 10.0));
            this.layoutButtons();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrollable && mouseY >= (double)this.safeTop && mouseY <= (double)(this.height - 70)) {
            for (Button btn : this.menuButtons) {
                if (!btn.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void resize(Minecraft mc, int w, int h) {
        super.resize(mc, w, h);
        this.clearWidgets();
        this.init();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void setFooterMessage(String message, int color) {
        this.footerMessage = message;
        this.footerColor = color;
    }
}

