/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.networking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class RouteOptimizer {
    private static final int HOP_PENALTY_MS = 10;
    private static final double RELIABILITY_DECAY_PER_HOP = 0.02;
    private static final int MAX_HOPS = 3;

    public static Route findOptimalRoute(RelayNode clientRelay, RelayNode hostRelay, List<RelayNode> availableRelays, int maxHops) {
        if (clientRelay == null || hostRelay == null) {
            return null;
        }
        if (clientRelay.id.equals(hostRelay.id)) {
            return new Route(Collections.singletonList(clientRelay), clientRelay.latencyFromClient, 1.0);
        }
        PriorityQueue<RouteCandidate> queue = new PriorityQueue<RouteCandidate>(Comparator.comparingInt(r -> r.score));
        HashMap<String, RouteCandidate> bestRoutes = new HashMap<String, RouteCandidate>();
        RouteCandidate start = new RouteCandidate(clientRelay, new ArrayList<RelayNode>(Collections.singletonList(clientRelay)), clientRelay.latencyFromClient, 1.0);
        queue.add(start);
        bestRoutes.put(clientRelay.id, start);
        while (!queue.isEmpty()) {
            RouteCandidate current = queue.poll();
            if (current.relay.id.equals(hostRelay.id)) {
                return new Route(current.path, current.totalLatency, current.reliability);
            }
            if (current.path.size() >= maxHops) continue;
            for (Map.Entry<String, Integer> neighbor : current.relay.latencyToRelays.entrySet()) {
                String neighborId = neighbor.getKey();
                int edgeLatency = neighbor.getValue();
                RelayNode neighborRelay = RouteOptimizer.findRelayById(availableRelays, neighborId);
                if (neighborRelay == null || RouteOptimizer.isInPath(current.path, neighborId)) continue;
                ArrayList<RelayNode> newPath = new ArrayList<RelayNode>(current.path);
                newPath.add(neighborRelay);
                int newLatency = current.totalLatency + edgeLatency;
                double newReliability = current.reliability * 0.98;
                RouteCandidate candidate = new RouteCandidate(neighborRelay, newPath, newLatency, newReliability);
                RouteCandidate existing = (RouteCandidate)bestRoutes.get(neighborId);
                if (existing != null && candidate.score >= existing.score) continue;
                bestRoutes.put(neighborId, candidate);
                queue.add(candidate);
            }
        }
        Integer directLatency = clientRelay.latencyToRelays.get(hostRelay.id);
        if (directLatency != null && directLatency < 9999) {
            return new Route(Arrays.asList(clientRelay, hostRelay), clientRelay.latencyFromClient + directLatency, 0.98);
        }
        return null;
    }

    private static boolean isInPath(List<RelayNode> path, String relayId) {
        for (RelayNode node : path) {
            if (!node.id.equals(relayId)) continue;
            return true;
        }
        return false;
    }

    private static RelayNode findRelayById(List<RelayNode> relays, String id) {
        for (RelayNode relay : relays) {
            if (!relay.id.equals(id)) continue;
            return relay;
        }
        return null;
    }

    public static boolean shouldUseMultiHop(RelayNode clientRelay, RelayNode hostRelay) {
        if (clientRelay.id.equals(hostRelay.id)) {
            return false;
        }
        return !clientRelay.region.equals(hostRelay.region);
    }

    public static int estimateBackboneLatency(String fromRegion, String toRegion) {
        HashMap regionLatencies = new HashMap();
        HashMap<String, Integer> naLatencies = new HashMap<String, Integer>();
        naLatencies.put("NA", 20);
        naLatencies.put("EU", 100);
        naLatencies.put("SA", 150);
        naLatencies.put("APAC", 200);
        regionLatencies.put("NA", naLatencies);
        HashMap<String, Integer> euLatencies = new HashMap<String, Integer>();
        euLatencies.put("NA", 100);
        euLatencies.put("EU", 20);
        euLatencies.put("SA", 180);
        euLatencies.put("APAC", 180);
        regionLatencies.put("EU", euLatencies);
        HashMap<String, Integer> saLatencies = new HashMap<String, Integer>();
        saLatencies.put("NA", 150);
        saLatencies.put("EU", 180);
        saLatencies.put("SA", 30);
        saLatencies.put("APAC", 300);
        regionLatencies.put("SA", saLatencies);
        HashMap<String, Integer> apacLatencies = new HashMap<String, Integer>();
        apacLatencies.put("NA", 200);
        apacLatencies.put("EU", 180);
        apacLatencies.put("SA", 300);
        apacLatencies.put("APAC", 30);
        regionLatencies.put("APAC", apacLatencies);
        Map fromMap = (Map)regionLatencies.get(fromRegion);
        if (fromMap != null && fromMap.containsKey(toRegion)) {
            return (Integer)fromMap.get(toRegion);
        }
        return 150;
    }

    public static class RelayNode {
        public String id;
        public String region;
        public String url;
        public int latencyFromClient;
        public Map<String, Integer> latencyToRelays;

        public RelayNode(String id, String region, String url) {
            this.id = id;
            this.region = region;
            this.url = url;
            this.latencyFromClient = 0;
            this.latencyToRelays = new HashMap<String, Integer>();
        }
    }

    public static class Route {
        public List<RelayNode> hops;
        public int totalLatencyMs;
        public double reliabilityScore;
        public int hopCount;

        public Route(List<RelayNode> hops, int totalLatency, double reliability) {
            this.hops = new ArrayList<RelayNode>(hops);
            this.totalLatencyMs = totalLatency;
            this.reliabilityScore = reliability;
            this.hopCount = hops.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Route[").append(this.hopCount).append(" hops, ").append(this.totalLatencyMs).append("ms, ").append(String.format("%.2f", this.reliabilityScore * 100.0)).append("% reliable]: ");
            for (int i = 0; i < this.hops.size(); ++i) {
                sb.append(this.hops.get((int)i).id);
                if (i >= this.hops.size() - 1) continue;
                sb.append(" \u2192 ");
            }
            return sb.toString();
        }
    }

    private static class RouteCandidate {
        RelayNode relay;
        List<RelayNode> path;
        int totalLatency;
        double reliability;
        int score;

        RouteCandidate(RelayNode relay, List<RelayNode> path, int latency, double reliability) {
            this.relay = relay;
            this.path = path;
            this.totalLatency = latency;
            this.reliability = reliability;
            this.score = this.calculateScore(latency, path.size(), reliability);
        }

        private int calculateScore(int latency, int hops, double reliability) {
            int hopPenalty = hops * 10;
            int reliabilityBonus = (int)(reliability * 50.0);
            return latency + hopPenalty - reliabilityBonus;
        }
    }
}

