/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.networking;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.networking.RouteOptimizer;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.OkHttpClient;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.Request;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.Response;

public class RelayMeshProber {
    private static final int PROBE_TIMEOUT_MS = 3000;
    private static final int MAX_CONCURRENT_PROBES = 10;

    public static Map<String, Integer> measureRelayLatencies(List<TunnelConfig.RelayEndpoint> relays) {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ConcurrentHashMap<String, Integer> results = new ConcurrentHashMap<String, Integer>();
        ArrayList futures = new ArrayList();
        for (TunnelConfig.RelayEndpoint relayEndpoint : relays) {
            futures.add(executor.submit(() -> {
                try {
                    int latency = RelayMeshProber.measureRelayLatency(relay);
                    results.put(relay.id, latency);
                    if (TunnelConfig.getInstance().isDebugMode()) {
                        System.out.println(String.format("[Tunnely] Relay %s (%s) latency: %dms", relay.id, relay.region, latency));
                    }
                }
                catch (Exception e) {
                    System.err.println(String.format("[Tunnely] Failed to measure latency to relay %s: %s", relay.id, e.getMessage()));
                    results.put(relay.id, 9999);
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get(4000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
            }
            catch (Exception exception) {}
        }
        executor.shutdown();
        try {
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
        }
        return results;
    }

    private static int measureRelayLatency(TunnelConfig.RelayEndpoint relay) throws Exception {
        int tcpLatency = RelayMeshProber.measureTcpHandshake(relay.url);
        int httpLatency = RelayMeshProber.measureHttpLatency(relay.url + "/health");
        return Math.min(tcpLatency, httpLatency);
    }

    private static int measureTcpHandshake(String relayUrl) throws Exception {
        URL url = new URL(relayUrl.replace("wss://", "https://").replace("ws://", "http://"));
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = url.getProtocol().equals("https") ? 443 : 8080;
        }
        long startTime = System.nanoTime();
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), 3000);
            long elapsedNanos = System.nanoTime() - startTime;
            int n = (int)(elapsedNanos / 1000000L);
            return n;
        }
    }

    private static int measureHttpLatency(String healthUrl) throws Exception {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(3000L, TimeUnit.MILLISECONDS).readTimeout(3000L, TimeUnit.MILLISECONDS).build();
        long startTime = System.nanoTime();
        Request request = new Request.Builder().url(healthUrl).get().build();
        try (Response response = client.newCall(request).execute();){
            long elapsedNanos = System.nanoTime() - startTime;
            if (!response.isSuccessful()) {
                throw new Exception("Health check failed with HTTP " + response.code());
            }
            int n = (int)(elapsedNanos / 1000000L);
            return n;
        }
    }

    public static Map<String, RouteOptimizer.RelayNode> buildMeshGraph(JsonArray meshData) {
        HashMap<String, RouteOptimizer.RelayNode> nodes = new HashMap<String, RouteOptimizer.RelayNode>();
        for (JsonElement elem : meshData) {
            RouteOptimizer.RelayNode toNode;
            JsonObject conn = elem.getAsJsonObject();
            String fromId = conn.get("from_relay_id").getAsString();
            String fromRegion = conn.get("from_region").getAsString();
            String fromUrl = conn.get("from_url").getAsString();
            String toId = conn.get("to_relay_id").getAsString();
            String toRegion = conn.get("to_region").getAsString();
            String toUrl = conn.get("to_url").getAsString();
            int latencyMs = conn.get("latency_ms").getAsInt();
            RouteOptimizer.RelayNode fromNode = (RouteOptimizer.RelayNode)nodes.get(fromId);
            if (fromNode == null) {
                fromNode = new RouteOptimizer.RelayNode(fromId, fromRegion, fromUrl);
                nodes.put(fromId, fromNode);
            }
            if ((toNode = (RouteOptimizer.RelayNode)nodes.get(toId)) == null) {
                toNode = new RouteOptimizer.RelayNode(toId, toRegion, toUrl);
                nodes.put(toId, toNode);
            }
            fromNode.latencyToRelays.put(toId, latencyMs);
        }
        return nodes;
    }

    public static void enrichWithClientLatencies(Map<String, RouteOptimizer.RelayNode> nodes, Map<String, Integer> clientLatencies) {
        for (Map.Entry<String, Integer> entry : clientLatencies.entrySet()) {
            String relayId = entry.getKey();
            Integer latency = entry.getValue();
            RouteOptimizer.RelayNode node = nodes.get(relayId);
            if (node == null || latency == null) continue;
            node.latencyFromClient = latency;
        }
    }
}

