/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.tunnelyrefab.config.PortForwardingConfig;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.security.RelayValidator;
import org.texboobcat.tunnelyrefab.tunnel.ModDetector;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.InviteFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.util.ContentModerator;

public class HostGameScreen
extends class_437 {
    private final class_437 parent;
    private final TunnelManager manager;
    private class_342 serverNameBox;
    private class_342 maxPlayersBox;
    private class_4185 visibilityButton;
    private class_4185 toggleVisibilityButton;
    private class_4185 onlineModeButton;
    private class_4185 gamemodeButton;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private String selectedVisibility = "invite_only";
    private String currentServerVisibility = "invite_only";
    private int warningIconX = 0;
    private int warningIconY = 0;
    private boolean showWarningTooltip = false;
    private int centerX = 0;
    private int buttonWidth = 200;
    private int buttonHeight = 20;
    private List<PortForwardingConfig> availablePortForwards = new ArrayList<PortForwardingConfig>();
    private Map<PortForwardingConfig, class_4286> portForwardCheckboxes = new HashMap<PortForwardingConfig, class_4286>();
    private final List<class_339> scrollWidgets = new ArrayList<class_339>();
    private final Map<class_339, Integer> widgetBaseY = new HashMap<class_339, Integer>();
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int scrollTop;
    private int scrollBottom;
    private int scrollLeft;
    private int scrollRight;
    private int contentHeight = 0;
    private boolean draggingScrollbar = false;
    private int dragStartMouseY = 0;
    private int dragStartScrollOffset = 0;
    private int labelServerNameY;
    private int labelMaxPlayersY;
    private int labelVisibilityY;
    private int visibilityDescY;
    private int labelOnlineModeY;
    private int labelGamemodeY;
    private int portSectionLabelY;
    private int portSectionDescY;

    public HostGameScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Host Game"));
        this.parent = parent;
        this.manager = TunnelManager.getInstance();
    }

    protected void method_25426() {
        boolean inSingleplayer;
        super.method_25426();
        if (this.availablePortForwards.isEmpty()) {
            this.availablePortForwards = ModDetector.detectInstalledMods();
        }
        this.buttonWidth = 200;
        this.buttonHeight = 20;
        this.centerX = this.field_22789 / 2 - this.buttonWidth / 2;
        boolean bl = inSingleplayer = this.field_22787.method_1576() != null;
        if (!inSingleplayer) {
            int y = 80;
            ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u26a0 Not In World"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$0(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)()).method_46434((int)this.centerX, (int)y, (int)this.buttonWidth, (int)this.buttonHeight).method_46431())).field_22763 = false;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.centerX, this.field_22790 - 30, this.buttonWidth, this.buttonHeight).method_46431());
            this.statusMessage = "\u00a7cYou must be in a world to host!";
            this.statusColor = 0xFF5555;
            return;
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.connected) {
            int y = 80;
            if (status.publicEndpoint != null) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Copy Endpoint"), button -> this.copyToClipboard(status.publicEndpoint)).method_46434(this.centerX, y, this.buttonWidth, this.buttonHeight).method_46431());
                y += 30;
            }
            this.toggleVisibilityButton = class_4185.method_46430((class_2561)this.getActiveVisibilityButtonText(), button -> {
                this.cycleActiveVisibility();
                this.toggleVisibilityButton.method_25355(this.getActiveVisibilityButtonText());
            }).method_46434(this.centerX, y, this.buttonWidth, this.buttonHeight).method_46431();
            this.method_37063((class_364)this.toggleVisibilityButton);
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Invite Friends"), button -> this.field_22787.method_1507((class_437)new InviteFriendsScreen(this, status.sessionId))).method_46434(this.centerX, y += 30, this.buttonWidth, this.buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7cStop Hosting"), button -> this.stopTunnel()).method_46434(this.centerX, y += 40, this.buttonWidth, this.buttonHeight).method_46431());
        } else {
            this.scrollTop = 60;
            this.scrollBottom = this.field_22790 - 80;
            this.scrollLeft = this.centerX;
            this.scrollRight = this.centerX + this.buttonWidth;
            this.scrollOffset = 0;
            this.scrollWidgets.clear();
            this.widgetBaseY.clear();
            this.contentHeight = 0;
            int contentY = this.scrollTop;
            this.labelServerNameY = contentY - 12;
            this.serverNameBox = new class_342(this.field_22793, this.centerX, contentY, this.buttonWidth, this.buttonHeight, (class_2561)class_2561.method_43470((String)"Server Name"));
            this.serverNameBox.method_1880(32);
            this.serverNameBox.method_47404((class_2561)class_2561.method_43470((String)"Enter server name..."));
            this.serverNameBox.method_1852("Minecraft Server");
            this.method_37063((class_364)this.serverNameBox);
            this.registerScrollableWidget((class_339)this.serverNameBox, contentY);
            this.labelMaxPlayersY = (contentY += 35) - 12;
            this.maxPlayersBox = new class_342(this.field_22793, this.centerX, contentY, this.buttonWidth, this.buttonHeight, (class_2561)class_2561.method_43470((String)"Max Players"));
            this.maxPlayersBox.method_1880(2);
            this.maxPlayersBox.method_47404((class_2561)class_2561.method_43470((String)"Max players (1-20)..."));
            this.maxPlayersBox.method_1852(String.valueOf(TunnelConfig.getInstance().getMaxPlayers()));
            this.maxPlayersBox.method_1890(text -> {
                if (text.isEmpty()) {
                    return true;
                }
                try {
                    int val = Integer.parseInt(text);
                    return val >= 1 && val <= 20;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            this.method_37063((class_364)this.maxPlayersBox);
            this.registerScrollableWidget((class_339)this.maxPlayersBox, contentY);
            this.labelVisibilityY = (contentY += 35) - 12;
            this.visibilityButton = class_4185.method_46430((class_2561)this.getVisibilityButtonText(), button -> {
                this.cycleVisibility();
                this.visibilityButton.method_25355(this.getVisibilityButtonText());
            }).method_46434(this.centerX, contentY, this.buttonWidth, this.buttonHeight).method_46431();
            this.method_37063((class_364)this.visibilityButton);
            this.registerScrollableWidget((class_339)this.visibilityButton, contentY);
            this.visibilityDescY = (contentY += 30) + 5;
            this.labelOnlineModeY = (contentY += 25) - 12;
            this.onlineModeButton = class_4185.method_46430((class_2561)this.getOnlineModeButtonText(), button -> {
                this.toggleOnlineMode();
                this.onlineModeButton.method_25355(this.getOnlineModeButtonText());
            }).method_46434(this.centerX, contentY, this.buttonWidth, this.buttonHeight).method_46431();
            this.method_37063((class_364)this.onlineModeButton);
            this.registerScrollableWidget((class_339)this.onlineModeButton, contentY);
            this.labelGamemodeY = (contentY += 35) - 12;
            this.gamemodeButton = class_4185.method_46430((class_2561)this.getGamemodeButtonText(), button -> {
                this.cycleGamemode();
                this.gamemodeButton.method_25355(this.getGamemodeButtonText());
            }).method_46434(this.centerX, contentY, this.buttonWidth, this.buttonHeight).method_46431();
            this.method_37063((class_364)this.gamemodeButton);
            this.registerScrollableWidget((class_339)this.gamemodeButton, contentY);
            contentY += 35;
            if (!this.availablePortForwards.isEmpty()) {
                this.portSectionLabelY = contentY;
                this.portSectionDescY = contentY + 12;
                contentY += 26;
                for (final PortForwardingConfig portConfig : this.availablePortForwards) {
                    boolean portAvailable = ModDetector.isPortAvailable(portConfig.getPort(), portConfig.getProtocol());
                    String label = portConfig.getServiceName() + " (" + portConfig.getShortDisplayString() + ")";
                    if (!portAvailable) {
                        label = label + " \u26a0";
                    }
                    class_4286 checkbox = new class_4286(this.centerX, contentY, 200, 20, (class_2561)class_2561.method_43470((String)label), portConfig.isEnabled()){

                        public void method_25306() {
                            super.method_25306();
                            portConfig.setEnabled(this.method_20372());
                        }
                    };
                    if (!portAvailable) {
                        checkbox.field_22763 = false;
                        portConfig.setEnabled(false);
                    }
                    this.method_37063((class_364)checkbox);
                    this.portForwardCheckboxes.put(portConfig, checkbox);
                    this.registerScrollableWidget((class_339)checkbox, contentY);
                    contentY += 22;
                }
            }
            this.contentHeight = contentY - this.scrollTop;
            this.maxScroll = Math.max(0, this.contentHeight - (this.scrollBottom - this.scrollTop));
            this.layoutScrollWidgets();
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7aStart Hosting"), button -> this.startTunnel()).method_46434(this.centerX, this.field_22790 - 60, this.buttonWidth, this.buttonHeight).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.centerX, this.field_22790 - 30, this.buttonWidth, this.buttonHeight).method_46431());
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        if (TunnelConfig.getInstance().isOfflineMode() && this.warningIconX > 0 && this.warningIconY > 0) {
            int iconWidth = this.field_22793.method_1727("(!)");
            this.showWarningTooltip = mouseX >= this.warningIconX && mouseX <= this.warningIconX + iconWidth + 4 && mouseY >= this.warningIconY - 2 && mouseY <= this.warningIconY + 12;
        } else {
            this.showWarningTooltip = false;
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFAA00);
        if (this.field_22787.method_1576() == null) {
            graphics.method_25300(this.field_22793, "\u00a7c\u26a0 Cannot Host Server", this.field_22789 / 2, 40, 0xFF5555);
            graphics.method_25300(this.field_22793, "\u00a77You must be in a single-player world to host.", this.field_22789 / 2, 60, 0xAAAAAA);
            graphics.method_25300(this.field_22793, "\u00a77Steps:", this.field_22789 / 2, 80, 0xAAAAAA);
            graphics.method_25300(this.field_22793, "\u00a771. Go back to the main menu", this.field_22789 / 2, 95, 0xAAAAAA);
            graphics.method_25300(this.field_22793, "\u00a772. Create a new world or load an existing one", this.field_22789 / 2, 107, 0xAAAAAA);
            graphics.method_25300(this.field_22793, "\u00a773. Open the menu and click 'Tunnely'", this.field_22789 / 2, 119, 0xAAAAAA);
            graphics.method_25300(this.field_22793, "\u00a774. Click 'Host Game' to start hosting", this.field_22789 / 2, 131, 0xAAAAAA);
            if (!this.statusMessage.isEmpty()) {
                graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 - 50, this.statusColor);
            }
            return;
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.connected) {
            graphics.method_25300(this.field_22793, "\u00a7a\u2713 Server is Running", this.field_22789 / 2, 40, 65280);
            if (status.publicEndpoint != null) {
                graphics.method_25300(this.field_22793, "\u00a7eEndpoint:", this.field_22789 / 2, 55, 0xFFFFFF);
                String endpoint = status.publicEndpoint;
                int endpointWidth = this.field_22793.method_1727(endpoint);
                int boxX = this.field_22789 / 2 - endpointWidth / 2 - 5;
                int boxY = 62;
                graphics.method_25294(boxX, boxY, boxX + endpointWidth + 10, boxY + 12, Integer.MIN_VALUE);
                graphics.method_25300(this.field_22793, "\u00a7b" + endpoint, this.field_22789 / 2, 65, 65535);
            }
            if (!this.availablePortForwards.isEmpty()) {
                int activeCount = 0;
                for (PortForwardingConfig portConfig : this.availablePortForwards) {
                    if (!portConfig.isEnabled()) continue;
                    ++activeCount;
                }
                if (activeCount > 0) {
                    int yOffset = 90;
                    graphics.method_25303(this.field_22793, "\u00a7eActive Services:", this.field_22789 / 2 - 80, yOffset, 0xFFAA00);
                    yOffset += 15;
                    for (PortForwardingConfig portConfig : this.availablePortForwards) {
                        if (!portConfig.isEnabled()) continue;
                        graphics.method_25303(this.field_22793, "\u00a7a\u2713 " + portConfig.getDisplayString(), this.field_22789 / 2 - 80, yOffset, 65280);
                        yOffset += 12;
                    }
                }
            }
        } else {
            int yGM;
            int yOM;
            int yDesc;
            int yV;
            int yMP;
            graphics.method_25300(this.field_22793, "\u00a77Configure Your Server", this.field_22789 / 2, 40, 0xAAAAAA);
            try {
                graphics.method_44379(this.scrollLeft, this.scrollTop, this.scrollRight, this.scrollBottom);
            }
            catch (Throwable activeCount) {
                // empty catch block
            }
            int labelX = this.field_22789 / 2 - 100;
            int ySN = this.labelServerNameY - this.scrollOffset;
            if (ySN >= this.scrollTop - 12 && ySN <= this.scrollBottom) {
                graphics.method_25303(this.field_22793, "Server Name:", labelX, ySN, 0xFFFFFF);
            }
            if ((yMP = this.labelMaxPlayersY - this.scrollOffset) >= this.scrollTop - 12 && yMP <= this.scrollBottom) {
                graphics.method_25303(this.field_22793, "Max Players:", labelX, yMP, 0xFFFFFF);
            }
            if ((yV = this.labelVisibilityY - this.scrollOffset) >= this.scrollTop - 12 && yV <= this.scrollBottom) {
                graphics.method_25303(this.field_22793, "Visibility:", labelX, yV, 0xFFFFFF);
            }
            if ((yDesc = this.visibilityDescY - this.scrollOffset) >= this.scrollTop - 12 && yDesc <= this.scrollBottom) {
                String desc = this.getVisibilityDescription();
                graphics.method_25300(this.field_22793, "\u00a77" + desc, this.field_22789 / 2, yDesc, 0xAAAAAA);
            }
            if ((yOM = this.labelOnlineModeY - this.scrollOffset) >= this.scrollTop - 12 && yOM <= this.scrollBottom) {
                graphics.method_25303(this.field_22793, "Authentication:", labelX, yOM, 0xFFFFFF);
                if (TunnelConfig.getInstance().isOfflineMode()) {
                    int buttonEndX = this.centerX + this.buttonWidth + 5;
                    int buttonCenterY = this.labelOnlineModeY + 12 - this.scrollOffset + 5;
                    this.warningIconX = buttonEndX;
                    this.warningIconY = buttonCenterY;
                } else {
                    this.warningIconX = 0;
                    this.warningIconY = 0;
                }
            }
            if ((yGM = this.labelGamemodeY - this.scrollOffset) >= this.scrollTop - 12 && yGM <= this.scrollBottom) {
                graphics.method_25303(this.field_22793, "Default Gamemode:", labelX, yGM, 0xFFFFFF);
            }
            if (!this.availablePortForwards.isEmpty()) {
                int yPortsHint;
                int yPortsDesc;
                int yPorts = this.portSectionLabelY - this.scrollOffset;
                if (yPorts >= this.scrollTop - 12 && yPorts <= this.scrollBottom) {
                    graphics.method_25303(this.field_22793, "\u00a7eAdditional Ports:", labelX, yPorts, 0xFFAA00);
                }
                if ((yPortsDesc = this.portSectionDescY - this.scrollOffset) >= this.scrollTop - 12 && yPortsDesc <= this.scrollBottom) {
                    graphics.method_25303(this.field_22793, "\u00a77Enable voice chat and other services", labelX, yPortsDesc, 0x888888);
                }
                if ((yPortsHint = this.portSectionDescY + 12 - this.scrollOffset) >= this.scrollTop - 12 && yPortsHint <= this.scrollBottom) {
                    graphics.method_25303(this.field_22793, "\u00a77\u26a0 = Port in use by another app", labelX, yPortsHint, 0x888888);
                }
            }
            try {
                graphics.method_44380();
            }
            catch (Throwable yPorts) {
                // empty catch block
            }
            if (this.warningIconX > 0 && this.warningIconY > 0 && TunnelConfig.getInstance().isOfflineMode() && this.warningIconY >= this.scrollTop && this.warningIconY <= this.scrollBottom) {
                graphics.method_25303(this.field_22793, "\u00a7c(!)", this.warningIconX, this.warningIconY, 0xFF5555);
            }
            if (this.maxScroll > 0) {
                int trackX = this.getTrackX();
                int trackTop = this.scrollTop;
                int trackBottom = this.scrollBottom;
                int trackHeight = this.getTrackHeight();
                int thumbHeight = this.getThumbHeight(trackHeight);
                int thumbY = this.getThumbY(trackTop, trackHeight, thumbHeight);
                graphics.method_25294(trackX, trackTop, trackX + 4, trackBottom, Integer.MIN_VALUE);
                graphics.method_25294(trackX, thumbY, trackX + 4, thumbY + thumbHeight, -6250336);
            }
        }
        if (!this.statusMessage.isEmpty()) {
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 - 50, this.statusColor);
        }
        if (this.showWarningTooltip && TunnelConfig.getInstance().isOfflineMode()) {
            String tooltipText = "We do not support piracy";
            int tooltipWidth = this.field_22793.method_1727(tooltipText) + 8;
            int tooltipHeight = 16;
            int tooltipX = this.warningIconX + 15;
            int tooltipY = this.warningIconY - 5;
            if (tooltipX + tooltipWidth > this.field_22789) {
                tooltipX = this.field_22789 - tooltipWidth - 5;
            }
            graphics.method_25294(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -536870912);
            graphics.method_25294(tooltipX - 1, tooltipY - 1, tooltipX + tooltipWidth + 1, tooltipY, -43691);
            graphics.method_25294(tooltipX - 1, tooltipY + tooltipHeight, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight + 1, -43691);
            graphics.method_25294(tooltipX - 1, tooltipY, tooltipX, tooltipY + tooltipHeight, -43691);
            graphics.method_25294(tooltipX + tooltipWidth, tooltipY, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight, -43691);
            graphics.method_25303(this.field_22793, tooltipText, tooltipX + 4, tooltipY + 4, 0xFFFFFF);
        }
    }

    private void startTunnel() {
        if (this.field_22787.method_1576() == null) {
            this.statusMessage = "\u00a7cError: Not in a single-player world!";
            this.statusColor = 0xFF5555;
            return;
        }
        String serverName = this.serverNameBox != null ? this.serverNameBox.method_1882().trim() : "Minecraft Server";
        ContentModerator.ValidationResult validation = ContentModerator.validateServerName(serverName);
        if (!validation.valid) {
            this.statusMessage = "\u00a7c" + validation.errorMessage;
            this.statusColor = 0xFF0000;
            return;
        }
        RelayValidator.RelaySecurityStatus securityStatus = RelayValidator.validateRelayConfig();
        if (!securityStatus.isTrusted()) {
            String relayUrl = TunnelConfig.getInstance().getRelayServerUrl();
            this.field_22787.method_1507((class_437)new WarningPopupScreen(this, this, "\u26a0\ufe0f Untrusted Relay Server", securityStatus.message + "\n\nRelay URL: " + relayUrl + "\n\nThe relay operator can see:\n\u2022 Your IP address and connection metadata\n\u2022 All game traffic (chat, coordinates, etc.)\n\nOnly continue if you trust the relay operator.\nOfficial relays: See documentation", 0xFF0000, this::startTunnelConfirmed));
            return;
        }
        this.startTunnelConfirmed();
    }

    private void startTunnelConfirmed() {
        String serverName = this.serverNameBox != null ? this.serverNameBox.method_1882().trim() : "Minecraft Server";
        int maxPlayers = 8;
        if (this.maxPlayersBox != null && !this.maxPlayersBox.method_1882().isEmpty()) {
            try {
                maxPlayers = Integer.parseInt(this.maxPlayersBox.method_1882());
                if (maxPlayers < 1 || maxPlayers > 20) {
                    this.statusMessage = "\u00a7cMax players must be between 1 and 20";
                    this.statusColor = 0xFF0000;
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.statusMessage = "\u00a7cInvalid max players value";
                this.statusColor = 0xFF0000;
                return;
            }
        }
        TunnelConfig.getInstance().setMaxPlayers(maxPlayers);
        this.statusMessage = "\u00a7eStarting tunnel...";
        this.statusColor = 0xFFFF00;
        String visibility = this.selectedVisibility;
        ArrayList<PortForwardingConfig> enabledPorts = new ArrayList<PortForwardingConfig>();
        for (PortForwardingConfig portConfig : this.availablePortForwards) {
            if (!portConfig.isEnabled()) continue;
            enabledPorts.add(portConfig);
        }
        new Thread(() -> {
            boolean success = this.manager.initializeTunnel((MinecraftServer)this.field_22787.method_1576(), visibility, serverName, enabledPorts);
            this.field_22787.execute(() -> {
                if (success) {
                    int portCount = enabledPorts.size();
                    this.statusMessage = portCount > 0 ? "\u00a7aTunnel started with " + portCount + " additional port(s)!" : "\u00a7aTunnel started!";
                    this.statusColor = 65280;
                    this.field_22787.method_1507((class_437)new HostGameScreen(this.parent));
                } else {
                    this.statusMessage = "\u00a7cFailed to start. Check logs.";
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-Start").start();
    }

    private void stopTunnel() {
        this.statusMessage = "\u00a7eStopping...";
        this.statusColor = 0xFFFF00;
        this.manager.shutdownTunnel();
        this.statusMessage = "\u00a7aStopped";
        this.statusColor = 65280;
        this.field_22787.method_1507((class_437)new HostGameScreen(this.parent));
    }

    private void cycleActiveVisibility() {
        switch (this.currentServerVisibility) {
            case "invite_only": {
                this.currentServerVisibility = "friends_only";
                break;
            }
            case "friends_only": {
                this.currentServerVisibility = "public";
                break;
            }
            case "public": {
                this.currentServerVisibility = "invite_only";
                break;
            }
            default: {
                this.currentServerVisibility = "invite_only";
            }
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.sessionId != null) {
            this.statusMessage = "\u00a7eUpdating...";
            this.statusColor = 0xFFFF00;
            String newVisibility = this.currentServerVisibility;
            new Thread(() -> {
                boolean success = this.manager.updateServerVisibility(newVisibility);
                this.field_22787.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aUpdated!";
                        this.statusColor = 65280;
                    } else {
                        this.statusMessage = "\u00a7cFailed to update";
                        this.statusColor = 0xFF0000;
                    }
                });
            }, "Tunnely-Toggle").start();
        }
    }

    private class_2561 getActiveVisibilityButtonText() {
        switch (this.currentServerVisibility) {
            case "public": {
                return class_2561.method_43470((String)"\ud83c\udf10 Public");
            }
            case "friends_only": {
                return class_2561.method_43470((String)"\ud83d\udc65 Friends Only");
            }
            case "invite_only": {
                return class_2561.method_43470((String)"\ud83d\udd12 Invite Only");
            }
        }
        return class_2561.method_43470((String)"Unknown");
    }

    private void cycleVisibility() {
        switch (this.selectedVisibility) {
            case "invite_only": {
                this.selectedVisibility = "friends_only";
                break;
            }
            case "friends_only": {
                this.selectedVisibility = "public";
                break;
            }
            case "public": {
                this.selectedVisibility = "invite_only";
                break;
            }
            default: {
                this.selectedVisibility = "invite_only";
            }
        }
    }

    private class_2561 getVisibilityButtonText() {
        switch (this.selectedVisibility) {
            case "public": {
                return class_2561.method_43470((String)"\ud83c\udf10 Public");
            }
            case "friends_only": {
                return class_2561.method_43470((String)"\ud83d\udc65 Friends Only");
            }
            case "invite_only": {
                return class_2561.method_43470((String)"\ud83d\udd12 Invite Only");
            }
        }
        return class_2561.method_43470((String)"Unknown");
    }

    private String getVisibilityDescription() {
        switch (this.selectedVisibility) {
            case "public": {
                return "Anyone can join";
            }
            case "friends_only": {
                return "Only friends can join";
            }
            case "invite_only": {
                return "Requires invitation (Most Private)";
            }
        }
        return "";
    }

    private void toggleOnlineMode() {
        TunnelConfig config;
        config.setOfflineMode(!(config = TunnelConfig.getInstance()).isOfflineMode());
        if (config.isOfflineMode()) {
            this.statusMessage = "\u00a7eOffline mode enabled - Authentication disabled";
            this.statusColor = 0xFFAA00;
        } else {
            this.statusMessage = "\u00a7aOnline mode enabled - Authentication required";
            this.statusColor = 65280;
        }
    }

    private class_2561 getOnlineModeButtonText() {
        boolean isOffline = TunnelConfig.getInstance().isOfflineMode();
        if (isOffline) {
            return class_2561.method_43470((String)"\ud83d\udd13 Offline Mode");
        }
        return class_2561.method_43470((String)"\ud83d\udd12 Online Mode");
    }

    private void cycleGamemode() {
        String current;
        TunnelConfig config = TunnelConfig.getInstance();
        String next = switch (current = config.getDefaultGamemode()) {
            case "survival" -> "creative";
            case "creative" -> "adventure";
            case "adventure" -> "spectator";
            case "spectator" -> "survival";
            default -> "survival";
        };
        config.setDefaultGamemode(next);
        this.statusMessage = "\u00a7aGamemode: " + this.capitalize(next);
        this.statusColor = 65280;
    }

    private class_2561 getGamemodeButtonText() {
        String gamemode;
        return class_2561.method_43470((String)((switch (gamemode = TunnelConfig.getInstance().getDefaultGamemode()) {
            case "creative" -> "\ud83c\udfa8";
            case "adventure" -> "\ud83d\uddfa\ufe0f";
            case "spectator" -> "\ud83d\udc7b";
            default -> "\u2694\ufe0f";
        }) + " " + this.capitalize(gamemode)));
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void copyToClipboard(String text) {
        this.field_22787.field_1774.method_1455(text);
        this.statusMessage = "\u00a7aCopied!";
        this.statusColor = 65280;
    }

    private int getTrackX() {
        return this.scrollRight + 6;
    }

    private int getTrackHeight() {
        return this.scrollBottom - this.scrollTop;
    }

    private int getThumbHeight(int trackHeight) {
        return Math.max(20, (int)((float)trackHeight * (float)trackHeight / (float)(this.contentHeight + 1)));
    }

    private int getThumbY(int trackTop, int trackHeight, int thumbHeight) {
        int range = Math.max(1, trackHeight - thumbHeight);
        return trackTop + (this.maxScroll == 0 ? 0 : (int)((float)this.scrollOffset / (float)this.maxScroll * (float)range));
    }

    private void registerScrollableWidget(class_339 widget, int baseY) {
        this.scrollWidgets.add(widget);
        this.widgetBaseY.put(widget, baseY);
    }

    private void layoutScrollWidgets() {
        for (class_339 widget : this.scrollWidgets) {
            boolean within;
            Integer baseY = this.widgetBaseY.get(widget);
            if (baseY == null) continue;
            int newY = baseY - this.scrollOffset;
            widget.method_46419(newY);
            widget.field_22764 = within = newY + widget.method_25364() >= this.scrollTop && newY <= this.scrollBottom;
            widget.field_22763 = within;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (!status.connected && mouseY >= (double)this.scrollTop && mouseY <= (double)this.scrollBottom && this.maxScroll > 0) {
            this.scrollOffset -= (int)(delta * 20.0);
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            this.layoutScrollWidgets();
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (!status.connected && this.maxScroll > 0) {
            int trackX = this.getTrackX();
            int trackTop = this.scrollTop;
            int trackHeight = this.getTrackHeight();
            int thumbHeight = this.getThumbHeight(trackHeight);
            int thumbY = this.getThumbY(trackTop, trackHeight, thumbHeight);
            if (mouseX >= (double)trackX && mouseX <= (double)(trackX + 4) && mouseY >= (double)trackTop && mouseY <= (double)this.scrollBottom) {
                if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                    this.draggingScrollbar = true;
                    this.dragStartMouseY = (int)mouseY;
                    this.dragStartScrollOffset = this.scrollOffset;
                } else {
                    int page = this.scrollBottom - this.scrollTop - 20;
                    this.scrollOffset = mouseY < (double)thumbY ? Math.max(0, this.scrollOffset - page) : Math.min(this.maxScroll, this.scrollOffset + page);
                    this.layoutScrollWidgets();
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingScrollbar && this.maxScroll > 0) {
            int trackHeight = this.getTrackHeight();
            int thumbHeight = this.getThumbHeight(trackHeight);
            int range = Math.max(1, trackHeight - thumbHeight);
            int deltaY = (int)mouseY - this.dragStartMouseY;
            int deltaScroll = (int)((double)deltaY * (double)this.maxScroll / (double)range);
            this.scrollOffset = this.dragStartScrollOffset + deltaScroll;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            this.layoutScrollWidgets();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        int prevOffset = this.scrollOffset;
        super.method_25410(minecraft, width, height);
        this.scrollOffset = Math.min(Math.max(prevOffset, 0), this.maxScroll);
        this.layoutScrollWidgets();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private static /* synthetic */ void lambda$init$0(class_4185 button) {
    }
}

