/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.security;

public class TrustedRelay {
    private final String id;
    private final String region;
    private final String url;
    private final String certificateFingerprint;

    public TrustedRelay(String id, String region, String url, String certificateFingerprint) {
        this.id = id;
        this.region = region;
        this.url = url;
        this.certificateFingerprint = certificateFingerprint;
    }

    public String getId() {
        return this.id;
    }

    public String getRegion() {
        return this.region;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCertificateFingerprint() {
        return this.certificateFingerprint;
    }

    public boolean matchesUrl(String url) {
        if (url == null || this.url == null) {
            return false;
        }
        String normalizedThis = this.url.replaceFirst("^wss?://", "").replaceFirst("/$", "");
        String normalizedOther = url.replaceFirst("^wss?://", "").replaceFirst("/$", "");
        return normalizedThis.equalsIgnoreCase(normalizedOther);
    }

    public String toString() {
        return String.format("TrustedRelay{id='%s', region='%s', url='%s'}", this.id, this.region, this.url);
    }
}

