/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.EncryptionKeyManager;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;

public class SettingsScreen
extends Screen {
    private final Screen parent;
    private final TunnelConfig config;
    private Checkbox enableTunnelingCheckbox;
    private Checkbox debugModeCheckbox;
    private Checkbox messageNotificationsCheckbox;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private String currentUsername = "";

    public SettingsScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Settings"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.f_96543_ / 2 - buttonWidth / 2;
        int startY = this.f_96544_ / 2 - 100;
        this.loadCurrentUsername();
        this.enableTunnelingCheckbox = new Checkbox(centerX, startY, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Enable Tunneling"), this.config.isEnableTunneling());
        this.m_142416_((GuiEventListener)this.enableTunnelingCheckbox);
        this.debugModeCheckbox = new Checkbox(centerX, startY + 30, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Debug Mode"), this.config.isDebugMode());
        this.m_142416_((GuiEventListener)this.debugModeCheckbox);
        this.messageNotificationsCheckbox = new Checkbox(centerX, startY + 60, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Message Notifications"), this.config.isMessageNotificationsEnabled());
        this.m_142416_((GuiEventListener)this.messageNotificationsCheckbox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Change Username"), button -> this.f_96541_.m_91152_((Screen)new UsernameSelectionScreen(this, false))).m_252987_(centerX, startY + 90, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Logout"), button -> this.logout()).m_252987_(centerX, startY + 120, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cDelete Account"), button -> this.openDeleteAccountPage()).m_252987_(centerX, startY + 150, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save Settings"), button -> this.saveSettings()).m_252987_(centerX, startY + 180, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX, this.f_96544_ - 30, buttonWidth, buttonHeight).m_253136_());
    }

    private void loadCurrentUsername() {
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                JsonObject profile = client.getOwnProfile();
                this.currentUsername = profile != null && profile.has("minecraft_name") ? profile.get("minecraft_name").getAsString() : "Not set";
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error loading username: " + e.getMessage());
                this.currentUsername = "Error loading";
            }
        }, "Tunnely-LoadUsername").start();
    }

    private void saveSettings() {
        this.config.setEnableTunneling(this.enableTunnelingCheckbox.m_93840_());
        this.config.setDebugMode(this.debugModeCheckbox.m_93840_());
        this.config.setMessageNotificationsEnabled(this.messageNotificationsCheckbox.m_93840_());
        this.config.save();
        this.statusMessage = "\u00a7aSettings saved!";
        this.statusColor = 65280;
    }

    private void openDeleteAccountPage() {
        try {
            Util.m_137581_().m_137646_("https://tunnely.org");
            this.statusMessage = "\u00a7eOpened account deletion page in browser";
            this.statusColor = 0xFFFF00;
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error opening browser: " + e.getMessage());
            this.statusMessage = "\u00a7cFailed to open browser";
            this.statusColor = 0xFF0000;
        }
    }

    private void logout() {
        PresenceManager.getInstance().stop();
        MessageManager.getInstance().stop();
        EncryptionKeyManager.reset();
        this.config.setUserJwtToken("");
        this.config.save();
        this.statusMessage = "\u00a7aLogged out successfully";
        this.statusColor = 65280;
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.f_96541_.execute(() -> this.f_96541_.m_91152_((Screen)new TunnelyMainScreen(this.parent)));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, "\u00a76\u00a7lSettings", this.f_96543_ / 2, 30, 0xFFFFFF);
        if (!this.currentUsername.isEmpty()) {
            graphics.m_280137_(this.f_96547_, "\u00a77Current Username: \u00a7f" + this.currentUsername, this.f_96543_ / 2, 50, 0xFFFFFF);
        }
        int infoY = 150;
        graphics.m_280137_(this.f_96547_, "\u00a77Configuration File:", this.f_96543_ / 2, this.f_96544_ / 2 + infoY, 0xAAAAAA);
        graphics.m_280137_(this.f_96547_, "\u00a7econfig/tunnelyrefab.json", this.f_96543_ / 2, this.f_96544_ / 2 + infoY + 15, 0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, this.f_96544_ - 50, this.statusColor);
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

