/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.config;

import java.util.Objects;

public class PortForwardingConfig {
    private final int port;
    private final Protocol protocol;
    private final String serviceName;
    private final String description;
    private boolean enabled;

    public PortForwardingConfig(int port, Protocol protocol, String serviceName, String description) {
        this(port, protocol, serviceName, description, false);
    }

    public PortForwardingConfig(int port, Protocol protocol, String serviceName, String description, boolean enabled) {
        if (port < 1024 || port > 65535) {
            throw new IllegalArgumentException("Port must be between 1024 and 65535 (got " + port + ")");
        }
        this.port = port;
        this.protocol = protocol;
        this.serviceName = serviceName;
        this.description = description;
        this.enabled = enabled;
    }

    public int getPort() {
        return this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDisplayString() {
        return this.serviceName + " (" + this.port + "/" + String.valueOf((Object)this.protocol) + ")";
    }

    public String getShortDisplayString() {
        return this.port + "/" + String.valueOf((Object)this.protocol);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortForwardingConfig that = (PortForwardingConfig)o;
        return this.port == that.port && this.protocol == that.protocol;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.port, this.protocol});
    }

    public String toString() {
        return "PortForwardingConfig{port=" + this.port + ", protocol=" + String.valueOf((Object)this.protocol) + ", serviceName='" + this.serviceName + "', enabled=" + this.enabled + "}";
    }

    public PortForwardingConfig withEnabled(boolean enabled) {
        return new PortForwardingConfig(this.port, this.protocol, this.serviceName, this.description, enabled);
    }

    public static enum Protocol {
        TCP,
        UDP;

    }
}

