/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.auth.OAuthHelper;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.TermsOfServiceScreen;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;

public class LoginScreen
extends class_437 {
    private final class_437 parent;
    private class_342 emailBox;
    private class_342 passwordBox;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private boolean isLoading = false;
    private String uiMode = "main";
    private int formStartY;
    private int emailLabelY;
    private int emailInputY;
    private int passwordLabelY;
    private int passwordInputY;

    public LoginScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Tunnely - Login"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        if (this.uiMode.equals("main")) {
            this.initMainMenu();
        } else if (this.uiMode.equals("email")) {
            this.initEmailPasswordForm();
        } else if (this.uiMode.equals("reset")) {
            this.initPasswordResetForm();
        }
    }

    private void initMainMenu() {
        int buttonWidth = Math.min(280, this.field_22789 - 40);
        int buttonHeight = 30;
        int centerX = this.field_22789 / 2 - buttonWidth / 2;
        int availableHeight = this.field_22790 - 120;
        int totalContentHeight = 170;
        int startY = 70 + Math.max(10, (availableHeight - totalContentHeight) / 2);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd37 Sign in with Microsoft"), button -> this.handleMicrosoftLogin()).method_46434(centerX, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2709 Sign in with Email"), button -> {
            this.uiMode = "email";
            this.statusMessage = "";
            this.method_41843();
        }).method_46434(centerX, startY + 70, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190 Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX, this.field_22790 - 30, buttonWidth, 20).method_46431());
    }

    private void initEmailPasswordForm() {
        int inputWidth = Math.min(300, this.field_22789 - 60);
        int inputHeight = 20;
        int centerX = this.field_22789 / 2 - inputWidth / 2;
        int labelHeight = 12;
        int labelGap = 12;
        int inputToInputGap = 30;
        int buttonGap = 8;
        int buttonHeight = 20;
        int totalFormHeight = labelHeight + labelGap + inputHeight + inputToInputGap + labelHeight + labelGap + inputHeight + buttonGap + buttonHeight + buttonGap + buttonHeight + buttonGap + buttonHeight;
        int titleHeight = 60;
        int bottomMargin = 30;
        int statusMargin = 60;
        int availableHeight = this.field_22790 - titleHeight - bottomMargin - statusMargin;
        this.formStartY = totalFormHeight > availableHeight ? titleHeight + 10 : titleHeight + (availableHeight - totalFormHeight) / 2;
        this.emailLabelY = this.formStartY;
        this.emailInputY = this.emailLabelY + labelHeight + labelGap;
        this.emailBox = new class_342(this.field_22793, centerX, this.emailInputY, inputWidth, inputHeight, (class_2561)class_2561.method_43470((String)"Email"));
        this.emailBox.method_1880(100);
        this.emailBox.method_47404((class_2561)class_2561.method_43470((String)"Enter your email"));
        this.method_37063((class_364)this.emailBox);
        this.passwordLabelY = this.emailInputY + inputHeight + inputToInputGap;
        this.passwordInputY = this.passwordLabelY + labelHeight + labelGap;
        this.passwordBox = new class_342(this.field_22793, centerX, this.passwordInputY, inputWidth, inputHeight, (class_2561)class_2561.method_43470((String)"Password"));
        this.passwordBox.method_1880(100);
        this.passwordBox.method_47404((class_2561)class_2561.method_43470((String)"Enter your password"));
        this.method_37063((class_364)this.passwordBox);
        int buttonY = this.passwordInputY + inputHeight + buttonGap;
        int halfWidth = (inputWidth - 8) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Login"), button -> this.handleLogin()).method_46434(centerX, buttonY, halfWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Register"), button -> this.handleRegister()).method_46434(centerX + halfWidth + 8, buttonY, halfWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Forgot Password?"), button -> {
            this.uiMode = "reset";
            this.statusMessage = "";
            this.method_41843();
        }).method_46434(centerX, buttonY += buttonHeight + buttonGap, inputWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190 Other Sign-In Options"), button -> {
            this.uiMode = "main";
            this.statusMessage = "";
            this.method_41843();
        }).method_46434(centerX, buttonY += buttonHeight + buttonGap, inputWidth, buttonHeight).method_46431());
    }

    private void handleMicrosoftLogin() {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.statusMessage = "Opening browser for Microsoft login...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            try {
                OAuthHelper oauthHelper = new OAuthHelper();
                OAuthHelper.OAuthResult result = oauthHelper.startMicrosoftOAuth().get();
                this.field_22787.execute(() -> {
                    if (result.success) {
                        this.processMicrosoftAuthResult(result);
                    } else {
                        this.isLoading = false;
                        this.statusMessage = "Microsoft login failed: " + result.error;
                        this.statusColor = 0xFF0000;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely] OAuth error: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.isLoading = false;
                    this.statusMessage = "OAuth failed: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-OAuth").start();
    }

    private void processMicrosoftAuthResult(OAuthHelper.OAuthResult oauthResult) {
        this.statusMessage = "Validating Microsoft account...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            SupabaseClient.AuthResult authResult;
            SupabaseClient client = new SupabaseClient();
            if (oauthResult.isAuthCode) {
                String redirectUri = oauthResult.redirectUri != null ? oauthResult.redirectUri : "http://127.0.0.1:54321/auth/callback";
                authResult = client.exchangeCodeForToken(oauthResult.token, redirectUri, oauthResult.codeVerifier);
            } else {
                authResult = client.signInWithOAuth(oauthResult.token);
            }
            this.field_22787.execute(() -> {
                this.isLoading = false;
                if (authResult.success) {
                    String currentTosVersion;
                    TunnelConfig config = TunnelConfig.getInstance();
                    if (config.needsTosAcceptance(currentTosVersion = this.getTosVersionFromResource())) {
                        this.statusMessage = "You must accept our Terms of Service";
                        this.statusColor = 0xFFFF00;
                        this.field_22787.method_1507((class_437)new TermsOfServiceScreen(this, () -> {
                            this.field_22787.method_1507((class_437)this);
                            this.completeOAuthLogin(authResult.userId);
                        }));
                    } else {
                        this.recordTosToDatabase();
                        this.completeOAuthLogin(authResult.userId);
                    }
                } else {
                    this.statusMessage = authResult.error;
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-ValidateOAuth").start();
    }

    private void completeOAuthLogin(String userId) {
        this.statusMessage = "Completing login...";
        this.statusColor = 0xFFFF00;
        this.recordTosToDatabase();
        this.createProfileAndReturn(userId);
    }

    private void handleLogin() {
        String currentTosVersion;
        if (this.isLoading) {
            return;
        }
        String email = this.emailBox.method_1882().trim();
        String password = this.passwordBox.method_1882();
        if (email.isEmpty() || password.isEmpty()) {
            this.statusMessage = "Please enter email and password";
            this.statusColor = 0xFF0000;
            return;
        }
        TunnelConfig config = TunnelConfig.getInstance();
        if (config.needsTosAcceptance(currentTosVersion = this.getTosVersionFromResource())) {
            this.statusMessage = "You must accept the Terms of Service to continue";
            this.statusColor = 0xFFFF00;
            this.field_22787.method_1507((class_437)new TermsOfServiceScreen(this, () -> {
                this.field_22787.method_1507((class_437)this);
                this.proceedWithLogin(email, password);
            }));
            return;
        }
        this.proceedWithLogin(email, password);
    }

    private void proceedWithLogin(String email, String password) {
        this.isLoading = true;
        this.statusMessage = "Logging in...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            SupabaseClient.AuthResult result = TunnelManager.getInstance().login(email, password);
            this.field_22787.execute(() -> {
                this.isLoading = false;
                if (result.success) {
                    this.recordTosToDatabase();
                    this.createProfileAndReturn(result.userId);
                } else {
                    this.statusMessage = result.error;
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-Login").start();
    }

    private void recordTosToDatabase() {
        TunnelConfig config = TunnelConfig.getInstance();
        String tosVersion = config.getAcceptedTosVersion();
        if (tosVersion != null && !tosVersion.isEmpty()) {
            new Thread(() -> {
                try {
                    SupabaseClient client = new SupabaseClient();
                    boolean recorded = client.recordTosAcceptance(tosVersion);
                    if (recorded) {
                        System.out.println("[Tunnely] TOS acceptance logged to database");
                    } else {
                        System.err.println("[Tunnely] Failed to log TOS acceptance to database");
                    }
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Error logging TOS to database: " + e.getMessage());
                }
            }, "Tunnely-RecordTOS").start();
        }
    }

    private void createProfileAndReturn(String userId) {
        this.statusMessage = "\u00a7aLogin successful! Loading profile...";
        this.statusColor = 65280;
        new Thread(() -> {
            try {
                Thread.sleep(500L);
                SupabaseClient client = new SupabaseClient();
                JsonObject profile = client.getOwnProfile();
                if (profile == null || !profile.has("minecraft_name")) {
                    System.out.println("[Tunnely UI] No username found, prompting for username selection");
                    this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new UsernameSelectionScreen(this.parent, true)));
                } else {
                    String username = profile.get("minecraft_name").getAsString();
                    System.out.println("[Tunnely UI] Profile found with username: " + username);
                    this.field_22787.execute(() -> new Thread(() -> {
                        try {
                            Thread.sleep(500L);
                            this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new TunnelyMainScreen(this.parent)));
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }).start());
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error checking profile: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new UsernameSelectionScreen(this.parent, true)));
            }
        }, "Tunnely-CheckProfile").start();
    }

    private void handleRegister() {
        String currentTosVersion;
        if (this.isLoading) {
            return;
        }
        String email = this.emailBox.method_1882().trim();
        String password = this.passwordBox.method_1882();
        if (email.isEmpty() || password.isEmpty()) {
            this.statusMessage = "Please enter email and password";
            this.statusColor = 0xFF0000;
            return;
        }
        if (password.length() < 6) {
            this.statusMessage = "Password must be at least 6 characters";
            this.statusColor = 0xFF0000;
            return;
        }
        TunnelConfig config = TunnelConfig.getInstance();
        if (config.needsTosAcceptance(currentTosVersion = this.getTosVersionFromResource())) {
            this.field_22787.method_1507((class_437)new TermsOfServiceScreen(this, () -> this.proceedWithRegistration(email, password)));
        } else {
            this.proceedWithRegistration(email, password);
        }
    }

    private void proceedWithRegistration(String email, String password) {
        this.field_22787.method_1507((class_437)this);
        this.isLoading = true;
        this.statusMessage = "Registering...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            String minecraftName = "Player";
            if (this.field_22787.field_1724 != null) {
                minecraftName = this.field_22787.field_1724.method_5477().getString();
            }
            String finalMinecraftName = minecraftName;
            SupabaseClient.AuthResult result = TunnelManager.getInstance().register(email, password, finalMinecraftName);
            this.field_22787.execute(() -> {
                this.isLoading = false;
                if (result.success) {
                    this.recordTosToDatabase();
                    this.statusMessage = "Registration successful! Please check your email to verify.";
                    this.statusColor = 65280;
                    this.passwordBox.method_1852("");
                } else {
                    this.statusMessage = result.error;
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-Register").start();
    }

    private void initPasswordResetForm() {
        int inputWidth = Math.min(300, this.field_22789 - 60);
        int inputHeight = 20;
        int centerX = this.field_22789 / 2 - inputWidth / 2;
        int labelHeight = 12;
        int labelGap = 12;
        int buttonGap = 8;
        int buttonHeight = 20;
        int totalFormHeight = labelHeight + labelGap + inputHeight + buttonGap + buttonHeight + buttonGap + buttonHeight;
        int titleHeight = 80;
        int bottomMargin = 30;
        int statusMargin = 60;
        int availableHeight = this.field_22790 - titleHeight - bottomMargin - statusMargin;
        int startY = totalFormHeight > availableHeight ? titleHeight + 10 : titleHeight + (availableHeight - totalFormHeight) / 2;
        int emailLabelY = startY;
        int emailInputY = emailLabelY + labelHeight + labelGap;
        this.emailBox = new class_342(this.field_22793, centerX, emailInputY, inputWidth, inputHeight, (class_2561)class_2561.method_43470((String)"Email"));
        this.emailBox.method_1880(100);
        this.emailBox.method_47404((class_2561)class_2561.method_43470((String)"Enter your email"));
        this.method_37063((class_364)this.emailBox);
        int buttonY = emailInputY + inputHeight + buttonGap;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Send Reset Email"), button -> this.handlePasswordReset()).method_46434(centerX, buttonY, inputWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190 Back to Login"), button -> {
            this.uiMode = "email";
            this.statusMessage = "";
            this.method_41843();
        }).method_46434(centerX, buttonY += buttonHeight + buttonGap, inputWidth, buttonHeight).method_46431());
        this.emailLabelY = emailLabelY;
    }

    private void handlePasswordReset() {
        if (this.isLoading) {
            return;
        }
        String email = this.emailBox.method_1882().trim();
        if (email.isEmpty()) {
            this.statusMessage = "Please enter your email address";
            this.statusColor = 0xFF0000;
            return;
        }
        if (!email.contains("@") || !email.contains(".")) {
            this.statusMessage = "Please enter a valid email address";
            this.statusColor = 0xFF0000;
            return;
        }
        this.isLoading = true;
        this.statusMessage = "Sending password reset email...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            SupabaseClient client = new SupabaseClient();
            boolean success = client.requestPasswordReset(email);
            this.field_22787.execute(() -> {
                this.isLoading = false;
                if (success) {
                    this.statusMessage = "\u00a7aPassword reset email sent! Check your inbox.";
                    this.statusColor = 65280;
                    this.emailBox.method_1852("");
                    new Thread(() -> {
                        try {
                            Thread.sleep(3000L);
                            this.field_22787.execute(() -> {
                                this.uiMode = "email";
                                this.statusMessage = "";
                                this.method_41843();
                            });
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }, "Tunnely-ResetRedirect").start();
                } else {
                    this.statusMessage = "Failed to send reset email. Please try again.";
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-PasswordReset").start();
    }

    private String getTosVersionFromResource() {
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/terms-of-service.json");
            if (stream != null) {
                InputStreamReader reader = new InputStreamReader(stream);
                JsonObject json = JsonParser.parseReader(reader).getAsJsonObject();
                return json.has("version") ? json.get("version").getAsString() : "1.0.0";
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error reading TOS version: " + e.getMessage());
        }
        return "1.0.0";
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics, mouseX, mouseY, partialTick);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int titleY = 30;
        graphics.method_25300(this.field_22793, "\u00a76\u00a7lTunnely", this.field_22789 / 2, titleY, 0xFFFFFF);
        if (this.uiMode.equals("main")) {
            graphics.method_25300(this.field_22793, "\u00a7fChoose your sign-in method", this.field_22789 / 2, titleY + 25, 0xAAAAAA);
            int availableHeight = this.field_22790 - 120;
            int totalContentHeight = 170;
            int startY = 70 + Math.max(10, (availableHeight - totalContentHeight) / 2);
            int dividerY = startY + 45;
            int dividerWidth = Math.min(100, (this.field_22789 - 40) / 3);
            int centerX = this.field_22789 / 2;
            graphics.method_25294(centerX - dividerWidth, dividerY, centerX - 25, dividerY + 1, -10066330);
            graphics.method_25294(centerX + 25, dividerY, centerX + dividerWidth, dividerY + 1, -10066330);
            graphics.method_25300(this.field_22793, "\u00a77OR", centerX, dividerY - 4, 0x888888);
            graphics.method_25300(this.field_22793, "\u00a77New users will be registered automatically", this.field_22789 / 2, this.field_22790 - 50, 0x888888);
        } else if (this.uiMode.equals("email")) {
            graphics.method_25300(this.field_22793, "\u00a7fSign in with Email & Password", this.field_22789 / 2, titleY + 25, 0xAAAAAA);
            inputWidth = Math.min(300, this.field_22789 - 60);
            centerX = this.field_22789 / 2 - inputWidth / 2;
            graphics.method_25303(this.field_22793, "\u00a7fEmail:", centerX, this.emailLabelY, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "\u00a7fPassword:", centerX, this.passwordLabelY, 0xFFFFFF);
        } else if (this.uiMode.equals("reset")) {
            graphics.method_25300(this.field_22793, "\u00a76Reset Your Password", this.field_22789 / 2, titleY + 25, 0xFFFFFF);
            graphics.method_25300(this.field_22793, "\u00a77Enter your email to receive a reset link", this.field_22789 / 2, titleY + 40, 0x888888);
            inputWidth = Math.min(300, this.field_22789 - 60);
            centerX = this.field_22789 / 2 - inputWidth / 2;
            graphics.method_25303(this.field_22793, "\u00a7fEmail:", centerX, this.emailLabelY, 0xFFFFFF);
        }
        if (!this.statusMessage.isEmpty()) {
            int statusY = this.field_22790 - 45;
            int maxWidth = this.field_22789 - 60;
            if (this.field_22793.method_1727(this.statusMessage) > maxWidth) {
                String[] words = this.statusMessage.split(" ");
                StringBuilder line = new StringBuilder();
                int yOffset = 0;
                for (String word : words) {
                    String testLine;
                    String string = testLine = line.length() > 0 ? String.valueOf(line) + " " + word : word;
                    if (this.field_22793.method_1727(testLine) > maxWidth) {
                        graphics.method_25300(this.field_22793, line.toString(), this.field_22789 / 2, statusY + yOffset, this.statusColor);
                        line = new StringBuilder(word);
                        yOffset += 10;
                        continue;
                    }
                    line = new StringBuilder(testLine);
                }
                if (line.length() > 0) {
                    graphics.method_25300(this.field_22793, line.toString(), this.field_22789 / 2, statusY + yOffset, this.statusColor);
                }
            } else {
                graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, statusY, this.statusColor);
            }
        }
        if (this.isLoading) {
            graphics.method_25300(this.field_22793, "\u23f3 Please wait...", this.field_22789 / 2, this.field_22790 - 20, 0xFFFF00);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

