/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldDetailsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUpdateScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUploadScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class MyWorldsScreen
extends Screen {
    private final Screen parent;
    private final WorldManager worldManager;
    private List<WorldInfo> myWorlds = new ArrayList<WorldInfo>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 75;
    private int maxScrollOffset = 0;
    private boolean loading = false;
    private String statusMessage = "";
    private WorldInfo hoveredWorld = null;
    private String hoveredButton = null;

    public MyWorldsScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"My Worlds"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        if (!this.worldManager.isAuthenticated()) {
            this.statusMessage = "\u00a7cYou must be logged in to manage your worlds";
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Go to Login"), button -> this.f_96541_.m_91152_((Screen)new LoginScreen(this.parent))).m_252987_(centerX - 75, this.f_96544_ / 2, 150, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX - 50, this.f_96544_ / 2 + 30, 100, 20).m_253136_());
            return;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Upload New World"), button -> this.f_96541_.m_91152_((Screen)new WorldUploadScreen(this))).m_252987_(centerX - 105, this.f_96544_ - 30, 110, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 10, this.f_96544_ - 30, 100, 20).m_253136_());
        this.loadMyWorlds();
    }

    private void loadMyWorlds() {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Loading your worlds...";
        new Thread(() -> {
            try {
                List<WorldInfo> worlds = this.worldManager.getMyWorlds();
                this.f_96541_.execute(() -> {
                    this.myWorlds = worlds;
                    this.scrollOffset = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.myWorlds.isEmpty() ? "You haven't uploaded any worlds yet" : "Loaded " + this.myWorlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void deleteWorld(WorldInfo world) {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Deleting " + world.getName() + "...";
        new Thread(() -> {
            try {
                boolean success = this.worldManager.deleteWorld(world.getId());
                this.f_96541_.execute(() -> {
                    this.loading = false;
                    if (success) {
                        this.statusMessage = "\u00a7a\u2713 World deleted";
                        this.loadMyWorlds();
                    } else {
                        this.statusMessage = "\u00a7c\u2717 Failed to delete world";
                    }
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.loading = false;
                    this.statusMessage = "\u00a7cDelete failed: " + e.getMessage();
                });
            }
        }).start();
    }

    private void viewWorld(WorldInfo world) {
        this.f_96541_.m_91152_((Screen)new WorldDetailsScreen(this, world));
    }

    private void updateMaxScroll() {
        int visibleHeight = this.f_96544_ - 100;
        int contentHeight = this.myWorlds.size() * 75;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280137_(this.f_96547_, "\ud83d\udcc1 My Uploaded Worlds", this.f_96543_ / 2, 15, 0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, 35, 0xAAAAAA);
        }
        this.renderWorldList(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderWorldList(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 55;
        int endY = this.f_96544_ - 50;
        int centerX = this.f_96543_ / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.m_280588_(0, startY, this.f_96543_, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.myWorlds.size(); ++i) {
            WorldInfo world = this.myWorlds.get(i);
            int entryY = yOffset + i * 75;
            if (entryY + 75 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, world, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.m_280618_();
    }

    private void renderWorldEntry(GuiGraphics graphics, WorldInfo world, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 75 - 5;
        int bgColor = hovered ? -2143272896 : -2145378272;
        graphics.m_280509_(x, y, x + width, y + 75 - 5, bgColor);
        graphics.m_280509_(x, y, x + width, y + 1, -12566464);
        graphics.m_280509_(x, y + 75 - 5, x + width, y + 75 - 4, -12566464);
        graphics.m_280488_(this.f_96547_, world.getName(), x + 5, y + 5, 0xFFFFFF);
        String visibilityText = world.isPublic() ? "\u00a7aPublic" : "\u00a77Private";
        graphics.m_280488_(this.f_96547_, visibilityText, x + 5, y + 18, 0xAAAAAA);
        String statsLine = "\u00a77" + world.getFormattedRating() + " | \ud83d\udce5 " + world.getFormattedDownloadCount();
        graphics.m_280488_(this.f_96547_, statsLine, x + 80, y + 18, 0xAAAAAA);
        graphics.m_280488_(this.f_96547_, "\u00a77Uploaded: " + world.getFormattedCreatedAt(), x + 5, y + 31, 0x888888);
        int buttonY = y + 48;
        int buttonWidth = 60;
        int buttonHeight = 18;
        int buttonSpacing = 65;
        boolean viewHovered = this.isMouseOverButton(mouseX, mouseY, x + 5, buttonY, buttonWidth, buttonHeight);
        if (viewHovered) {
            graphics.m_280509_(x + 5, buttonY, x + 5 + buttonWidth, buttonY + buttonHeight, -2130706433);
            this.hoveredWorld = world;
            this.hoveredButton = "view";
        } else {
            graphics.m_280509_(x + 5, buttonY, x + 5 + buttonWidth, buttonY + buttonHeight, -2139062144);
        }
        graphics.m_280137_(this.f_96547_, "View", x + 5 + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        if (!this.loading) {
            boolean updateHovered = this.isMouseOverButton(mouseX, mouseY, x + buttonSpacing + 5, buttonY, buttonWidth, buttonHeight);
            if (updateHovered) {
                graphics.m_280509_(x + buttonSpacing + 5, buttonY, x + buttonSpacing + 5 + buttonWidth, buttonY + buttonHeight, -2147439873);
                this.hoveredWorld = world;
                this.hoveredButton = "update";
            } else {
                graphics.m_280509_(x + buttonSpacing + 5, buttonY, x + buttonSpacing + 5 + buttonWidth, buttonY + buttonHeight, -2147461752);
            }
            graphics.m_280137_(this.f_96547_, "Update", x + buttonSpacing + 5 + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        }
        if (!this.loading) {
            boolean deleteHovered = this.isMouseOverButton(mouseX, mouseY, x + buttonSpacing * 2 + 5, buttonY, buttonWidth, buttonHeight);
            if (deleteHovered) {
                graphics.m_280509_(x + buttonSpacing * 2 + 5, buttonY, x + buttonSpacing * 2 + 5 + buttonWidth, buttonY + buttonHeight, -2130771968);
                this.hoveredWorld = world;
                this.hoveredButton = "delete";
            } else {
                graphics.m_280509_(x + buttonSpacing * 2 + 5, buttonY, x + buttonSpacing * 2 + 5 + buttonWidth, buttonY + buttonHeight, -2139095040);
            }
            graphics.m_280137_(this.f_96547_, "Delete", x + buttonSpacing * 2 + 5 + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        }
    }

    private void updateWorld(WorldInfo world) {
        this.f_96541_.m_91152_((Screen)new WorldUpdateScreen(this, world));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredWorld != null && this.hoveredButton != null) {
            if (this.hoveredButton.equals("view")) {
                this.viewWorld(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("update")) {
                this.updateWorld(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("delete")) {
                this.deleteWorld(this.hoveredWorld);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.hoveredWorld = null;
        this.hoveredButton = null;
        super.m_94757_(mouseX, mouseY);
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }
}

