/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.EncryptionKeyManager;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.DirectJoinScreen;
import org.texboobcat.tunnelyrefab.ui.screens.HostGameScreen;
import org.texboobcat.tunnelyrefab.ui.screens.InvitesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.PublicLobbiesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.SettingsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UnifiedFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldBrowserScreen;

public class TunnelyMainScreen
extends Screen {
    private final Screen parent;
    private final TunnelConfig config;
    private final TunnelManager manager;
    private final List<Button> menuButtons = new ArrayList<Button>();
    private int buttonWidth;
    private final int buttonHeight = 20;
    private int safeTop;
    private final int safeBottom = 70;
    private int spacing;
    private int stackStartY;
    private int stackTotalH;
    private boolean scrollable;
    private double scroll;
    private String footerMessage = "";
    private int footerColor = 0xFFFFFF;
    private int tickCounter = 0;
    private Button hostButton;
    private Button donateButton;
    private Button backButton;

    public TunnelyMainScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Tunnely"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
        this.manager = TunnelManager.getInstance();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.computeHeaderSafeTop();
        this.computeButtons();
        this.addBottomBar();
        this.manager.setDisconnectListener(() -> this.f_96541_.execute(() -> this.updateHostButtonText()));
        if (this.config.isAuthenticated()) {
            new Thread(() -> {
                try {
                    SupabaseClient client = new SupabaseClient();
                    if (client.needsLogin()) {
                        this.f_96541_.execute(() -> this.f_96541_.m_91152_((Screen)new LoginScreen(this.parent)));
                        return;
                    }
                    JsonObject profile = client.getOwnProfile();
                    if (profile == null || !profile.has("minecraft_name")) {
                        System.out.println("[Tunnely] User missing profile or username, redirecting to username selection");
                        this.f_96541_.execute(() -> this.f_96541_.m_91152_((Screen)new UsernameSelectionScreen(this.parent, true)));
                        return;
                    }
                    PresenceManager.getInstance().start();
                    MessageManager.getInstance().start();
                    EncryptionKeyManager.initializeKeys();
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Background initialization error: " + e.getMessage());
                }
            }, "Tunnely-Init").start();
        }
    }

    private void computeHeaderSafeTop() {
        this.safeTop = 45;
    }

    private void computeButtons() {
        this.menuButtons.clear();
        this.buttonWidth = Math.min(240, Math.max(160, (int)((double)this.f_96543_ * 0.3)));
        int centerX = this.f_96543_ / 2 - this.buttonWidth / 2;
        boolean authed = this.config.isAuthenticated();
        if (!authed) {
            this.menuButtons.add(Button.m_253074_((Component)Component.m_237113_((String)"Login / Register"), b -> this.f_96541_.m_91152_((Screen)new LoginScreen(this))).m_252987_(centerX, 0, this.buttonWidth, 20).m_253136_());
        } else {
            boolean inSingleplayer = this.f_96541_.m_91092_() != null;
            boolean isHosting = this.manager.isHosting();
            String buttonText = isHosting ? "Manage" : "Host Game";
            this.hostButton = Button.m_253074_((Component)Component.m_237113_((String)buttonText), b -> {
                if (this.f_96541_.m_91092_() != null) {
                    this.f_96541_.m_91152_((Screen)new HostGameScreen(this));
                } else {
                    this.setFooterMessage("\u00a7cPlease create or load a world first before hosting!", 0xFF5555);
                }
            }).m_252987_(centerX, 0, this.buttonWidth, 20).m_253136_();
            this.hostButton.f_93623_ = inSingleplayer;
            this.menuButtons.add(this.hostButton);
            if (!inSingleplayer) {
                this.setFooterMessage("\u00a77Tip: Create or load a world to enable hosting", 0xAAAAAA);
            }
            this.menuButtons.add(Button.m_253074_((Component)Component.m_237113_((String)"Friends & Servers"), b -> this.f_96541_.m_91152_((Screen)new UnifiedFriendsScreen(this))).m_252987_(centerX, 0, this.buttonWidth, 20).m_253136_());
            this.menuButtons.add(Button.m_253074_((Component)Component.m_237113_((String)"Direct Join"), b -> this.f_96541_.m_91152_((Screen)new DirectJoinScreen(this))).m_252987_(centerX, 0, this.buttonWidth, 20).m_253136_());
            this.menuButtons.add(Button.m_253074_((Component)Component.m_237113_((String)"Invites"), b -> this.f_96541_.m_91152_((Screen)new InvitesScreen(this))).m_252987_(centerX, 0, this.buttonWidth, 20).m_253136_());
            this.menuButtons.add(Button.m_253074_((Component)Component.m_237113_((String)"Public Lobbies"), b -> this.f_96541_.m_91152_((Screen)new PublicLobbiesScreen(this))).m_252987_(centerX, 0, this.buttonWidth, 20).m_253136_());
            this.menuButtons.add(Button.m_253074_((Component)Component.m_237113_((String)"\ud83c\udf0d Browse Worlds"), b -> this.f_96541_.m_91152_((Screen)new WorldBrowserScreen(this))).m_252987_(centerX, 0, this.buttonWidth, 20).m_253136_());
            this.menuButtons.add(Button.m_253074_((Component)Component.m_237113_((String)"Settings"), b -> this.f_96541_.m_91152_((Screen)new SettingsScreen(this))).m_252987_(centerX, 0, this.buttonWidth, 20).m_253136_());
        }
        int count = this.menuButtons.size();
        int areaH = Math.max(0, this.f_96544_ - this.safeTop - 70);
        int ideal = 22;
        int min = 5;
        this.spacing = ideal;
        int needed = count * 20 + (count - 1) * this.spacing;
        if (needed > areaH) {
            int neededMin = count * 20 + (count - 1) * min;
            this.spacing = neededMin > areaH ? min : (areaH - count * 20) / Math.max(1, count - 1);
        }
        this.stackTotalH = count * 20 + (count - 1) * this.spacing;
        boolean bl = this.scrollable = this.stackTotalH > areaH;
        if (!this.scrollable) {
            this.scroll = 0.0;
        }
        this.stackStartY = this.safeTop + Math.max(0, (areaH - this.stackTotalH) / 2);
        for (Button b2 : this.menuButtons) {
            this.m_142416_((GuiEventListener)b2);
        }
        this.layoutButtons();
    }

    private void layoutButtons() {
        int y = this.stackStartY - (int)Math.max(0.0, this.scroll);
        int centerX = this.f_96543_ / 2 - this.buttonWidth / 2;
        for (Button b : this.menuButtons) {
            b.m_252865_(centerX);
            b.m_253211_(y);
            y += 20 + this.spacing;
        }
    }

    private void addBottomBar() {
        int centerX = this.f_96543_ / 2 - this.buttonWidth / 2;
        this.donateButton = Button.m_253074_((Component)Component.m_237113_((String)"Donate"), btn -> this.openDonate()).m_252987_(centerX, this.f_96544_ - 55, this.buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.donateButton);
        this.backButton = Button.m_253074_((Component)Component.m_237113_((String)"Back"), btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX, this.f_96544_ - 30, this.buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.backButton);
    }

    private void openDonate() {
        try {
            Util.m_137581_().m_137646_("https://ko-fi.com/bobcatmods");
            this.footerMessage = "";
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Failed to open browser: " + e.getMessage());
            this.footerMessage = "\u00a7cFailed to open browser";
            this.footerColor = 0xFF5555;
        }
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.tickCounter;
        if (this.tickCounter >= 40) {
            this.tickCounter = 0;
            this.updateHostButtonText();
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float delta) {
        this.m_280273_(g);
        g.m_280137_(this.f_96547_, "\u00a76\u00a7lTunnely", this.f_96543_ / 2, 15, 0xFFFFFF);
        g.m_280137_(this.f_96547_, "\u00a77NAT Traversal", this.f_96543_ / 2, 28, 0xAAAAAA);
        int clipTop = this.safeTop;
        int clipBottom = this.f_96544_ - 70;
        g.m_280588_(0, clipTop, this.f_96543_, clipBottom);
        for (Button btn : this.menuButtons) {
            btn.m_88315_(g, mouseX, mouseY, delta);
        }
        g.m_280618_();
        if (this.donateButton != null) {
            this.donateButton.m_88315_(g, mouseX, mouseY, delta);
        }
        if (this.backButton != null) {
            this.backButton.m_88315_(g, mouseX, mouseY, delta);
        }
        if (!this.footerMessage.isEmpty()) {
            g.m_280137_(this.f_96547_, this.footerMessage, this.f_96543_ / 2, this.f_96544_ - 70, this.footerColor);
        }
        if (this.scrollable) {
            int areaTop = this.safeTop;
            int areaH = Math.max(10, this.f_96544_ - this.safeTop - 70);
            int barX = this.f_96543_ - 10;
            int total = Math.max(1, this.stackTotalH);
            int thumbH = Math.max(20, areaH * areaH / total);
            int maxScroll = Math.max(1, this.stackTotalH - areaH);
            int thumbY = areaTop + (int)(this.scroll * (double)(areaH - thumbH) / (double)maxScroll);
            g.m_280509_(barX, areaTop, barX + 6, areaTop + areaH, 0x40FFFFFF);
            g.m_280509_(barX, thumbY, barX + 6, thumbY + thumbH, -2130706433);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.scrollable) {
            return super.m_6050_(mouseX, mouseY, delta);
        }
        int areaH = Math.max(10, this.f_96544_ - this.safeTop - 70);
        int maxScroll = Math.max(0, this.stackTotalH - areaH);
        this.scroll = Math.max(0.0, Math.min((double)maxScroll, this.scroll - delta * 22.0));
        this.layoutButtons();
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.donateButton != null && this.donateButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.backButton != null && this.backButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int clipTop = this.safeTop;
        int clipBottom = this.f_96544_ - 70;
        if (mouseY >= (double)clipTop && mouseY <= (double)clipBottom) {
            for (Button btn : this.menuButtons) {
                if (!btn.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6574_(Minecraft mc, int w, int h) {
        super.m_6574_(mc, w, h);
        this.m_169413_();
        this.m_7856_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private void setFooterMessage(String message, int color) {
        this.footerMessage = message;
        this.footerColor = color;
    }

    private void updateHostButtonText() {
        if (this.hostButton != null) {
            boolean isHosting = this.manager.isHosting();
            String buttonText = isHosting ? "Manage" : "Host Game";
            this.hostButton.m_93666_((Component)Component.m_237113_((String)buttonText));
            System.out.println("[Tunnely] Host button updated: " + buttonText);
        }
    }
}

