/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicInteger;
import org.texboobcat.tunnelyrefab.shaded.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.texboobcat.tunnelyrefab.shaded.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.texboobcat.tunnelyrefab.shaded.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.LZMA2Options;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.XZInputStream;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.XZOutputStream;
import org.texboobcat.tunnelyrefab.worlds.CompressionProgressCallback;
import org.texboobcat.tunnelyrefab.worlds.WorldScannerUtil;

public class WorldCompressorLZMA {
    private static final int BUFFER_SIZE = 65536;

    public static CompressResult compress(Path worldPath, Path outputFile, CompressionProgressCallback callback) {
        if (!Files.exists(worldPath, new LinkOption[0]) || !Files.isDirectory(worldPath, new LinkOption[0])) {
            return new CompressResult(false, "World path does not exist or is not a directory", 0L, 0L);
        }
        long startTime = System.currentTimeMillis();
        long originalSize = 0L;
        long compressedSize = 0L;
        AtomicInteger filesCompressed = new AtomicInteger(0);
        try {
            long totalFiles = Files.walk(worldPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> !WorldScannerUtil.shouldExclude(p.getFileName().toString())).count();
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            try (FileOutputStream fos = new FileOutputStream(outputFile.toFile());
                 BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);
                 XZOutputStream xzos = WorldCompressorLZMA.createXZOutputStream(bos);
                 TarArchiveOutputStream tos = new TarArchiveOutputStream(xzos);){
                tos.setLongFileMode(3);
                tos.setBigNumberMode(2);
                Files.walk(worldPath, new FileVisitOption[0]).forEach(sourcePath -> {
                    if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                        return;
                    }
                    String filename = sourcePath.getFileName().toString();
                    if (WorldScannerUtil.shouldExclude(filename)) {
                        return;
                    }
                    try {
                        Path relativePath = worldPath.relativize((Path)sourcePath);
                        String entryName = relativePath.toString().replace('\\', '/');
                        long fileSize = Files.size(sourcePath);
                        TarArchiveEntry entry = new TarArchiveEntry(sourcePath.toFile(), entryName);
                        entry.setSize(fileSize);
                        tos.putArchiveEntry(entry);
                        Files.copy(sourcePath, tos);
                        tos.closeArchiveEntry();
                        int currentCount = filesCompressed.incrementAndGet();
                        if (callback != null && totalFiles > 0L) {
                            int percentage = (int)((long)(currentCount * 100) / totalFiles);
                            callback.onProgress(percentage, filename);
                        }
                    }
                    catch (IOException e) {
                        System.err.println("[WorldCompressorLZMA] Failed to compress file " + filename + ": " + e.getMessage());
                    }
                });
            }
            originalSize = WorldScannerUtil.calculateWorldSize(worldPath);
            compressedSize = Files.size(outputFile);
            long duration = System.currentTimeMillis() - startTime;
            double compressionRatio = originalSize > 0L ? 100.0 * (double)compressedSize / (double)originalSize : 0.0;
            String message = String.format("Compressed %d files from %s to %s (%.1f%%) in %.1f seconds using LZMA2", filesCompressed.get(), WorldScannerUtil.formatSize(originalSize), WorldScannerUtil.formatSize(compressedSize), compressionRatio, (double)duration / 1000.0);
            if (callback != null) {
                callback.onComplete(true, message);
            }
            System.out.println("[WorldCompressorLZMA] " + message);
            return new CompressResult(true, message, compressedSize, originalSize);
        }
        catch (Exception e) {
            String errorMsg = "Compression failed: " + e.getMessage();
            System.err.println("[WorldCompressorLZMA] " + errorMsg);
            e.printStackTrace();
            if (callback != null) {
                callback.onComplete(false, errorMsg);
            }
            return new CompressResult(false, errorMsg, 0L, 0L);
        }
    }

    private static XZOutputStream createXZOutputStream(OutputStream out) throws IOException {
        LZMA2Options options = new LZMA2Options();
        options.setPreset(6);
        options.setDictSize(0x800000);
        return new XZOutputStream(out, options);
    }

    public static CompressResult compress(Path worldPath, Path outputFile) {
        return WorldCompressorLZMA.compress(worldPath, outputFile, null);
    }

    public static DecompressResult decompress(Path xzFile, Path outputDir, CompressionProgressCallback callback) {
        if (!Files.exists(xzFile, new LinkOption[0]) || !Files.isRegularFile(xzFile, new LinkOption[0])) {
            return new DecompressResult(false, "XZ file does not exist or is not a file", 0);
        }
        long startTime = System.currentTimeMillis();
        int filesExtracted = 0;
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
            try (FileInputStream fis = new FileInputStream(xzFile.toFile());
                 BufferedInputStream bis = new BufferedInputStream(fis, 65536);
                 XZInputStream xzis = new XZInputStream(bis);
                 TarArchiveInputStream tis = new TarArchiveInputStream(xzis);){
                TarArchiveEntry entry;
                byte[] buffer = new byte[65536];
                while ((entry = tis.getNextTarEntry()) != null) {
                    String entryName = entry.getName();
                    if (entryName.contains("..") || entryName.startsWith("/") || entryName.startsWith("\\")) {
                        System.err.println("[WorldCompressorLZMA] Blocked suspicious path: " + entryName);
                        continue;
                    }
                    Path outputPath = outputDir.resolve(entryName);
                    if (entry.isDirectory()) {
                        Files.createDirectories(outputPath, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                    try (FileOutputStream fos = new FileOutputStream(outputPath.toFile());
                         BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);){
                        int bytesRead;
                        while ((bytesRead = tis.read(buffer)) != -1) {
                            bos.write(buffer, 0, bytesRead);
                        }
                    }
                    if (entry.getModTime() != null) {
                        Files.setLastModifiedTime(outputPath, FileTime.fromMillis(entry.getModTime().getTime()));
                    }
                    ++filesExtracted;
                    if (callback == null) continue;
                    callback.onProgress(0, entryName);
                }
            }
            long duration = System.currentTimeMillis() - startTime;
            String message = String.format("Extracted %d files in %.1f seconds", filesExtracted, (double)duration / 1000.0);
            if (callback != null) {
                callback.onComplete(true, message);
            }
            System.out.println("[WorldCompressorLZMA] " + message);
            return new DecompressResult(true, message, filesExtracted);
        }
        catch (Exception e) {
            String errorMsg = "Decompression failed: " + e.getMessage();
            System.err.println("[WorldCompressorLZMA] " + errorMsg);
            e.printStackTrace();
            if (callback != null) {
                callback.onComplete(false, errorMsg);
            }
            return new DecompressResult(false, errorMsg, 0);
        }
    }

    public static DecompressResult decompress(Path xzFile, Path outputDir) {
        return WorldCompressorLZMA.decompress(xzFile, outputDir, null);
    }

    public static class CompressResult {
        private final boolean success;
        private final String message;
        private final long compressedSize;
        private final long originalSize;

        public CompressResult(boolean success, String message, long compressedSize, long originalSize) {
            this.success = success;
            this.message = message;
            this.compressedSize = compressedSize;
            this.originalSize = originalSize;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getOriginalSize() {
            return this.originalSize;
        }
    }

    public static class DecompressResult {
        private final boolean success;
        private final String message;
        private final int filesExtracted;

        public DecompressResult(boolean success, String message, int filesExtracted) {
            this.success = success;
            this.message = message;
            this.filesExtracted = filesExtracted;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public int getFilesExtracted() {
            return this.filesExtracted;
        }
    }
}

