/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.LZMA2Options;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.XZOutputStream;
import org.texboobcat.tunnelyrefab.worlds.CompressionProgressCallback;
import org.texboobcat.tunnelyrefab.worlds.WorldCompressorLZMA;
import org.texboobcat.tunnelyrefab.worlds.WorldScannerUtil;

public class WorldCompressorParallel {
    private static final int BUFFER_SIZE = 65536;
    private static final int THREAD_COUNT = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);

    public static WorldCompressorLZMA.CompressResult compress(Path worldPath, Path outputFile, CompressionProgressCallback callback) {
        if (!Files.exists(worldPath, new LinkOption[0]) || !Files.isDirectory(worldPath, new LinkOption[0])) {
            return new WorldCompressorLZMA.CompressResult(false, "World path does not exist", 0L, 0L);
        }
        long startTime = System.currentTimeMillis();
        AtomicInteger filesCompressed = new AtomicInteger(0);
        AtomicLong totalBytesProcessed = new AtomicLong(0L);
        try {
            ArrayList filesToCompress = new ArrayList();
            Files.walk(worldPath, new FileVisitOption[0]).forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0]) && !WorldScannerUtil.shouldExclude(path.getFileName().toString())) {
                    filesToCompress.add(path);
                }
            });
            int totalFiles = filesToCompress.size();
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            try (FileOutputStream fos = new FileOutputStream(outputFile.toFile());
                 BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);
                 XZOutputStream xzos = WorldCompressorParallel.createFastXZOutputStream(bos);){
                TarOutputStream tos = new TarOutputStream(xzos);
                for (Path sourcePath : filesToCompress) {
                    String filename = sourcePath.getFileName().toString();
                    try {
                        Path relativePath = worldPath.relativize(sourcePath);
                        String entryName = relativePath.toString().replace('\\', '/');
                        long fileSize = Files.size(sourcePath);
                        TarEntry entry = new TarEntry(entryName);
                        entry.setSize(fileSize);
                        entry.setModTime(Files.getLastModifiedTime(sourcePath, new LinkOption[0]).toMillis());
                        tos.putNextEntry(entry);
                        Files.copy(sourcePath, tos);
                        tos.closeEntry();
                        int currentCount = filesCompressed.incrementAndGet();
                        totalBytesProcessed.addAndGet(fileSize);
                        if (callback == null || totalFiles <= 0) continue;
                        int percentage = currentCount * 100 / totalFiles;
                        callback.onProgress(percentage, filename);
                    }
                    catch (IOException e) {
                        System.err.println("[WorldCompressorParallel] Failed to compress: " + filename);
                    }
                }
                tos.close();
            }
            long originalSize = WorldScannerUtil.calculateWorldSize(worldPath);
            long compressedSize = Files.size(outputFile);
            long duration = System.currentTimeMillis() - startTime;
            double compressionRatio = originalSize > 0L ? 100.0 * (double)compressedSize / (double)originalSize : 0.0;
            String message = String.format("Compressed %d files from %s to %s (%.1f%%) in %.1f seconds using Fast LZMA2", filesCompressed.get(), WorldScannerUtil.formatSize(originalSize), WorldScannerUtil.formatSize(compressedSize), compressionRatio, (double)duration / 1000.0);
            if (callback != null) {
                callback.onComplete(true, message);
            }
            System.out.println("[WorldCompressorParallel] " + message);
            return new WorldCompressorLZMA.CompressResult(true, message, compressedSize, originalSize);
        }
        catch (Exception e) {
            String errorMsg = "Compression failed: " + e.getMessage();
            System.err.println("[WorldCompressorParallel] " + errorMsg);
            e.printStackTrace();
            if (callback != null) {
                callback.onComplete(false, errorMsg);
            }
            return new WorldCompressorLZMA.CompressResult(false, errorMsg, 0L, 0L);
        }
    }

    private static XZOutputStream createFastXZOutputStream(OutputStream out) throws IOException {
        LZMA2Options options = new LZMA2Options();
        options.setPreset(3);
        options.setDictSize(0x800000);
        return new XZOutputStream(out, options);
    }

    private static class TarOutputStream
    extends FilterOutputStream {
        public TarOutputStream(OutputStream out) {
            super(out);
        }

        public void putNextEntry(TarEntry entry) throws IOException {
            byte[] header = entry.getHeader();
            this.out.write(header);
        }

        public void closeEntry() throws IOException {
        }

        @Override
        public void close() throws IOException {
            byte[] endMarker = new byte[1024];
            this.out.write(endMarker);
            super.close();
        }
    }

    private static class TarEntry {
        private String name;
        private long size;
        private long modTime;

        public TarEntry(String name) {
            this.name = name;
        }

        public byte[] getHeader() {
            byte[] header = new byte[512];
            TarEntry.writeString(header, 0, this.name, 100);
            TarEntry.writeOctal(header, 100, 420L, 8);
            TarEntry.writeOctal(header, 108, 0L, 8);
            TarEntry.writeOctal(header, 116, 0L, 8);
            TarEntry.writeOctal(header, 124, this.size, 12);
            TarEntry.writeOctal(header, 136, this.modTime / 1000L, 12);
            for (int i = 148; i < 156; ++i) {
                header[i] = 32;
            }
            header[156] = 48;
            long checksum = 0L;
            for (byte b : header) {
                checksum += (long)(b & 0xFF);
            }
            TarEntry.writeOctal(header, 148, checksum, 8);
            return header;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setModTime(long modTime) {
            this.modTime = modTime;
        }

        private static void writeString(byte[] buffer, int offset, String str, int length) {
            byte[] bytes = str.getBytes();
            int copyLength = Math.min(bytes.length, length - 1);
            System.arraycopy(bytes, 0, buffer, offset, copyLength);
        }

        private static void writeOctal(byte[] buffer, int offset, long value, int length) {
            String octal = Long.toOctalString(value);
            byte[] bytes = octal.getBytes();
            int copyLength = Math.min(bytes.length, length - 1);
            int start = offset + length - 1 - copyLength;
            System.arraycopy(bytes, 0, buffer, start, copyLength);
        }
    }
}

