/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.MediaType;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.OkHttpClient;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.Request;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.RequestBody;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.Response;
import org.texboobcat.tunnelyrefab.shaded.okhttp3.ResponseBody;
import org.texboobcat.tunnelyrefab.worlds.CompressionProgressCallback;
import org.texboobcat.tunnelyrefab.worlds.ContentModerator;
import org.texboobcat.tunnelyrefab.worlds.WorldChunkPruner;
import org.texboobcat.tunnelyrefab.worlds.WorldComment;
import org.texboobcat.tunnelyrefab.worlds.WorldCompressorLZMA;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldScannerUtil;
import org.texboobcat.tunnelyrefab.worlds.WorldUploadRequest;

public class WorldManager {
    private static final Gson GSON = new Gson();
    private static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    private static final long MAX_COMPRESSED_SIZE = 524288000L;
    private final TunnelConfig config = TunnelConfig.getInstance();
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(300L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).build();

    public boolean isAuthenticated() {
        if (!this.config.isAuthenticated()) {
            return false;
        }
        String url = this.config.getSupabaseUrl() + "/rest/v1/worlds?limit=1";
        Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public UploadResult uploadWorld(WorldUploadRequest request) {
        return this.uploadWorld(request, null);
    }

    public UploadResult updateWorld(String worldId, WorldUploadRequest request) {
        return this.uploadWorld(request, worldId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private UploadResult uploadWorld(WorldUploadRequest request, String existingWorldId) {
        block46: {
            block44: {
                block45: {
                    block42: {
                        block43: {
                            block40: {
                                block41: {
                                    block38: {
                                        block39: {
                                            block36: {
                                                block37: {
                                                    block34: {
                                                        block35: {
                                                            validationError = request.validate();
                                                            if (validationError != null) {
                                                                return new UploadResult(false, validationError, null);
                                                            }
                                                            savesDir = Paths.get("saves", new String[0]);
                                                            worldPath = savesDir.resolve(request.getWorldFolderName());
                                                            if (!Files.exists(worldPath, new LinkOption[0]) || !Files.isDirectory(worldPath, new LinkOption[0])) {
                                                                return new UploadResult(false, "World folder not found: " + request.getWorldFolderName(), null);
                                                            }
                                                            System.out.println("[WorldManager] Starting upload for: " + request.getWorldName());
                                                            tempWorldPath = null;
                                                            System.out.println("[WorldManager] Scanning world for security issues...");
                                                            scanResult = WorldScannerUtil.scanWorld(worldPath);
                                                            if (scanResult.isSafe()) break block34;
                                                            errorMsg = new StringBuilder("World contains dangerous files:\n");
                                                            for (String blocked : scanResult.getBlockedFiles()) {
                                                                errorMsg.append("- ").append(blocked).append("\n");
                                                            }
                                                            var9_11 = new UploadResult(false, errorMsg.toString(), null);
                                                            if (tempWorldPath == null) break block35;
                                                            try {
                                                                System.out.println("[WorldManager] Cleaning up temporary world copy...");
                                                                this.deleteDirectory(tempWorldPath);
                                                                System.out.println("[WorldManager] Temporary copy deleted");
                                                            }
                                                            catch (IOException e) {
                                                                System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
                                                            }
                                                        }
                                                        return var9_11;
                                                    }
                                                    pathToCompress = worldPath;
                                                    if (!request.isPruneUninhabitedChunks()) ** GOTO lbl57
                                                    System.out.println("[WorldManager] Creating temporary world copy for chunk pruning...");
                                                    tempWorldPath = Files.createTempDirectory("world_prune_", new FileAttribute[0]);
                                                    this.copyDirectory(worldPath, tempWorldPath);
                                                    System.out.println("[WorldManager] Temporary copy created at: " + String.valueOf(tempWorldPath));
                                                    System.out.println("[WorldManager] Pruning uninhabited chunks from temporary copy...");
                                                    pruneResult = WorldChunkPruner.pruneWorld(tempWorldPath, request.getProgressCallback());
                                                    if (pruneResult.isSuccess()) break block36;
                                                    System.err.println("[WorldManager] Pruning failed, aborting upload to protect original world");
                                                    e = new UploadResult(false, "Chunk pruning failed: " + pruneResult.getMessage() + ". Upload aborted to protect your world.", null);
                                                    if (tempWorldPath == null) break block37;
                                                    try {
                                                        System.out.println("[WorldManager] Cleaning up temporary world copy...");
                                                        this.deleteDirectory(tempWorldPath);
                                                        System.out.println("[WorldManager] Temporary copy deleted");
                                                    }
                                                    catch (IOException e) {
                                                        System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
                                                    }
                                                }
                                                return e;
                                            }
                                            System.out.println("[WorldManager] " + pruneResult.getMessage());
                                            pathToCompress = tempWorldPath;
lbl57:
                                            // 2 sources

                                            System.out.println("[WorldManager] Compressing world with LZMA2 (fast mode)...");
                                            tempFile = Files.createTempFile("world_upload_", ".tar.xz", new FileAttribute[0]);
                                            compressResult = WorldCompressorLZMA.compress(pathToCompress, tempFile, request.getProgressCallback());
                                            if (compressResult.isSuccess()) break block38;
                                            Files.deleteIfExists(tempFile);
                                            e = new UploadResult(false, "Failed to compress world: " + compressResult.getMessage(), null);
                                            if (tempWorldPath == null) break block39;
                                            try {
                                                System.out.println("[WorldManager] Cleaning up temporary world copy...");
                                                this.deleteDirectory(tempWorldPath);
                                                System.out.println("[WorldManager] Temporary copy deleted");
                                            }
                                            catch (IOException e) {
                                                System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
                                            }
                                        }
                                        return e;
                                    }
                                    if (compressResult.getCompressedSize() <= 524288000L) break block40;
                                    Files.deleteIfExists(tempFile);
                                    e = new UploadResult(false, "Compressed world is too large: " + WorldScannerUtil.formatSize(compressResult.getCompressedSize()) + " (max: " + WorldScannerUtil.formatSize(524288000L) + ")", null);
                                    if (tempWorldPath == null) break block41;
                                    try {
                                        System.out.println("[WorldManager] Cleaning up temporary world copy...");
                                        this.deleteDirectory(tempWorldPath);
                                        System.out.println("[WorldManager] Temporary copy deleted");
                                    }
                                    catch (IOException e) {
                                        System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
                                    }
                                }
                                return e;
                            }
                            System.out.println("[WorldManager] Checking for world screenshot...");
                            screenshotUrl = this.uploadScreenshot(worldPath, request.getWorldFolderName());
                            System.out.println("[WorldManager] Uploading to Supabase Storage...");
                            fileUrl = this.uploadToStorage(tempFile, request.getWorldFolderName());
                            if (fileUrl != null) break block42;
                            Files.deleteIfExists(tempFile);
                            var13_25 = new UploadResult(false, "Failed to upload file to storage", null);
                            if (tempWorldPath == null) break block43;
                            try {
                                System.out.println("[WorldManager] Cleaning up temporary world copy...");
                                this.deleteDirectory(tempWorldPath);
                                System.out.println("[WorldManager] Temporary copy deleted");
                            }
                            catch (IOException e) {
                                System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
                            }
                        }
                        return var13_25;
                    }
                    if (existingWorldId != null) {
                        System.out.println("[WorldManager] Updating existing world entry...");
                        worldInfo = this.updateDatabaseEntry(existingWorldId, request, fileUrl, screenshotUrl, compressResult.getCompressedSize(), compressResult.getOriginalSize());
                    } else {
                        System.out.println("[WorldManager] Creating new database entry...");
                        worldInfo = this.createDatabaseEntry(request, fileUrl, screenshotUrl, compressResult.getCompressedSize(), compressResult.getOriginalSize());
                    }
                    Files.deleteIfExists(tempFile);
                    if (worldInfo != null) break block44;
                    e = new UploadResult(false, existingWorldId != null ? "Failed to update database entry" : "Failed to create database entry", null);
                    if (tempWorldPath == null) break block45;
                    try {
                        System.out.println("[WorldManager] Cleaning up temporary world copy...");
                        this.deleteDirectory(tempWorldPath);
                        System.out.println("[WorldManager] Temporary copy deleted");
                    }
                    catch (IOException e) {
                        System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
                    }
                }
                return e;
            }
            successMessage = existingWorldId != null ? "World updated successfully!" : "World uploaded successfully!";
            System.out.println("[WorldManager] " + successMessage + " World ID: " + worldInfo.getId());
            var15_31 = new UploadResult(true, successMessage, worldInfo);
            if (tempWorldPath == null) break block46;
            try {
                System.out.println("[WorldManager] Cleaning up temporary world copy...");
                this.deleteDirectory(tempWorldPath);
                System.out.println("[WorldManager] Temporary copy deleted");
            }
            catch (IOException e) {
                System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
            }
        }
        return var15_31;
        catch (Exception e) {
            block47: {
                try {
                    System.err.println("[WorldManager] Upload failed: " + e.getMessage());
                    e.printStackTrace();
                    var8_10 = new UploadResult(false, "Upload failed: " + e.getMessage(), null);
                    if (tempWorldPath == null) break block47;
                }
                catch (Throwable var17_33) {
                    if (tempWorldPath != null) {
                        try {
                            System.out.println("[WorldManager] Cleaning up temporary world copy...");
                            this.deleteDirectory(tempWorldPath);
                            System.out.println("[WorldManager] Temporary copy deleted");
                        }
                        catch (IOException e) {
                            System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
                        }
                    }
                    throw var17_33;
                }
                try {
                    System.out.println("[WorldManager] Cleaning up temporary world copy...");
                    this.deleteDirectory(tempWorldPath);
                    System.out.println("[WorldManager] Temporary copy deleted");
                }
                catch (IOException e) {
                    System.err.println("[WorldManager] Failed to delete temporary copy: " + e.getMessage());
                }
            }
            return var8_10;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String uploadScreenshot(Path worldPath, String worldName) {
        try {
            Path iconPath = worldPath.resolve("icon.png");
            if (!Files.exists(iconPath, new LinkOption[0])) {
                System.out.println("[WorldManager] No icon.png found in world folder");
                return null;
            }
            String userId = this.config.getSupabaseUserId();
            if (userId == null || userId.isEmpty()) {
                System.err.println("[WorldManager] No user ID available for screenshot upload");
                return null;
            }
            String fileName = userId + "/" + System.currentTimeMillis() + "_" + this.sanitizeFileName(worldName) + ".png";
            String url = this.config.getSupabaseUrl() + "/storage/v1/object/world-screenshots/" + fileName;
            RequestBody fileBody = RequestBody.create(MediaType.parse("image/png"), iconPath.toFile());
            Request request = new Request.Builder().url(url).post(fileBody).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    String publicUrl = this.config.getSupabaseUrl() + "/storage/v1/object/public/world-screenshots/" + fileName;
                    System.out.println("[WorldManager] Screenshot uploaded: " + publicUrl);
                    String string = publicUrl;
                    return string;
                }
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[WorldManager] Screenshot upload failed: " + response.code() + " - " + errorBody);
                String string = null;
                return string;
            }
        }
        catch (IOException e) {
            System.err.println("[WorldManager] Screenshot upload error: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String uploadToStorage(Path zipFile, String worldName) {
        try {
            String userId = this.config.getSupabaseUserId();
            if (userId == null || userId.isEmpty()) {
                System.err.println("[WorldManager] No user ID available");
                return null;
            }
            String fileName = userId + "/" + System.currentTimeMillis() + "_" + worldName + ".tar.xz";
            String url = this.config.getSupabaseUrl() + "/storage/v1/object/worlds/" + fileName;
            RequestBody fileBody = RequestBody.create(MediaType.parse("application/x-xz"), zipFile.toFile());
            Request request = new Request.Builder().url(url).post(fileBody).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    String string = this.config.getSupabaseUrl() + "/storage/v1/object/public/worlds/" + fileName;
                    return string;
                }
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[WorldManager] Storage upload failed: " + response.code() + " - " + errorBody);
                String string = null;
                return string;
            }
        }
        catch (IOException e) {
            System.err.println("[WorldManager] Storage upload error: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WorldInfo updateDatabaseEntry(String worldId, WorldUploadRequest request, String fileUrl, String screenshotUrl, long compressedSize, long originalSize) {
        try {
            JsonObject updateData = new JsonObject();
            updateData.addProperty("name", request.getWorldName());
            updateData.addProperty("description", request.getDescription());
            updateData.addProperty("file_url", fileUrl);
            updateData.addProperty("file_size", (Number)compressedSize);
            updateData.addProperty("uncompressed_size", (Number)originalSize);
            updateData.addProperty("minecraft_version", request.getMinecraftVersion());
            updateData.addProperty("world_type", request.getWorldType());
            updateData.addProperty("is_public", Boolean.valueOf(request.isPublic()));
            if (screenshotUrl != null) {
                updateData.addProperty("screenshot_url", screenshotUrl);
            }
            JsonArray tagsArray = new JsonArray();
            for (String tag : request.getTags()) {
                tagsArray.add(tag);
            }
            updateData.add("tags", (JsonElement)tagsArray);
            String url = this.config.getSupabaseUrl() + "/rest/v1/worlds?id=eq." + worldId;
            Request dbRequest = new Request.Builder().url(url).patch(RequestBody.create(JSON, GSON.toJson((JsonElement)updateData))).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").addHeader("Prefer", "return=representation").build();
            try (Response response = this.httpClient.newCall(dbRequest).execute();){
                if (response.isSuccessful() && response.body() != null) {
                    String responseBody = response.body().string();
                    JsonArray results = (JsonArray)GSON.fromJson(responseBody, JsonArray.class);
                    if (results.size() <= 0) return null;
                    WorldInfo worldInfo = (WorldInfo)GSON.fromJson(results.get(0), WorldInfo.class);
                    return worldInfo;
                }
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[WorldManager] Database update failed: " + response.code() + " - " + errorBody);
                return null;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Database update error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WorldInfo createDatabaseEntry(WorldUploadRequest request, String fileUrl, String screenshotUrl, long compressedSize, long originalSize) {
        try {
            String userId = this.config.getSupabaseUserId();
            String username = this.getUsernameFromProfile(userId);
            JsonObject worldData = new JsonObject();
            worldData.addProperty("name", request.getWorldName());
            worldData.addProperty("description", request.getDescription());
            worldData.addProperty("author_id", userId);
            worldData.addProperty("author_username", username);
            worldData.addProperty("file_url", fileUrl);
            worldData.addProperty("file_size", (Number)compressedSize);
            worldData.addProperty("uncompressed_size", (Number)originalSize);
            worldData.addProperty("minecraft_version", request.getMinecraftVersion());
            worldData.addProperty("world_type", request.getWorldType());
            worldData.addProperty("is_public", Boolean.valueOf(request.isPublic()));
            if (screenshotUrl != null) {
                worldData.addProperty("screenshot_url", screenshotUrl);
            }
            JsonArray tagsArray = new JsonArray();
            for (String tag : request.getTags()) {
                tagsArray.add(tag);
            }
            worldData.add("tags", (JsonElement)tagsArray);
            String url = this.config.getSupabaseUrl() + "/rest/v1/worlds";
            Request dbRequest = new Request.Builder().url(url).post(RequestBody.create(JSON, GSON.toJson((JsonElement)worldData))).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").addHeader("Prefer", "return=representation").build();
            try (Response response = this.httpClient.newCall(dbRequest).execute();){
                if (response.isSuccessful() && response.body() != null) {
                    String responseBody = response.body().string();
                    JsonArray results = (JsonArray)GSON.fromJson(responseBody, JsonArray.class);
                    if (results.size() <= 0) return null;
                    WorldInfo worldInfo = (WorldInfo)GSON.fromJson(results.get(0), WorldInfo.class);
                    return worldInfo;
                }
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[WorldManager] Database insert failed: " + response.code() + " - " + errorBody);
                return null;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Database entry error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public DownloadResult downloadWorld(String worldId, Path savesDir, CompressionProgressCallback progressCallback) {
        try {
            WorldInfo worldInfo = this.getWorldInfo(worldId);
            if (worldInfo == null) {
                return new DownloadResult(false, "World not found", null);
            }
            System.out.println("[WorldManager] Downloading: " + worldInfo.getName());
            Path tempFile = Files.createTempFile("world_download_", ".tar.xz", new FileAttribute[0]);
            boolean downloadSuccess = this.downloadFile(worldInfo.getFileUrl(), tempFile, progressCallback);
            if (!downloadSuccess) {
                Files.deleteIfExists(tempFile);
                return new DownloadResult(false, "Failed to download world file", null);
            }
            String baseName = this.sanitizeFileName(worldInfo.getName());
            Path worldPath = savesDir.resolve(baseName);
            int counter = 1;
            while (Files.exists(worldPath, new LinkOption[0])) {
                worldPath = savesDir.resolve(baseName + "_" + counter);
                ++counter;
            }
            System.out.println("[WorldManager] Extracting world...");
            WorldCompressorLZMA.DecompressResult decompressResult = WorldCompressorLZMA.decompress(tempFile, worldPath, progressCallback);
            Files.deleteIfExists(tempFile);
            if (!decompressResult.isSuccess()) {
                return new DownloadResult(false, "Failed to extract world: " + decompressResult.getMessage(), null);
            }
            this.incrementDownloadCount(worldId);
            System.out.println("[WorldManager] Download complete: " + String.valueOf(worldPath.getFileName()));
            return new DownloadResult(true, "World downloaded successfully!", worldPath.getFileName().toString());
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Download failed: " + e.getMessage());
            e.printStackTrace();
            return new DownloadResult(false, "Download failed: " + e.getMessage(), null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadFile(String fileUrl, Path outputPath, CompressionProgressCallback callback) {
        try {
            Request request = new Request.Builder().url(fileUrl).get().build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    System.err.println("[WorldManager] Download failed: " + response.code());
                    boolean bl = false;
                    return bl;
                }
                ResponseBody body = response.body();
                if (body == null) {
                    boolean bl = false;
                    return bl;
                }
                long totalBytes = body.contentLength();
                long downloadedBytes = 0L;
                try (InputStream input = body.byteStream();
                     FileOutputStream output = new FileOutputStream(outputPath.toFile());){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = input.read(buffer)) != -1) {
                        output.write(buffer, 0, bytesRead);
                        downloadedBytes += (long)bytesRead;
                        if (callback == null || totalBytes <= 0L) continue;
                        int percentage = (int)(downloadedBytes * 100L / totalBytes);
                        callback.onProgress(percentage, "Downloading...");
                    }
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            System.err.println("[WorldManager] Download error: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorldInfo getWorldInfo(String worldId) {
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/worlds?id=eq." + worldId;
            Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return null;
                if (response.body() == null) return null;
                String responseBody = response.body().string();
                List worlds = (List)GSON.fromJson(responseBody, new TypeToken<List<WorldInfo>>(){}.getType());
                if (worlds.isEmpty()) return null;
                WorldInfo worldInfo = (WorldInfo)worlds.get(0);
                return worldInfo;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to get world info: " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WorldInfo> listPublicWorlds(int limit, int offset) {
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/worlds?is_public=eq.true&deleted_at=is.null&order=created_at.desc&limit=" + limit + "&offset=" + offset;
            Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return Collections.emptyList();
                if (response.body() == null) return Collections.emptyList();
                String responseBody = response.body().string();
                List list = (List)GSON.fromJson(responseBody, new TypeToken<List<WorldInfo>>(){}.getType());
                return list;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to list worlds: " + e.getMessage());
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WorldInfo> searchWorlds(String query) {
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/worlds?is_public=eq.true&deleted_at=is.null&name=ilike.*" + query + "*&order=download_count.desc&limit=50";
            Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return Collections.emptyList();
                if (response.body() == null) return Collections.emptyList();
                String responseBody = response.body().string();
                List list = (List)GSON.fromJson(responseBody, new TypeToken<List<WorldInfo>>(){}.getType());
                return list;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to search worlds: " + e.getMessage());
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WorldInfo> getMyWorlds() {
        try {
            String userId = this.config.getSupabaseUserId();
            if (userId == null) return Collections.emptyList();
            if (userId.isEmpty()) {
                return Collections.emptyList();
            }
            String url = this.config.getSupabaseUrl() + "/rest/v1/worlds?author_id=eq." + userId + "&deleted_at=is.null&order=created_at.desc";
            Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return Collections.emptyList();
                if (response.body() == null) return Collections.emptyList();
                String responseBody = response.body().string();
                List list = (List)GSON.fromJson(responseBody, new TypeToken<List<WorldInfo>>(){}.getType());
                return list;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to get my worlds: " + e.getMessage());
        }
        return Collections.emptyList();
    }

    public boolean deleteWorld(String worldId) {
        JsonObject updateData = new JsonObject();
        updateData.addProperty("deleted_at", Instant.now().toString());
        String url = this.config.getSupabaseUrl() + "/rest/v1/worlds?id=eq." + worldId;
        Request request = new Request.Builder().url(url).patch(RequestBody.create(JSON, GSON.toJson((JsonElement)updateData))).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("[WorldManager] Failed to delete world: " + e.getMessage());
                return false;
            }
        }
    }

    private void incrementDownloadCount(String worldId) {
        try {
            JsonObject params = new JsonObject();
            params.addProperty("world_id", worldId);
            String url = this.config.getSupabaseUrl() + "/rest/v1/rpc/increment_world_downloads";
            Request request = new Request.Builder().url(url).post(RequestBody.create(JSON, GSON.toJson((JsonElement)params))).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            this.httpClient.newCall(request).execute().close();
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to increment download count: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean rateWorld(String worldId, int rating) {
        if (rating < 1 || rating > 5) {
            System.err.println("[WorldManager] Invalid rating: " + rating);
            return false;
        }
        try {
            String userId = this.config.getSupabaseUserId();
            if (userId == null) return false;
            if (userId.isEmpty()) {
                return false;
            }
            JsonObject ratingData = new JsonObject();
            ratingData.addProperty("world_id", worldId);
            ratingData.addProperty("user_id", userId);
            ratingData.addProperty("rating", (Number)rating);
            String url = this.config.getSupabaseUrl() + "/rest/v1/world_ratings";
            Request request = new Request.Builder().url(url).post(RequestBody.create(JSON, GSON.toJson((JsonElement)ratingData))).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").addHeader("Prefer", "resolution=merge-duplicates").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    System.out.println("[WorldManager] Rated world " + worldId + " with " + rating + " stars");
                    boolean bl = true;
                    return bl;
                }
                System.err.println("[WorldManager] Failed to rate world: " + response.code());
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Rating failed: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUserRating(String worldId) {
        try {
            String userId = this.config.getSupabaseUserId();
            if (userId == null) return 0;
            if (userId.isEmpty()) {
                return 0;
            }
            String url = this.config.getSupabaseUrl() + "/rest/v1/world_ratings?world_id=eq." + worldId + "&user_id=eq." + userId;
            Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return 0;
                if (response.body() == null) return 0;
                String responseBody = response.body().string();
                JsonArray ratings = (JsonArray)GSON.fromJson(responseBody, JsonArray.class);
                if (ratings.size() <= 0) return 0;
                JsonObject ratingObj = ratings.get(0).getAsJsonObject();
                int n = ratingObj.get("rating").getAsInt();
                return n;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to get user rating: " + e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUsernameFromProfile(String userId) {
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/user_profiles?id=eq." + userId;
            Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) return "User";
                if (response.body() == null) return "User";
                String responseBody = response.body().string();
                JsonArray profiles = (JsonArray)GSON.fromJson(responseBody, JsonArray.class);
                if (profiles.size() <= 0) return "User";
                JsonObject profile = profiles.get(0).getAsJsonObject();
                if (!profile.has("minecraft_name")) return "User";
                String string = profile.get("minecraft_name").getAsString();
                return string;
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to fetch username: " + e.getMessage());
            e.printStackTrace();
        }
        return "User";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommentResult postComment(String worldId, String commentText) {
        try {
            ContentModerator.ModerationResult modResult = ContentModerator.moderate(commentText);
            if (!modResult.isApproved()) {
                return new CommentResult(false, "Comment rejected: " + modResult.getReason(), null);
            }
            String userId = this.config.getSupabaseUserId();
            String username = this.getUsernameFromProfile(userId);
            JsonObject commentData = new JsonObject();
            commentData.addProperty("world_id", worldId);
            commentData.addProperty("user_id", userId);
            commentData.addProperty("username", username);
            commentData.addProperty("comment", modResult.getSanitizedContent());
            commentData.addProperty("is_moderated", Boolean.valueOf(true));
            commentData.addProperty("moderation_status", "approved");
            if (!modResult.getFlaggedWords().isEmpty()) {
                JsonArray flaggedArray = new JsonArray();
                for (String word : modResult.getFlaggedWords()) {
                    flaggedArray.add(word);
                }
                commentData.add("flagged_words", (JsonElement)flaggedArray);
                commentData.addProperty("moderation_reason", modResult.getReason());
            }
            String url = this.config.getSupabaseUrl() + "/rest/v1/world_comments";
            Request request = new Request.Builder().url(url).post(RequestBody.create(JSON, GSON.toJson((JsonElement)commentData))).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").addHeader("Prefer", "return=representation").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful() && response.body() != null) {
                    String responseBody = response.body().string();
                    JsonArray results = (JsonArray)GSON.fromJson(responseBody, JsonArray.class);
                    if (results.size() <= 0) return new CommentResult(false, "Failed to post comment", null);
                    WorldComment comment = (WorldComment)GSON.fromJson(results.get(0), WorldComment.class);
                    CommentResult commentResult = new CommentResult(true, "Comment posted successfully", comment);
                    return commentResult;
                }
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[WorldManager] Comment post failed: " + response.code() + " - " + errorBody);
                return new CommentResult(false, "Failed to post comment", null);
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to post comment: " + e.getMessage());
            e.printStackTrace();
        }
        return new CommentResult(false, "Failed to post comment", null);
    }

    public List<WorldInfo> getUserWorlds() {
        ArrayList<WorldInfo> worlds = new ArrayList<WorldInfo>();
        try {
            String userId = this.config.getSupabaseUserId();
            String url = this.config.getSupabaseUrl() + "/rest/v1/worlds?author_id=eq." + userId + "&order=created_at.desc";
            Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful() && response.body() != null) {
                    String responseBody = response.body().string();
                    JsonArray results = (JsonArray)GSON.fromJson(responseBody, JsonArray.class);
                    for (int i = 0; i < results.size(); ++i) {
                        WorldInfo world = (WorldInfo)GSON.fromJson(results.get(i), WorldInfo.class);
                        worlds.add(world);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to fetch user worlds: " + e.getMessage());
            e.printStackTrace();
        }
        return worlds;
    }

    public List<WorldComment> getComments(String worldId, int limit) {
        ArrayList<WorldComment> comments = new ArrayList<WorldComment>();
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/world_comments?world_id=eq." + worldId + "&moderation_status=eq.approved&order=created_at.desc&limit=" + limit;
            Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful() && response.body() != null) {
                    String responseBody = response.body().string();
                    JsonArray results = (JsonArray)GSON.fromJson(responseBody, JsonArray.class);
                    for (int i = 0; i < results.size(); ++i) {
                        WorldComment comment = (WorldComment)GSON.fromJson(results.get(i), WorldComment.class);
                        comments.add(comment);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("[WorldManager] Failed to fetch comments: " + e.getMessage());
            e.printStackTrace();
        }
        return comments;
    }

    public boolean deleteComment(String commentId) {
        String url = this.config.getSupabaseUrl() + "/rest/v1/world_comments?id=eq." + commentId;
        Request request = new Request.Builder().url(url).delete().addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("apikey", this.config.getSupabaseAnonKey()).build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("[WorldManager] Failed to delete comment: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    private String sanitizeFileName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_\\-]", "_");
    }

    private void copyDirectory(Path source, Path target) throws IOException {
        Files.walk(source, new FileVisitOption[0]).forEach(sourcePath -> {
            try {
                Path targetPath = target.resolve(source.relativize((Path)sourcePath));
                if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                    if (!Files.exists(targetPath, new LinkOption[0])) {
                        Files.createDirectories(targetPath, new FileAttribute[0]);
                    }
                } else {
                    Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy: " + String.valueOf(sourcePath), e);
            }
        });
    }

    private void deleteDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    System.err.println("Failed to delete: " + String.valueOf(path) + " - " + e.getMessage());
                }
            });
        }
    }

    public static class UploadResult {
        private final boolean success;
        private final String message;
        private final WorldInfo worldInfo;

        public UploadResult(boolean success, String message, WorldInfo worldInfo) {
            this.success = success;
            this.message = message;
            this.worldInfo = worldInfo;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public WorldInfo getWorldInfo() {
            return this.worldInfo;
        }
    }

    public static class DownloadResult {
        private final boolean success;
        private final String message;
        private final String worldFolderName;

        public DownloadResult(boolean success, String message, String worldFolderName) {
            this.success = success;
            this.message = message;
            this.worldFolderName = worldFolderName;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public String getWorldFolderName() {
            return this.worldFolderName;
        }
    }

    public static class CommentResult {
        private final boolean success;
        private final String message;
        private final WorldComment comment;

        public CommentResult(boolean success, String message, WorldComment comment) {
            this.success = success;
            this.message = message;
            this.comment = comment;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public WorldComment getComment() {
            return this.comment;
        }
    }
}

