/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.auth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.awt.Desktop;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;

public class OAuthHelper {
    private static final int CALLBACK_PORT_DEFAULT = 54321;
    private static final String CALLBACK_PATH = "/auth/callback";
    private static final int TIMEOUT_SECONDS = 120;
    private HttpServer callbackServer;
    private CompletableFuture<OAuthResult> resultFuture;
    private int callbackPort;
    private String authState;
    private String codeVerifier;

    public CompletableFuture<OAuthResult> startMicrosoftOAuth() {
        return this.startOAuthFlow("azure");
    }

    public CompletableFuture<OAuthResult> startOAuthFlow(String provider) {
        this.resultFuture = new CompletableFuture();
        try {
            String normalizedProvider;
            String string = normalizedProvider = provider == null ? "" : provider.trim().toLowerCase();
            if (!(normalizedProvider.equals("azure") || normalizedProvider.equals("google") || normalizedProvider.equals("github"))) {
                this.resultFuture.complete(new OAuthResult(false, null, null, "Unsupported OAuth provider"));
                return this.resultFuture;
            }
            this.startCallbackServer();
            String redirectUri = "http://127.0.0.1:" + this.callbackPort + CALLBACK_PATH;
            String supabaseUrl = TunnelConfig.getInstance().getSupabaseUrl();
            String scopes = "openid profile email";
            this.authState = OAuthHelper.generateState();
            this.codeVerifier = OAuthHelper.generateCodeVerifier();
            String codeChallenge = OAuthHelper.generateCodeChallenge(this.codeVerifier);
            String oauthUrl = supabaseUrl + "/auth/v1/authorize?provider=" + normalizedProvider + "&redirect_to=" + URLEncoder.encode(redirectUri, StandardCharsets.UTF_8.toString()) + "&scopes=" + URLEncoder.encode(scopes, StandardCharsets.UTF_8.toString()) + "&code_challenge=" + URLEncoder.encode(codeChallenge, StandardCharsets.UTF_8.toString()) + "&code_challenge_method=s256";
            System.out.println("[Tunnely OAuth] Opening browser for " + provider + " login...");
            this.openBrowser(oauthUrl);
            this.resultFuture.orTimeout(120L, TimeUnit.SECONDS).exceptionally(ex -> {
                this.stopCallbackServer();
                return new OAuthResult(false, null, null, "OAuth timeout - please try again");
            });
        }
        catch (Exception e) {
            System.err.println("[Tunnely OAuth] Failed to start OAuth flow: " + e.getMessage());
            e.printStackTrace();
            this.resultFuture.complete(new OAuthResult(false, null, null, "Failed to start OAuth: " + e.getMessage()));
            this.stopCallbackServer();
        }
        return this.resultFuture;
    }

    private void startCallbackServer() throws IOException {
        InetSocketAddress fixed = new InetSocketAddress(InetAddress.getLoopbackAddress(), 54321);
        this.callbackServer = HttpServer.create(fixed, 0);
        this.callbackPort = 54321;
        this.callbackServer.createContext(CALLBACK_PATH, exchange -> {
            try {
                this.handleCallback(exchange);
            }
            catch (Exception e) {
                System.err.println("[Tunnely OAuth] Error handling callback: " + e.getMessage());
                e.printStackTrace();
                this.sendErrorResponse(exchange, "Internal error processing OAuth callback");
            }
        });
        this.callbackServer.setExecutor(null);
        this.callbackServer.start();
        System.out.println("[Tunnely OAuth] Callback server started on 127.0.0.1:" + this.callbackPort);
    }

    private void handleCallback(HttpExchange exchange) throws IOException {
        if (exchange.getRemoteAddress() == null || exchange.getRemoteAddress().getAddress() == null || !exchange.getRemoteAddress().getAddress().isLoopbackAddress()) {
            this.sendErrorResponse(exchange, "Invalid request origin");
            return;
        }
        String method = exchange.getRequestMethod();
        if ("GET".equalsIgnoreCase(method)) {
            String query = exchange.getRequestURI().getQuery();
            Map<String, String> params = this.parseQueryParams(query);
            if (params.containsKey("error")) {
                String error = params.get("error");
                String errorDescription = params.getOrDefault("error_description", "OAuth failed");
                System.err.println("[Tunnely OAuth] OAuth error: " + error + " - " + errorDescription);
                this.sendErrorResponse(exchange, "Authentication failed: " + errorDescription);
                this.resultFuture.complete(new OAuthResult(false, null, null, errorDescription));
                this.stopCallbackServer();
                return;
            }
            if (params.containsKey("code")) {
                String authCode = params.get("code");
                System.out.println("[Tunnely OAuth] Received authorization code");
                this.sendSuccessResponse(exchange);
                String redirectUri = "http://127.0.0.1:" + this.callbackPort + CALLBACK_PATH;
                this.resultFuture.complete(new OAuthResult(true, authCode, null, null, true, redirectUri, this.codeVerifier));
                this.stopCallbackServer();
                return;
            }
            this.sendHashExtractorPage(exchange);
            return;
        }
        if ("POST".equalsIgnoreCase(method)) {
            byte[] raw = exchange.getRequestBody().readAllBytes();
            if (raw.length > 4096) {
                this.sendErrorResponse(exchange, "Request too large");
                this.stopCallbackServer();
                return;
            }
            String body = new String(raw, StandardCharsets.UTF_8);
            Map<String, String> form = this.parseQueryParams(body);
            String state = form.get("state");
            if (state == null || !state.equals(this.authState)) {
                this.sendErrorResponse(exchange, "Invalid OAuth state");
                this.resultFuture.complete(new OAuthResult(false, null, null, "Invalid OAuth state"));
                this.stopCallbackServer();
                return;
            }
            if (form.containsKey("access_token")) {
                String accessToken = form.get("access_token");
                String refreshToken = form.getOrDefault("refresh_token", null);
                System.out.println("[Tunnely OAuth] Received access token via POST from browser");
                this.sendSuccessResponse(exchange);
                this.resultFuture.complete(new OAuthResult(true, accessToken, refreshToken, null));
                this.stopCallbackServer();
                return;
            }
            this.sendErrorResponse(exchange, "Invalid request");
            return;
        }
        exchange.getResponseHeaders().set("Allow", "GET, POST");
        exchange.sendResponseHeaders(405, -1L);
    }

    private void sendHashExtractorPage(HttpExchange exchange) throws IOException {
        String html = "<!DOCTYPE html>\n<html>\n<head>\n    <title>Tunnely - Authenticating...</title>\n    <style>\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            height: 100vh;\n            margin: 0;\n            color: white;\n        }\n        .container {\n            text-align: center;\n            background: rgba(255, 255, 255, 0.1);\n            padding: 40px;\n            border-radius: 20px;\n            backdrop-filter: blur(10px);\n        }\n        .spinner {\n            border: 4px solid rgba(255, 255, 255, 0.3);\n            border-top: 4px solid white;\n            border-radius: 50%;\n            width: 50px;\n            height: 50px;\n            animation: spin 1s linear infinite;\n            margin: 20px auto;\n        }\n        @keyframes spin {\n            0% { transform: rotate(0deg); }\n            100% { transform: rotate(360deg); }\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <h1>\ud83c\udfae Tunnely</h1>\n        <div class=\"spinner\"></div>\n        <p>Completing authentication...</p>\n        <p id=\"status\">Please wait...</p>\n    </div>\n    <script>\n        const expectedState = '__STATE__';\n        // Extract tokens from URL hash\n        const hash = window.location.hash.substring(1);\n        const params = new URLSearchParams(hash);\n        const accessToken = params.get('access_token');\n        const refreshToken = params.get('refresh_token');\n        const error = params.get('error');\n\n        if (error) {\n            document.getElementById('status').textContent = 'Authentication failed: ' + error;\n            fetch('/auth/callback?error=' + encodeURIComponent(error));\n            setTimeout(() => window.close(), 3000);\n        } else if (accessToken) {\n            document.getElementById('status').textContent = 'Success! You can close this window.';\n            // Send tokens to callback server via POST with state\n            const body = new URLSearchParams();\n            body.set('state', expectedState);\n            body.set('access_token', accessToken);\n            if (refreshToken) body.set('refresh_token', refreshToken);\n            fetch('/auth/callback', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: body.toString() })\n              .then(() => { setTimeout(() => window.close(), 2000); })\n              .catch(() => { setTimeout(() => window.close(), 2000); });\n        } else {\n            document.getElementById('status').textContent = 'Waiting for authentication...';\n        }\n    </script>\n</body>\n</html>\n";
        html = html.replace("__STATE__", this.authState == null ? "" : this.authState);
        byte[] response = html.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.getResponseHeaders().set("Cache-Control", "no-store");
        exchange.getResponseHeaders().set("Content-Security-Policy", "default-src 'none'; connect-src 'self'; style-src 'unsafe-inline'; script-src 'unsafe-inline'; img-src 'self'; base-uri 'none'; frame-ancestors 'none'");
        exchange.sendResponseHeaders(200, response.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response);
        }
    }

    private void sendSuccessResponse(HttpExchange exchange) throws IOException {
        String html = "<!DOCTYPE html>\n<html>\n<head>\n    <title>Tunnely - Success</title>\n    <style>\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            height: 100vh;\n            margin: 0;\n            color: white;\n        }\n        .container {\n            text-align: center;\n            background: rgba(255, 255, 255, 0.1);\n            padding: 40px;\n            border-radius: 20px;\n            backdrop-filter: blur(10px);\n        }\n        .checkmark {\n            font-size: 64px;\n            margin-bottom: 20px;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <div class=\"checkmark\">\u2705</div>\n        <h1>Authentication Successful!</h1>\n        <p>You can close this window and return to Minecraft.</p>\n    </div>\n    <script>setTimeout(() => window.close(), 3000);</script>\n</body>\n</html>\n";
        byte[] response = html.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.getResponseHeaders().set("Cache-Control", "no-store");
        exchange.sendResponseHeaders(200, response.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response);
        }
    }

    private void sendErrorResponse(HttpExchange exchange, String errorMessage) throws IOException {
        String html = "<!DOCTYPE html>\n<html>\n<head>\n    <title>Tunnely - Error</title>\n    <style>\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            height: 100vh;\n            margin: 0;\n            color: white;\n        }\n        .container {\n            text-align: center;\n            background: rgba(255, 255, 255, 0.1);\n            padding: 40px;\n            border-radius: 20px;\n            backdrop-filter: blur(10px);\n        }\n        .error-icon {\n            font-size: 64px;\n            margin-bottom: 20px;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <div class=\"error-icon\">\u274c</div>\n        <h1>Authentication Failed</h1>\n        <p>" + errorMessage + "</p>\n        <p>Please close this window and try again.</p>\n    </div>\n</body>\n</html>\n";
        byte[] response = html.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.getResponseHeaders().set("Cache-Control", "no-store");
        exchange.sendResponseHeaders(400, response.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response);
        }
    }

    private Map<String, String> parseQueryParams(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return params;
        }
        for (String param : query.split("&")) {
            String[] pair = param.split("=", 2);
            if (pair.length != 2) continue;
            try {
                String key = URLDecoder.decode(pair[0], StandardCharsets.UTF_8.toString());
                String value = URLDecoder.decode(pair[1], StandardCharsets.UTF_8.toString());
                params.put(key, value);
            }
            catch (Exception e) {
                System.err.println("[Tunnely OAuth] Error decoding param: " + param);
            }
        }
        return params;
    }

    private void openBrowser(String url) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                String os = System.getProperty("os.name").toLowerCase();
                Runtime runtime = Runtime.getRuntime();
                if (os.contains("win")) {
                    runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else if (os.contains("mac")) {
                    runtime.exec("open " + url);
                } else if (os.contains("nix") || os.contains("nux")) {
                    runtime.exec("xdg-open " + url);
                } else {
                    System.err.println("[Tunnely OAuth] Unable to open browser on this OS. Please manually visit: " + url);
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely OAuth] Failed to open browser: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void stopCallbackServer() {
        if (this.callbackServer != null) {
            this.callbackServer.stop(0);
            this.callbackServer = null;
            System.out.println("[Tunnely OAuth] Callback server stopped");
        }
    }

    private static String generateState() {
        byte[] bytes = new byte[16];
        new SecureRandom().nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    private static String generateCodeVerifier() {
        byte[] bytes = new byte[32];
        new SecureRandom().nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    private static String generateCodeChallenge(String verifier) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(verifier.getBytes(StandardCharsets.US_ASCII));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
        }
        catch (Exception e) {
            return verifier;
        }
    }

    public static class OAuthResult {
        public final boolean success;
        public final String token;
        public final String refreshToken;
        public final String error;
        public final boolean isAuthCode;
        public final String redirectUri;
        public final String codeVerifier;

        public OAuthResult(boolean success, String token, String refreshToken, String error) {
            this(success, token, refreshToken, error, false, null, null);
        }

        public OAuthResult(boolean success, String token, String refreshToken, String error, boolean isAuthCode) {
            this(success, token, refreshToken, error, isAuthCode, null, null);
        }

        public OAuthResult(boolean success, String token, String refreshToken, String error, boolean isAuthCode, String redirectUri, String codeVerifier) {
            this.success = success;
            this.token = token;
            this.refreshToken = refreshToken;
            this.error = error;
            this.isAuthCode = isAuthCode;
            this.redirectUri = redirectUri;
            this.codeVerifier = codeVerifier;
        }
    }
}

