/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.EncryptionKeyManager;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;

public class SettingsScreen
extends class_437 {
    private final class_437 parent;
    private final TunnelConfig config;
    private class_4286 enableTunnelingCheckbox;
    private class_4286 debugModeCheckbox;
    private class_4286 messageNotificationsCheckbox;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private String currentUsername = "";

    public SettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Settings"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.field_22789 / 2 - buttonWidth / 2;
        int startY = this.field_22790 / 2 - 100;
        this.loadCurrentUsername();
        this.enableTunnelingCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Enable Tunneling"), (class_327)this.field_22793).method_54789(centerX, startY).method_54794(this.config.isEnableTunneling()).method_54788();
        this.method_37063((class_364)this.enableTunnelingCheckbox);
        this.debugModeCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Debug Mode"), (class_327)this.field_22793).method_54789(centerX, startY + 30).method_54794(this.config.isDebugMode()).method_54788();
        this.method_37063((class_364)this.debugModeCheckbox);
        this.messageNotificationsCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Message Notifications"), (class_327)this.field_22793).method_54789(centerX, startY + 60).method_54794(this.config.isMessageNotificationsEnabled()).method_54788();
        this.method_37063((class_364)this.messageNotificationsCheckbox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Change Username"), button -> this.field_22787.method_1507((class_437)new UsernameSelectionScreen(this, false))).method_46434(centerX, startY + 90, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Logout"), button -> this.logout()).method_46434(centerX, startY + 120, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7cDelete Account"), button -> this.openDeleteAccountPage()).method_46434(centerX, startY + 150, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save Settings"), button -> this.saveSettings()).method_46434(centerX, startY + 180, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX, this.field_22790 - 30, buttonWidth, buttonHeight).method_46431());
    }

    private void loadCurrentUsername() {
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                JsonObject profile = client.getOwnProfile();
                this.currentUsername = profile != null && profile.has("minecraft_name") ? profile.get("minecraft_name").getAsString() : "Not set";
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error loading username: " + e.getMessage());
                this.currentUsername = "Error loading";
            }
        }, "Tunnely-LoadUsername").start();
    }

    private void saveSettings() {
        this.config.setEnableTunneling(this.enableTunnelingCheckbox.method_20372());
        this.config.setDebugMode(this.debugModeCheckbox.method_20372());
        this.config.setMessageNotificationsEnabled(this.messageNotificationsCheckbox.method_20372());
        this.config.save();
        this.statusMessage = "\u00a7aSettings saved!";
        this.statusColor = 65280;
    }

    private void openDeleteAccountPage() {
        try {
            class_156.method_668().method_670("https://tunnely.org");
            this.statusMessage = "\u00a7eOpened account deletion page in browser";
            this.statusColor = 0xFFFF00;
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error opening browser: " + e.getMessage());
            this.statusMessage = "\u00a7cFailed to open browser";
            this.statusColor = 0xFF0000;
        }
    }

    private void logout() {
        PresenceManager.getInstance().stop();
        MessageManager.getInstance().stop();
        EncryptionKeyManager.reset();
        this.config.setUserJwtToken("");
        this.config.save();
        this.statusMessage = "\u00a7aLogged out successfully";
        this.statusColor = 65280;
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new TunnelyMainScreen(this.parent)));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25300(this.field_22793, "\u00a76\u00a7lSettings", this.field_22789 / 2, 30, ColorUtil.opaque(0xFFFFFF));
        if (!this.currentUsername.isEmpty()) {
            graphics.method_25300(this.field_22793, "\u00a77Current Username: \u00a7f" + this.currentUsername, this.field_22789 / 2, 50, ColorUtil.opaque(0xFFFFFF));
        }
        int infoY = 150;
        graphics.method_25300(this.field_22793, "\u00a77Configuration File:", this.field_22789 / 2, this.field_22790 / 2 + infoY, ColorUtil.opaque(0xAAAAAA));
        graphics.method_25300(this.field_22793, "\u00a7econfig/tunnelyrefab.json", this.field_22789 / 2, this.field_22790 / 2 + infoY + 15, ColorUtil.opaque(0xFFFFFF));
        if (!this.statusMessage.isEmpty()) {
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 - 50, ColorUtil.opaque(this.statusColor));
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

