/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;

public class TermsOfServiceScreen
extends class_437 {
    private final class_437 parent;
    private final Runnable onAccept;
    private TosContentWidget contentWidget;
    private class_4286 acceptCheckbox;
    private class_4185 acceptButton;
    private class_4185 declineButton;
    private class_4185 exportButton;
    private String tosVersion = "";
    private String tosTitle = "";
    private String acceptanceText = "";
    private String footer = "";
    private List<TosSection> sections = new ArrayList<TosSection>();

    public TermsOfServiceScreen(class_437 parent, Runnable onAccept) {
        super((class_2561)class_2561.method_43470((String)"Terms of Service"));
        this.parent = parent;
        this.onAccept = onAccept;
        this.loadTosFromJson();
    }

    private void loadTosFromJson() {
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/terms-of-service.json");
            if (stream == null) {
                System.err.println("[Tunnely] Could not load terms-of-service.json");
                this.tosTitle = "Terms of Service";
                this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
                return;
            }
            InputStreamReader reader = new InputStreamReader(stream);
            JsonObject json = JsonParser.parseReader(reader).getAsJsonObject();
            this.tosVersion = json.has("version") ? json.get("version").getAsString() : "1.0.0";
            this.tosTitle = json.has("title") ? json.get("title").getAsString() : "Terms of Service";
            this.acceptanceText = json.has("acceptance_text") ? json.get("acceptance_text").getAsString() : "I accept the Terms of Service";
            String string = this.footer = json.has("footer") ? json.get("footer").getAsString() : "";
            if (json.has("sections")) {
                JsonArray sectionsArray = json.getAsJsonArray("sections");
                for (int i = 0; i < sectionsArray.size(); ++i) {
                    JsonObject section = sectionsArray.get(i).getAsJsonObject();
                    String title = section.has("title") ? section.get("title").getAsString() : "";
                    String content = section.has("content") ? section.get("content").getAsString() : "";
                    this.sections.add(new TosSection(title, content));
                }
            }
            System.out.println("[Tunnely] Loaded TOS version " + this.tosVersion + " with " + this.sections.size() + " sections");
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading TOS: " + e.getMessage());
            e.printStackTrace();
            this.tosTitle = "Terms of Service";
            this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
        }
    }

    protected void method_25426() {
        super.method_25426();
        int footerHeight = 0;
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.field_22789 - 40);
            footerHeight = footerLines.size() * 11 + 10;
        }
        int buttonY = this.field_22790 - 30;
        int checkboxY = buttonY - 35;
        int topMargin = 55;
        int bottomMargin = checkboxY - 10;
        this.contentWidget = new TosContentWidget(this.field_22787, this.field_22789, this.field_22790, topMargin, bottomMargin, 10);
        this.contentWidget.setSections(this.sections);
        this.method_25429((class_364)this.contentWidget);
        this.acceptCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)this.acceptanceText), (class_327)this.field_22793).method_54789(this.field_22789 / 2 - 100, checkboxY).method_54794(false).method_54788();
        this.method_37063((class_364)this.acceptCheckbox);
        this.acceptButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7aI Agree"), button -> this.acceptTos()).method_46434(this.field_22789 / 2 - 155, buttonY, 100, 20).method_46431();
        this.acceptButton.field_22763 = false;
        this.method_37063((class_364)this.acceptButton);
        this.declineButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7cDecline"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - 50, buttonY, 100, 20).method_46431();
        this.method_37063((class_364)this.declineButton);
        this.exportButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7e\ud83d\udcc4 Export"), button -> this.exportTos()).method_46434(this.field_22789 / 2 + 55, buttonY, 100, 20).method_46431();
        this.method_37063((class_364)this.exportButton);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
            if (this.field_22793.method_1727(testLine) > maxWidth) {
                if (line.length() > 0) {
                    lines.add(line.toString());
                    line = new StringBuilder(word);
                    continue;
                }
                lines.add(word);
                continue;
            }
            line.append(line.length() > 0 ? " " : "").append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public void method_25393() {
        super.method_25393();
        this.acceptButton.field_22763 = this.acceptCheckbox.method_20372();
    }

    private void acceptTos() {
        System.out.println("[Tunnely] TOS accepted - version " + this.tosVersion);
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAcceptedTosVersion(this.tosVersion);
        if (this.onAccept != null) {
            this.onAccept.run();
        }
    }

    private void exportTos() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String filename = String.format("Tunnely_TOS_%s_%s.txt", this.tosVersion.replace(".", "_"), dateFormat.format(new Date()));
            File exportFile = new File(filename);
            try (PrintWriter writer = new PrintWriter(new FileWriter(exportFile));){
                writer.println("=".repeat(80));
                writer.println(this.tosTitle);
                writer.println("Version: " + this.tosVersion);
                writer.println("Exported: " + String.valueOf(new Date()));
                writer.println("=".repeat(80));
                writer.println();
                for (TosSection section : this.sections) {
                    writer.println("-".repeat(80));
                    writer.println(section.title);
                    writer.println("-".repeat(80));
                    writer.println();
                    writer.println(section.content);
                    writer.println();
                }
                if (!this.footer.isEmpty()) {
                    writer.println("=".repeat(80));
                    writer.println("ACCEPTANCE NOTICE");
                    writer.println("=".repeat(80));
                    writer.println();
                    writer.println(this.footer);
                    writer.println();
                }
                writer.println("=".repeat(80));
                writer.println("End of Terms of Service");
                writer.println("=".repeat(80));
            }
            System.out.println("[Tunnely] \u2713 TOS exported to: " + exportFile.getAbsolutePath());
            this.field_22787.execute(() -> System.out.println("[Tunnely] TOS saved to game directory: " + filename));
        }
        catch (IOException e) {
            System.err.println("[Tunnely] \u2717 Failed to export TOS: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_25300(this.field_22793, "\u00a76\u00a7l" + this.tosTitle, this.field_22789 / 2, 15, ColorUtil.opaque(0xFFFFFF));
        graphics.method_25300(this.field_22793, "\u00a77Version " + this.tosVersion, this.field_22789 / 2, 30, ColorUtil.opaque(0xAAAAAA));
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.field_22789 - 40);
            int startY = this.field_22790 - 75 - footerLines.size() * 11;
            for (int i = 0; i < footerLines.size(); ++i) {
                graphics.method_25300(this.field_22793, "\u00a77\u00a7o" + footerLines.get(i), this.field_22789 / 2, startY + i * 11, ColorUtil.opaque(0xAAAAAA));
            }
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private static class TosSection {
        final String title;
        final String content;

        TosSection(String title, String content) {
            this.title = title;
            this.content = content;
        }
    }

    private class TosContentWidget
    extends class_4280<SectionEntry> {
        public TosContentWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom);
        }

        public void setSections(List<TosSection> sections) {
            this.method_25339();
            for (TosSection section : sections) {
                this.method_25321((class_350.class_351)new SectionEntry(section));
            }
        }

        public int method_25322() {
            return Math.min(600, this.field_22758 - 50);
        }

        public int method_25342() {
            return this.field_22758 / 2 - this.method_25322() / 2;
        }

        protected int getScrollbarPosition() {
            return this.field_22758 / 2 + this.method_25322() / 2 + 10;
        }

        class SectionEntry
        extends class_4280.class_4281<SectionEntry> {
            private final TosSection section;
            private final List<String> wrappedContent;

            public SectionEntry(TosSection section) {
                this.section = section;
                this.wrappedContent = this.wrapContentText(section.content, TosContentWidget.this.method_25322() - 30);
            }

            private List<String> wrapContentText(String text, int maxWidth) {
                String[] paragraphs;
                ArrayList<String> lines = new ArrayList<String>();
                for (String paragraph : paragraphs = text.split("\\n")) {
                    if (paragraph.trim().isEmpty()) {
                        lines.add("");
                        continue;
                    }
                    String[] words = paragraph.split(" ");
                    StringBuilder line = new StringBuilder();
                    for (String word : words) {
                        String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
                        if (TermsOfServiceScreen.this.field_22793.method_1727(testLine) > maxWidth) {
                            if (line.length() > 0) {
                                lines.add(line.toString());
                                line = new StringBuilder(word);
                                continue;
                            }
                            lines.add(word);
                            continue;
                        }
                        line.append(line.length() > 0 ? " " : "").append(word);
                    }
                    if (line.length() <= 0) continue;
                    lines.add(line.toString());
                }
                return lines;
            }

            public void method_25343(class_332 graphics, int index, int top, boolean isMouseOver, float partialTick) {
                int left = TosContentWidget.this.method_25342();
                graphics.method_25303(TermsOfServiceScreen.this.field_22793, "\u00a76\u00a7l" + this.section.title, left + 10, top + 8, 0xFFFFFF);
                int yOffset = top + 22;
                for (String line : this.wrappedContent) {
                    if (!line.isEmpty()) {
                        graphics.method_25303(TermsOfServiceScreen.this.field_22793, "\u00a77" + line, left + 20, yOffset, 0xFFFFFF);
                    }
                    yOffset += 11;
                }
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.section.title);
            }
        }
    }
}

