/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.EncryptionKeyManager;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;

public class SettingsScreen
extends Screen {
    private final Screen parent;
    private final TunnelConfig config;
    private Checkbox enableTunnelingCheckbox;
    private Checkbox debugModeCheckbox;
    private Checkbox messageNotificationsCheckbox;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private String currentUsername = "";

    public SettingsScreen(Screen parent) {
        super((Component)Component.literal((String)"Settings"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
    }

    protected void init() {
        super.init();
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.width / 2 - buttonWidth / 2;
        int startY = this.height / 2 - 100;
        this.loadCurrentUsername();
        this.enableTunnelingCheckbox = Checkbox.builder((Component)Component.literal((String)"Enable Tunneling"), (Font)this.font).pos(centerX, startY).selected(this.config.isEnableTunneling()).build();
        this.addRenderableWidget((GuiEventListener)this.enableTunnelingCheckbox);
        this.debugModeCheckbox = Checkbox.builder((Component)Component.literal((String)"Debug Mode"), (Font)this.font).pos(centerX, startY + 30).selected(this.config.isDebugMode()).build();
        this.addRenderableWidget((GuiEventListener)this.debugModeCheckbox);
        this.messageNotificationsCheckbox = Checkbox.builder((Component)Component.literal((String)"Message Notifications"), (Font)this.font).pos(centerX, startY + 60).selected(this.config.isMessageNotificationsEnabled()).build();
        this.addRenderableWidget((GuiEventListener)this.messageNotificationsCheckbox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Change Username"), button -> this.minecraft.setScreen((Screen)new UsernameSelectionScreen(this, false))).bounds(centerX, startY + 90, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Logout"), button -> this.logout()).bounds(centerX, startY + 120, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u00a7cDelete Account"), button -> this.openDeleteAccountPage()).bounds(centerX, startY + 150, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save Settings"), button -> this.saveSettings()).bounds(centerX, startY + 180, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX, this.height - 30, buttonWidth, buttonHeight).build());
    }

    private void loadCurrentUsername() {
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                JsonObject profile = client.getOwnProfile();
                this.currentUsername = profile != null && profile.has("minecraft_name") ? profile.get("minecraft_name").getAsString() : "Not set";
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error loading username: " + e.getMessage());
                this.currentUsername = "Error loading";
            }
        }, "Tunnely-LoadUsername").start();
    }

    private void saveSettings() {
        this.config.setEnableTunneling(this.enableTunnelingCheckbox.selected());
        this.config.setDebugMode(this.debugModeCheckbox.selected());
        this.config.setMessageNotificationsEnabled(this.messageNotificationsCheckbox.selected());
        this.config.save();
        this.statusMessage = "\u00a7aSettings saved!";
        this.statusColor = 65280;
    }

    private void openDeleteAccountPage() {
        try {
            Util.getPlatform().openUri("https://tunnely.org");
            this.statusMessage = "\u00a7eOpened account deletion page in browser";
            this.statusColor = 0xFFFF00;
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error opening browser: " + e.getMessage());
            this.statusMessage = "\u00a7cFailed to open browser";
            this.statusColor = 0xFF0000;
        }
    }

    private void logout() {
        PresenceManager.getInstance().stop();
        MessageManager.getInstance().stop();
        EncryptionKeyManager.reset();
        this.config.setUserJwtToken("");
        this.config.save();
        this.statusMessage = "\u00a7aLogged out successfully";
        this.statusColor = 65280;
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new TunnelyMainScreen(this.parent)));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, "\u00a76\u00a7lSettings", this.width / 2, 30, 0xFFFFFF);
        if (!this.currentUsername.isEmpty()) {
            graphics.drawCenteredString(this.font, "\u00a77Current Username: \u00a7f" + this.currentUsername, this.width / 2, 50, 0xFFFFFF);
        }
        int infoY = 150;
        graphics.drawCenteredString(this.font, "\u00a77Configuration File:", this.width / 2, this.height / 2 + infoY, 0xAAAAAA);
        graphics.drawCenteredString(this.font, "\u00a7econfig/tunnelyrefab.json", this.width / 2, this.height / 2 + infoY + 15, 0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, this.height - 50, this.statusColor);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

