/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;

public class TunnelCommand {
    private static final SuggestionProvider<CommandSourceStack> EMAIL_SUGGESTIONS = (context, builder) -> {
        builder.suggest("\"your-email@example.com\"", (Message)Component.literal((String)"Quote email due to @ symbol"));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> PASSWORD_SUGGESTIONS = (context, builder) -> {
        builder.suggest("\"your-password\"", (Message)Component.literal((String)"Your account password"));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> VISIBILITY_SUGGESTIONS = (context, builder) -> {
        builder.suggest("public", (Message)Component.literal((String)"\ud83c\udf10 Anyone can join - listed in public browser"));
        builder.suggest("friends", (Message)Component.literal((String)"\ud83d\udc65 Only friends can join"));
        builder.suggest("invite", (Message)Component.literal((String)"\ud83d\udd12 Most secure - invite only (default)"));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> SERVER_NAME_SUGGESTIONS = (context, builder) -> {
        TunnelConfig config = TunnelConfig.getInstance();
        builder.suggest("\"" + config.getSavedServerName() + "\"", (Message)Component.literal((String)"Current saved server name"));
        builder.suggest("\"My Awesome Server\"", (Message)Component.literal((String)"Example: custom server name"));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tunnel").then(Commands.literal((String)"status").executes(TunnelCommand::status))).then(Commands.literal((String)"menu").executes(TunnelCommand::openMenu))).then(Commands.literal((String)"login").then(Commands.argument((String)"email", (ArgumentType)StringArgumentType.string()).suggests(EMAIL_SUGGESTIONS).then(Commands.argument((String)"password", (ArgumentType)StringArgumentType.string()).suggests(PASSWORD_SUGGESTIONS).executes(TunnelCommand::login))))).then(Commands.literal((String)"register").then(Commands.argument((String)"email", (ArgumentType)StringArgumentType.string()).suggests(EMAIL_SUGGESTIONS).then(Commands.argument((String)"password", (ArgumentType)StringArgumentType.string()).suggests(PASSWORD_SUGGESTIONS).executes(TunnelCommand::register))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"start").requires(source -> source.hasPermission(2))).executes(TunnelCommand::start)).then(((RequiredArgumentBuilder)Commands.argument((String)"visibility", (ArgumentType)StringArgumentType.word()).suggests(VISIBILITY_SUGGESTIONS).executes(TunnelCommand::startWithVisibility)).then(Commands.argument((String)"serverName", (ArgumentType)StringArgumentType.greedyString()).suggests(SERVER_NAME_SUGGESTIONS).executes(TunnelCommand::startWithVisibilityAndName))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"autostart").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"on").executes(TunnelCommand::autostartOn))).then(Commands.literal((String)"off").executes(TunnelCommand::autostartOff))).executes(TunnelCommand::autostartStatus))).then(((LiteralArgumentBuilder)Commands.literal((String)"stop").requires(source -> source.hasPermission(2))).executes(TunnelCommand::stop))).then(Commands.literal((String)"endpoint").executes(TunnelCommand::endpoint))).then(Commands.literal((String)"help").executes(TunnelCommand::help)));
    }

    private static int status(CommandContext<CommandSourceStack> context) {
        TunnelManager.TunnelStatus status = TunnelManager.getInstance().getStatus();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a76=== Tunnely Status ==="), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7eAuthenticated: " + (status.authenticated ? "\u00a7aYes" : "\u00a7cNo"))), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7eTunnel Connected: " + (status.connected ? "\u00a7aYes" : "\u00a7cNo"))), false);
        if (status.publicEndpoint != null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7ePublic Endpoint: \u00a7b" + status.publicEndpoint)), false);
        }
        if (status.sessionId != null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7eSession ID: \u00a77" + status.sessionId)), false);
        }
        return 1;
    }

    private static int openMenu(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).getEntity() != null && ((CommandSourceStack)context.getSource()).getLevel().isClientSide()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Press \u00a7bU \u00a7eor use this command to open the menu"), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] This command must be used from the client. Press \u00a7bU \u00a7eto open the menu."), false);
        }
        return 1;
    }

    private static int login(CommandContext<CommandSourceStack> context) {
        String email = StringArgumentType.getString(context, (String)"email");
        String password = StringArgumentType.getString(context, (String)"password");
        boolean isDedicatedServer = !((CommandSourceStack)context.getSource()).getServer().isSingleplayer();
        boolean hasOp = ((CommandSourceStack)context.getSource()).hasPermission(2);
        if (isDedicatedServer && !hasOp) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] Commands on multiplayer servers modify the SERVER's config, not yours!"));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7e[Tunnely] To login to YOUR account, press \u00a7bU \u00a7eto open the Tunnely menu instead."));
            return 0;
        }
        if (isDedicatedServer && hasOp) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Logging in to the SERVER's account..."), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Logging in..."), false);
        }
        new Thread(() -> {
            SupabaseClient.AuthResult result = TunnelManager.getInstance().login(email, password);
            if (result.success) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a[Tunnely] Login successful! User ID: " + result.userId)), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("\u00a7c[Tunnely] Login failed: " + result.error)));
            }
        }, "Tunnely-Login").start();
        return 1;
    }

    private static int register(CommandContext<CommandSourceStack> context) {
        String email = StringArgumentType.getString(context, (String)"email");
        String password = StringArgumentType.getString(context, (String)"password");
        String minecraftUuid = "";
        if (((CommandSourceStack)context.getSource()).getEntity() != null) {
            minecraftUuid = ((CommandSourceStack)context.getSource()).getEntity().getStringUUID();
        }
        boolean isDedicatedServer = !((CommandSourceStack)context.getSource()).getServer().isSingleplayer();
        boolean hasOp = ((CommandSourceStack)context.getSource()).hasPermission(2);
        if (isDedicatedServer && !hasOp) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] Commands on multiplayer servers modify the SERVER's config, not yours!"));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7e[Tunnely] To register YOUR account, press \u00a7bU \u00a7eto open the Tunnely menu instead."));
            return 0;
        }
        if (isDedicatedServer && hasOp) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Registering the SERVER's account..."), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Registering account..."), false);
        }
        String finalUuid = minecraftUuid;
        new Thread(() -> {
            SupabaseClient.AuthResult result = TunnelManager.getInstance().register(email, password, finalUuid);
            if (result.success) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a[Tunnely] Registration successful! User ID: " + result.userId)), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("\u00a7c[Tunnely] Registration failed: " + result.error)));
            }
        }, "Tunnely-Register").start();
        return 1;
    }

    private static int start(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Starting tunnel..."), false);
        new Thread(() -> {
            boolean isDedicatedServer = !((CommandSourceStack)context.getSource()).getServer().isSingleplayer();
            TunnelConfig config = TunnelConfig.getInstance();
            String visibility = isDedicatedServer ? config.getSavedVisibility() : "invite_only";
            String serverName = isDedicatedServer ? config.getSavedServerName() : "Minecraft Server";
            boolean success = TunnelManager.getInstance().initializeTunnel(((CommandSourceStack)context.getSource()).getServer(), visibility, serverName);
            if (success) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a[Tunnely] Tunnel started successfully!"), false);
                if (isDedicatedServer) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Visibility: \u00a7b" + visibility + " \u00a77| Server name: \u00a7b" + serverName)), false);
                }
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] Failed to start tunnel. Check console for details."));
            }
        }, "Tunnely-Start-Command").start();
        return 1;
    }

    private static int startWithVisibility(CommandContext<CommandSourceStack> context) {
        String visibilityArg = StringArgumentType.getString(context, (String)"visibility");
        String visibility = TunnelCommand.parseVisibility(visibilityArg);
        if (visibility == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] Invalid visibility. Use: public, friends, or invite"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Starting tunnel..."), false);
        new Thread(() -> {
            boolean success;
            String serverName;
            boolean isDedicatedServer = !((CommandSourceStack)context.getSource()).getServer().isSingleplayer();
            TunnelConfig config = TunnelConfig.getInstance();
            String string = serverName = isDedicatedServer ? config.getSavedServerName() : "Minecraft Server";
            if (isDedicatedServer) {
                config.setSavedVisibility(visibility);
            }
            if (success = TunnelManager.getInstance().initializeTunnel(((CommandSourceStack)context.getSource()).getServer(), visibility, serverName)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a[Tunnely] Tunnel started successfully!"), false);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Visibility: \u00a7b" + visibility + " \u00a77| Server name: \u00a7b" + serverName)), false);
                if (isDedicatedServer) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77Settings saved! Use \u00a7e/tunnel autostart on \u00a77to enable auto-start."), false);
                }
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] Failed to start tunnel. Check console for details."));
            }
        }, "Tunnely-Start-Command").start();
        return 1;
    }

    private static int startWithVisibilityAndName(CommandContext<CommandSourceStack> context) {
        String visibilityArg = StringArgumentType.getString(context, (String)"visibility");
        String visibility = TunnelCommand.parseVisibility(visibilityArg);
        String serverName = StringArgumentType.getString(context, (String)"serverName");
        if (visibility == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] Invalid visibility. Use: public, friends, or invite"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Starting tunnel..."), false);
        new Thread(() -> {
            boolean success;
            boolean isDedicatedServer = !((CommandSourceStack)context.getSource()).getServer().isSingleplayer();
            TunnelConfig config = TunnelConfig.getInstance();
            if (isDedicatedServer) {
                config.setSavedVisibility(visibility);
                config.setSavedServerName(serverName);
            }
            if (success = TunnelManager.getInstance().initializeTunnel(((CommandSourceStack)context.getSource()).getServer(), visibility, serverName)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a[Tunnely] Tunnel started successfully!"), false);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Visibility: \u00a7b" + visibility + " \u00a77| Server name: \u00a7b" + serverName)), false);
                if (isDedicatedServer) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77Settings saved! Use \u00a7e/tunnel autostart on \u00a77to enable auto-start."), false);
                }
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] Failed to start tunnel. Check console for details."));
            }
        }, "Tunnely-Start-Command").start();
        return 1;
    }

    private static int stop(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Stopping tunnel..."), false);
        TunnelManager.getInstance().shutdownTunnel();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a[Tunnely] Tunnel stopped"), false);
        return 1;
    }

    private static int endpoint(CommandContext<CommandSourceStack> context) {
        String endpoint = TunnelManager.getInstance().getPublicEndpoint();
        if (endpoint != null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7e[Tunnely] Public Endpoint: \u00a7b" + endpoint)), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77Share this address with your friends to let them join!"), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] No active tunnel. Use /tunnel start to create one."));
        }
        return 1;
    }

    private static int help(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a76=== Tunnely Commands ==="), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/tunnel status \u00a77- Show tunnel status"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/tunnel menu \u00a77- Open Tunnely UI (or press U)"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/tunnel login \"email@example.com\" <password> \u00a77- Login"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"  \u00a77(Quote email due to @ symbol)"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/tunnel register \"email@example.com\" <password> \u00a77- Register"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/tunnel start [visibility] [name] \u00a77- Start tunnel"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"  \u00a77Visibility: \u00a7bpublic\u00a77, \u00a7bfriends\u00a77, \u00a7binvite \u00a77(default)"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/tunnel autostart [on|off] \u00a77- Auto-start (dedicated servers)"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/tunnel stop \u00a77- Stop tunnel"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/tunnel endpoint \u00a77- Show public endpoint"), false);
        return 1;
    }

    private static int autostartOn(CommandContext<CommandSourceStack> context) {
        boolean isDedicatedServer;
        boolean bl = isDedicatedServer = !((CommandSourceStack)context.getSource()).getServer().isSingleplayer();
        if (!isDedicatedServer) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7c[Tunnely] Auto-start is only available for dedicated servers"));
            return 0;
        }
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAutoStartTunnel(true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a[Tunnely] Auto-start enabled!"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77Tunnel will automatically start when server starts"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Visibility: \u00a7b" + config.getSavedVisibility() + " \u00a77| Server name: \u00a7b" + config.getSavedServerName())), false);
        return 1;
    }

    private static int autostartOff(CommandContext<CommandSourceStack> context) {
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAutoStartTunnel(false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Auto-start disabled"), false);
        return 1;
    }

    private static int autostartStatus(CommandContext<CommandSourceStack> context) {
        boolean isDedicatedServer = !((CommandSourceStack)context.getSource()).getServer().isSingleplayer();
        TunnelConfig config = TunnelConfig.getInstance();
        if (!isDedicatedServer) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e[Tunnely] Auto-start: \u00a77Only available for dedicated servers"), false);
            return 1;
        }
        boolean enabled = config.isAutoStartTunnel();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7e[Tunnely] Auto-start: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), false);
        if (enabled) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Visibility: \u00a7b" + config.getSavedVisibility() + " \u00a77| Server name: \u00a7b" + config.getSavedServerName())), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77Use \u00a7e/tunnel autostart on \u00a77to enable"), false);
        }
        return 1;
    }

    private static String parseVisibility(String arg) {
        switch (arg.toLowerCase()) {
            case "public": {
                return "public";
            }
            case "friends": {
                return "friends_only";
            }
            case "invite": {
                return "invite_only";
            }
        }
        return null;
    }
}

