/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;

public class FriendsScreen
extends Screen {
    private final Screen parent;
    private FriendListWidget friendList;
    private EditBox friendEmailBox;
    private String statusMessage = "\u00a7eLoading friends...";
    private int statusColor = 0xFFFF00;

    public FriendsScreen(Screen parent) {
        super((Component)Component.literal((String)"Friends"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int inputWidth = 200;
        int centerX = this.width / 2 - inputWidth / 2;
        this.friendEmailBox = new EditBox(this.font, centerX, this.height - 95, inputWidth - 70, 20, (Component)Component.literal((String)"Minecraft Username"));
        this.friendEmailBox.setMaxLength(16);
        this.friendEmailBox.setHint((Component)Component.literal((String)"Minecraft username"));
        this.addRenderableWidget((GuiEventListener)this.friendEmailBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Add"), button -> this.addFriend()).bounds(centerX + inputWidth - 65, this.height - 95, 60, 20).build());
        this.friendList = new FriendListWidget(this.minecraft, this.width, this.height, 50, this.height - 110, 35);
        this.addWidget((GuiEventListener)this.friendList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udd04 Refresh"), button -> this.loadFriends()).bounds(this.width / 2 - 155, this.height - 50, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 + 55, this.height - 50, 100, 20).build());
        this.loadFriends();
    }

    private void addFriend() {
        String username = this.friendEmailBox.getValue().trim();
        if (username.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a username";
            this.statusColor = 0xFF0000;
            return;
        }
        if (!username.matches("^[a-zA-Z0-9_]{3,16}$")) {
            this.statusMessage = "\u00a7cInvalid Minecraft username";
            this.statusColor = 0xFF0000;
            System.err.println("[Tunnely UI] Invalid username format: " + username);
            return;
        }
        System.out.println("[Tunnely UI] ===== ADDING FRIEND =====");
        System.out.println("[Tunnely UI] Username: " + username);
        this.statusMessage = "\u00a7eSending friend request...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.sendFriendRequestByUsername(username);
                this.minecraft.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aFriend request sent to " + username + "!";
                        this.statusColor = 65280;
                        this.friendEmailBox.setValue("");
                        System.out.println("[Tunnely UI] \u2713 Friend request succeeded, reloading list");
                        this.loadFriends();
                    } else {
                        this.statusMessage = "\u00a7cUser not found or request failed";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Friend request failed for: " + username);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception adding friend: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-AddFriend").start();
    }

    private void loadFriends() {
        System.out.println("[Tunnely UI] ===== LOADING FRIENDS =====");
        this.statusMessage = "\u00a7eLoading friends...";
        this.statusColor = 0xFFFF00;
        this.friendList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.FriendListResult result = client.getFriends();
                this.minecraft.execute(() -> {
                    block7: {
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing friends data...");
                                JsonArray friends = JsonParser.parseString((String)result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + friends.size() + " friend(s)");
                                if (friends.size() == 0) {
                                    this.statusMessage = "\u00a77No friends yet. Add some above!";
                                    this.statusColor = 0xAAAAAA;
                                    break block7;
                                }
                                for (JsonElement element : friends) {
                                    JsonObject friendProfile;
                                    JsonObject friend = element.getAsJsonObject();
                                    String friendId = friend.get("id").getAsString();
                                    String minecraftName = "Unknown";
                                    if (friend.has("friend") && !friend.get("friend").isJsonNull() && (friendProfile = friend.getAsJsonObject("friend")).has("minecraft_name")) {
                                        minecraftName = friendProfile.get("minecraft_name").getAsString();
                                    }
                                    String status = friend.has("status") ? friend.get("status").getAsString() : "unknown";
                                    System.out.println("[Tunnely UI] Friend: " + minecraftName + " (status: " + status + ")");
                                    this.friendList.addFriend(friendId, minecraftName, status);
                                }
                                this.statusMessage = "\u00a7a" + friends.size() + " friend(s)";
                                this.statusColor = 65280;
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse friends list";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing friends: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load friends: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading friends: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadFriends").start();
    }

    private void removeFriend(String friendId) {
        System.out.println("[Tunnely UI] ===== REMOVING FRIEND =====");
        System.out.println("[Tunnely UI] Friend ID: " + friendId);
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.removeFriend(friendId);
                this.minecraft.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aFriend removed";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Friend removed successfully");
                        this.loadFriends();
                    } else {
                        this.statusMessage = "\u00a7cFailed to remove friend";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to remove friend");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception removing friend: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-RemoveFriend").start();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.friendList.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, "\u00a76\u00a7lManage Friends", this.width / 2, 20, ColorUtil.opaque(0xFFFFFF));
        graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, 35, ColorUtil.opaque(this.statusColor));
        graphics.drawString(this.font, "Add Friend (Minecraft name):", this.width / 2 - 100, this.height - 110, ColorUtil.opaque(0xFFFFFF));
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private class FriendListWidget
    extends ObjectSelectionList<FriendEntry> {
        public FriendListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom);
        }

        public void clear() {
            this.clearEntries();
        }

        public void addFriend(String id, String name, String status) {
            this.addEntry((AbstractSelectionList.Entry)new FriendEntry(id, name, status));
        }

        class FriendEntry
        extends ObjectSelectionList.Entry<FriendEntry> {
            private final String id;
            private final String name;
            private final String status;
            private final Button removeButton;

            public FriendEntry(String id, String name, String status) {
                this.id = id;
                this.name = name;
                this.status = status;
                this.removeButton = Button.builder((Component)Component.literal((String)"Remove"), button -> FriendsScreen.this.removeFriend(id)).bounds(0, 0, 70, 20).build();
            }

            public void renderContent(GuiGraphics graphics, int index, int top, boolean isMouseOver, float partialTick) {
                int left = FriendListWidget.this.getRowLeft();
                int width = FriendListWidget.this.getRowWidth();
                int mouseX = (int)((FriendListWidget)FriendListWidget.this).minecraft.mouseHandler.xpos() * FriendListWidget.this.minecraft.getWindow().getGuiScaledWidth() / FriendListWidget.this.minecraft.getWindow().getScreenWidth();
                int mouseY = (int)((FriendListWidget)FriendListWidget.this).minecraft.mouseHandler.ypos() * FriendListWidget.this.minecraft.getWindow().getGuiScaledHeight() / FriendListWidget.this.minecraft.getWindow().getScreenHeight();
                graphics.drawString(FriendsScreen.this.font, "\u00a7b" + this.name, left + 5, top + 5, ColorUtil.opaque(0xFFFFFF));
                String statusText = this.status.equals("accepted") ? "\u00a7a\u2713 Friends" : (this.status.equals("pending") ? "\u00a7e\u23f3 Pending" : "\u00a77Unknown");
                graphics.drawString(FriendsScreen.this.font, statusText, left + 5, top + 18, ColorUtil.opaque(0xFFFFFF));
                this.removeButton.setX(left + width - 80);
                this.removeButton.setY(top + 7);
                this.removeButton.render(graphics, mouseX, mouseY, partialTick);
            }

            public boolean mouseClicked(MouseButtonEvent event, boolean dragging) {
                return this.removeButton.mouseClicked(event, dragging);
            }

            public Component getNarration() {
                return Component.literal((String)(this.name + " - " + this.status));
            }
        }
    }
}

