/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.tunnelyrefab.config.PortForwardingConfig;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.security.RelayValidator;
import org.texboobcat.tunnelyrefab.tunnel.ModDetector;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.InviteFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.util.ContentModerator;

public class HostGameScreen
extends Screen {
    private final Screen parent;
    private final TunnelManager manager;
    private EditBox serverNameBox;
    private EditBox maxPlayersBox;
    private Button visibilityButton;
    private Button toggleVisibilityButton;
    private Button onlineModeButton;
    private Button gamemodeButton;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private String selectedVisibility = "invite_only";
    private String currentServerVisibility = "invite_only";
    private int warningIconX = 0;
    private int warningIconY = 0;
    private boolean showWarningTooltip = false;
    private int centerX = 0;
    private int buttonWidth = 200;
    private int buttonHeight = 20;
    private List<PortForwardingConfig> availablePortForwards = new ArrayList<PortForwardingConfig>();
    private Map<PortForwardingConfig, Checkbox> portForwardCheckboxes = new HashMap<PortForwardingConfig, Checkbox>();
    private final List<AbstractWidget> scrollWidgets = new ArrayList<AbstractWidget>();
    private final Map<AbstractWidget, Integer> widgetBaseY = new HashMap<AbstractWidget, Integer>();
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int scrollTop;
    private int scrollBottom;
    private int scrollLeft;
    private int scrollRight;
    private int contentHeight = 0;
    private boolean draggingScrollbar = false;
    private int dragStartMouseY = 0;
    private int dragStartScrollOffset = 0;
    private int labelServerNameY;
    private int labelMaxPlayersY;
    private int labelVisibilityY;
    private int visibilityDescY;
    private int labelOnlineModeY;
    private int labelGamemodeY;
    private int portSectionLabelY;
    private int portSectionDescY;

    public HostGameScreen(Screen parent) {
        super((Component)Component.literal((String)"Host Game"));
        this.parent = parent;
        this.manager = TunnelManager.getInstance();
    }

    protected void init() {
        boolean inSingleplayer;
        super.init();
        if (this.availablePortForwards.isEmpty()) {
            this.availablePortForwards = ModDetector.detectInstalledMods();
        }
        this.buttonWidth = 200;
        this.buttonHeight = 20;
        this.centerX = this.width / 2 - this.buttonWidth / 2;
        boolean bl = inSingleplayer = this.minecraft.getSingleplayerServer() != null;
        if (!inSingleplayer) {
            int y = 80;
            ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u26a0 Not In World"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$0(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()).bounds((int)this.centerX, (int)y, (int)this.buttonWidth, (int)this.buttonHeight).build())).active = false;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(this.centerX, this.height - 30, this.buttonWidth, this.buttonHeight).build());
            this.statusMessage = "\u00a7cYou must be in a world to host!";
            this.statusColor = 0xFF5555;
            return;
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.connected) {
            int y = 80;
            if (status.publicEndpoint != null) {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Copy Endpoint"), button -> this.copyToClipboard(status.publicEndpoint)).bounds(this.centerX, y, this.buttonWidth, this.buttonHeight).build());
                y += 30;
            }
            this.toggleVisibilityButton = Button.builder((Component)this.getActiveVisibilityButtonText(), button -> {
                this.cycleActiveVisibility();
                this.toggleVisibilityButton.setMessage(this.getActiveVisibilityButtonText());
            }).bounds(this.centerX, y, this.buttonWidth, this.buttonHeight).build();
            this.addRenderableWidget((GuiEventListener)this.toggleVisibilityButton);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Invite Friends"), button -> this.minecraft.setScreen((Screen)new InviteFriendsScreen(this, status.sessionId))).bounds(this.centerX, y += 30, this.buttonWidth, this.buttonHeight).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u00a7cStop Hosting"), button -> this.stopTunnel()).bounds(this.centerX, y += 40, this.buttonWidth, this.buttonHeight).build());
        } else {
            this.scrollTop = 60;
            this.scrollBottom = this.height - 80;
            this.scrollLeft = this.centerX;
            this.scrollRight = this.centerX + this.buttonWidth;
            this.scrollOffset = 0;
            this.scrollWidgets.clear();
            this.widgetBaseY.clear();
            this.contentHeight = 0;
            int contentY = this.scrollTop;
            this.labelServerNameY = contentY - 12;
            this.serverNameBox = new EditBox(this.font, this.centerX, contentY, this.buttonWidth, this.buttonHeight, (Component)Component.literal((String)"Server Name"));
            this.serverNameBox.setMaxLength(32);
            this.serverNameBox.setHint((Component)Component.literal((String)"Enter server name..."));
            this.serverNameBox.setValue("Minecraft Server");
            this.addRenderableWidget((GuiEventListener)this.serverNameBox);
            this.registerScrollableWidget((AbstractWidget)this.serverNameBox, contentY);
            this.labelMaxPlayersY = (contentY += 35) - 12;
            this.maxPlayersBox = new EditBox(this.font, this.centerX, contentY, this.buttonWidth, this.buttonHeight, (Component)Component.literal((String)"Max Players"));
            this.maxPlayersBox.setMaxLength(2);
            this.maxPlayersBox.setHint((Component)Component.literal((String)"Max players (1-20)..."));
            this.maxPlayersBox.setValue(String.valueOf(TunnelConfig.getInstance().getMaxPlayers()));
            this.maxPlayersBox.setFilter(text -> {
                if (text.isEmpty()) {
                    return true;
                }
                try {
                    int val = Integer.parseInt(text);
                    return val >= 1 && val <= 20;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            this.addRenderableWidget((GuiEventListener)this.maxPlayersBox);
            this.registerScrollableWidget((AbstractWidget)this.maxPlayersBox, contentY);
            this.labelVisibilityY = (contentY += 35) - 12;
            this.visibilityButton = Button.builder((Component)this.getVisibilityButtonText(), button -> {
                this.cycleVisibility();
                this.visibilityButton.setMessage(this.getVisibilityButtonText());
            }).bounds(this.centerX, contentY, this.buttonWidth, this.buttonHeight).build();
            this.addRenderableWidget((GuiEventListener)this.visibilityButton);
            this.registerScrollableWidget((AbstractWidget)this.visibilityButton, contentY);
            this.visibilityDescY = (contentY += 30) + 5;
            this.labelOnlineModeY = (contentY += 25) - 12;
            this.onlineModeButton = Button.builder((Component)this.getOnlineModeButtonText(), button -> {
                this.toggleOnlineMode();
                this.onlineModeButton.setMessage(this.getOnlineModeButtonText());
            }).bounds(this.centerX, contentY, this.buttonWidth, this.buttonHeight).build();
            this.addRenderableWidget((GuiEventListener)this.onlineModeButton);
            this.registerScrollableWidget((AbstractWidget)this.onlineModeButton, contentY);
            this.labelGamemodeY = (contentY += 35) - 12;
            this.gamemodeButton = Button.builder((Component)this.getGamemodeButtonText(), button -> {
                this.cycleGamemode();
                this.gamemodeButton.setMessage(this.getGamemodeButtonText());
            }).bounds(this.centerX, contentY, this.buttonWidth, this.buttonHeight).build();
            this.addRenderableWidget((GuiEventListener)this.gamemodeButton);
            this.registerScrollableWidget((AbstractWidget)this.gamemodeButton, contentY);
            contentY += 35;
            if (!this.availablePortForwards.isEmpty()) {
                this.portSectionLabelY = contentY;
                this.portSectionDescY = contentY + 12;
                contentY += 26;
                for (PortForwardingConfig portConfig : this.availablePortForwards) {
                    boolean portAvailable = ModDetector.isPortAvailable(portConfig.getPort(), portConfig.getProtocol());
                    String label = portConfig.getServiceName() + " (" + portConfig.getShortDisplayString() + ")";
                    if (!portAvailable) {
                        label = label + " \u26a0";
                    }
                    Checkbox checkbox = Checkbox.builder((Component)Component.literal((String)label), (Font)this.font).pos(this.centerX, contentY).selected(portConfig.isEnabled()).onValueChange((cb, selected) -> portConfig.setEnabled(selected)).build();
                    if (!portAvailable) {
                        checkbox.active = false;
                        portConfig.setEnabled(false);
                    }
                    this.addRenderableWidget((GuiEventListener)checkbox);
                    this.portForwardCheckboxes.put(portConfig, checkbox);
                    this.registerScrollableWidget((AbstractWidget)checkbox, contentY);
                    contentY += 22;
                }
            }
            this.contentHeight = contentY - this.scrollTop;
            this.maxScroll = Math.max(0, this.contentHeight - (this.scrollBottom - this.scrollTop));
            this.layoutScrollWidgets();
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u00a7aStart Hosting"), button -> this.startTunnel()).bounds(this.centerX, this.height - 60, this.buttonWidth, this.buttonHeight).build());
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(this.centerX, this.height - 30, this.buttonWidth, this.buttonHeight).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (TunnelConfig.getInstance().isOfflineMode() && this.warningIconX > 0 && this.warningIconY > 0) {
            int iconWidth = this.font.width("(!)");
            this.showWarningTooltip = mouseX >= this.warningIconX && mouseX <= this.warningIconX + iconWidth + 4 && mouseY >= this.warningIconY - 2 && mouseY <= this.warningIconY + 12;
        } else {
            this.showWarningTooltip = false;
        }
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, ColorUtil.opaque(0xFFAA00));
        if (this.minecraft.getSingleplayerServer() == null) {
            graphics.drawCenteredString(this.font, "\u00a7c\u26a0 Cannot Host Server", this.width / 2, 40, ColorUtil.opaque(0xFF5555));
            graphics.drawCenteredString(this.font, "\u00a77You must be in a single-player world to host.", this.width / 2, 60, ColorUtil.opaque(0xAAAAAA));
            graphics.drawCenteredString(this.font, "\u00a77Steps:", this.width / 2, 80, ColorUtil.opaque(0xAAAAAA));
            graphics.drawCenteredString(this.font, "\u00a771. Go back to the main menu", this.width / 2, 95, ColorUtil.opaque(0xAAAAAA));
            graphics.drawCenteredString(this.font, "\u00a772. Create a new world or load an existing one", this.width / 2, 107, ColorUtil.opaque(0xAAAAAA));
            graphics.drawCenteredString(this.font, "\u00a773. Open the menu and click 'Tunnely'", this.width / 2, 119, ColorUtil.opaque(0xAAAAAA));
            graphics.drawCenteredString(this.font, "\u00a774. Click 'Host Game' to start hosting", this.width / 2, 131, ColorUtil.opaque(0xAAAAAA));
            if (!this.statusMessage.isEmpty()) {
                graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, this.height - 50, ColorUtil.opaque(this.statusColor));
            }
            return;
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.connected) {
            graphics.drawCenteredString(this.font, "\u00a7a\u2713 Server is Running", this.width / 2, 40, ColorUtil.opaque(65280));
            if (status.publicEndpoint != null) {
                graphics.drawCenteredString(this.font, "\u00a7eEndpoint:", this.width / 2, 55, ColorUtil.opaque(0xFFFFFF));
                String endpoint = status.publicEndpoint;
                int endpointWidth = this.font.width(endpoint);
                int boxX = this.width / 2 - endpointWidth / 2 - 5;
                int boxY = 62;
                graphics.fill(boxX, boxY, boxX + endpointWidth + 10, boxY + 12, Integer.MIN_VALUE);
                graphics.drawCenteredString(this.font, "\u00a7b" + endpoint, this.width / 2, 65, ColorUtil.opaque(65535));
            }
            if (!this.availablePortForwards.isEmpty()) {
                int activeCount = 0;
                for (PortForwardingConfig portConfig : this.availablePortForwards) {
                    if (!portConfig.isEnabled()) continue;
                    ++activeCount;
                }
                if (activeCount > 0) {
                    int yOffset = 90;
                    graphics.drawString(this.font, "\u00a7eActive Services:", this.width / 2 - 80, yOffset, ColorUtil.opaque(0xFFAA00));
                    yOffset += 15;
                    for (PortForwardingConfig portConfig : this.availablePortForwards) {
                        if (!portConfig.isEnabled()) continue;
                        graphics.drawString(this.font, "\u00a7a\u2713 " + portConfig.getDisplayString(), this.width / 2 - 80, yOffset, ColorUtil.opaque(65280));
                        yOffset += 12;
                    }
                }
            }
        } else {
            int yGM;
            int yOM;
            int yDesc;
            int yV;
            int yMP;
            graphics.drawCenteredString(this.font, "\u00a77Configure Your Server", this.width / 2, 40, ColorUtil.opaque(0xAAAAAA));
            try {
                graphics.enableScissor(this.scrollLeft, this.scrollTop, this.scrollRight, this.scrollBottom);
            }
            catch (Throwable activeCount) {
                // empty catch block
            }
            int labelX = this.width / 2 - 100;
            int ySN = this.labelServerNameY - this.scrollOffset;
            if (ySN >= this.scrollTop - 12 && ySN <= this.scrollBottom) {
                graphics.drawString(this.font, "Server Name:", labelX, ySN, ColorUtil.opaque(0xFFFFFF));
            }
            if ((yMP = this.labelMaxPlayersY - this.scrollOffset) >= this.scrollTop - 12 && yMP <= this.scrollBottom) {
                graphics.drawString(this.font, "Max Players:", labelX, yMP, ColorUtil.opaque(0xFFFFFF));
            }
            if ((yV = this.labelVisibilityY - this.scrollOffset) >= this.scrollTop - 12 && yV <= this.scrollBottom) {
                graphics.drawString(this.font, "Visibility:", labelX, yV, ColorUtil.opaque(0xFFFFFF));
            }
            if ((yDesc = this.visibilityDescY - this.scrollOffset) >= this.scrollTop - 12 && yDesc <= this.scrollBottom) {
                String desc = this.getVisibilityDescription();
                graphics.drawCenteredString(this.font, "\u00a77" + desc, this.width / 2, yDesc, ColorUtil.opaque(0xAAAAAA));
            }
            if ((yOM = this.labelOnlineModeY - this.scrollOffset) >= this.scrollTop - 12 && yOM <= this.scrollBottom) {
                graphics.drawString(this.font, "Authentication:", labelX, yOM, ColorUtil.opaque(0xFFFFFF));
                if (TunnelConfig.getInstance().isOfflineMode()) {
                    int buttonEndX = this.centerX + this.buttonWidth + 5;
                    int buttonCenterY = this.labelOnlineModeY + 12 - this.scrollOffset + 5;
                    this.warningIconX = buttonEndX;
                    this.warningIconY = buttonCenterY;
                } else {
                    this.warningIconX = 0;
                    this.warningIconY = 0;
                }
            }
            if ((yGM = this.labelGamemodeY - this.scrollOffset) >= this.scrollTop - 12 && yGM <= this.scrollBottom) {
                graphics.drawString(this.font, "Default Gamemode:", labelX, yGM, ColorUtil.opaque(0xFFFFFF));
            }
            if (!this.availablePortForwards.isEmpty()) {
                int yPortsHint;
                int yPortsDesc;
                int yPorts = this.portSectionLabelY - this.scrollOffset;
                if (yPorts >= this.scrollTop - 12 && yPorts <= this.scrollBottom) {
                    graphics.drawString(this.font, "\u00a7eAdditional Ports:", labelX, yPorts, ColorUtil.opaque(0xFFAA00));
                }
                if ((yPortsDesc = this.portSectionDescY - this.scrollOffset) >= this.scrollTop - 12 && yPortsDesc <= this.scrollBottom) {
                    graphics.drawString(this.font, "\u00a77Enable voice chat and other services", labelX, yPortsDesc, ColorUtil.opaque(0x888888));
                }
                if ((yPortsHint = this.portSectionDescY + 12 - this.scrollOffset) >= this.scrollTop - 12 && yPortsHint <= this.scrollBottom) {
                    graphics.drawString(this.font, "\u00a77\u26a0 = Port in use by another app", labelX, yPortsHint, ColorUtil.opaque(0x888888));
                }
            }
            try {
                graphics.disableScissor();
            }
            catch (Throwable yPorts) {
                // empty catch block
            }
            if (this.warningIconX > 0 && this.warningIconY > 0 && TunnelConfig.getInstance().isOfflineMode() && this.warningIconY >= this.scrollTop && this.warningIconY <= this.scrollBottom) {
                graphics.drawString(this.font, "\u00a7c(!)", this.warningIconX, this.warningIconY, ColorUtil.opaque(0xFF5555));
            }
            if (this.maxScroll > 0) {
                int trackX = this.getTrackX();
                int trackTop = this.scrollTop;
                int trackBottom = this.scrollBottom;
                int trackHeight = this.getTrackHeight();
                int thumbHeight = this.getThumbHeight(trackHeight);
                int thumbY = this.getThumbY(trackTop, trackHeight, thumbHeight);
                graphics.fill(trackX, trackTop, trackX + 4, trackBottom, Integer.MIN_VALUE);
                graphics.fill(trackX, thumbY, trackX + 4, thumbY + thumbHeight, -6250336);
            }
        }
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, this.height - 50, ColorUtil.opaque(this.statusColor));
        }
        if (this.showWarningTooltip && TunnelConfig.getInstance().isOfflineMode()) {
            String tooltipText = "We do not support piracy";
            int tooltipWidth = this.font.width(tooltipText) + 8;
            int tooltipHeight = 16;
            int tooltipX = this.warningIconX + 15;
            int tooltipY = this.warningIconY - 5;
            if (tooltipX + tooltipWidth > this.width) {
                tooltipX = this.width - tooltipWidth - 5;
            }
            graphics.fill(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -536870912);
            graphics.fill(tooltipX - 1, tooltipY - 1, tooltipX + tooltipWidth + 1, tooltipY, -43691);
            graphics.fill(tooltipX - 1, tooltipY + tooltipHeight, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight + 1, -43691);
            graphics.fill(tooltipX - 1, tooltipY, tooltipX, tooltipY + tooltipHeight, -43691);
            graphics.fill(tooltipX + tooltipWidth, tooltipY, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight, -43691);
            graphics.drawString(this.font, tooltipText, tooltipX + 4, tooltipY + 4, ColorUtil.opaque(0xFFFFFF));
        }
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private void startTunnel() {
        if (this.minecraft.getSingleplayerServer() == null) {
            this.statusMessage = "\u00a7cError: Not in a single-player world!";
            this.statusColor = 0xFF5555;
            return;
        }
        String serverName = this.serverNameBox != null ? this.serverNameBox.getValue().trim() : "Minecraft Server";
        ContentModerator.ValidationResult validation = ContentModerator.validateServerName(serverName);
        if (!validation.valid) {
            this.statusMessage = "\u00a7c" + validation.errorMessage;
            this.statusColor = 0xFF0000;
            return;
        }
        RelayValidator.RelaySecurityStatus securityStatus = RelayValidator.validateRelayConfig();
        if (!securityStatus.isTrusted()) {
            String relayUrl = TunnelConfig.getInstance().getRelayServerUrl();
            this.minecraft.setScreen((Screen)new WarningPopupScreen(this, this, "\u26a0\ufe0f Untrusted Relay Server", securityStatus.message + "\n\nRelay URL: " + relayUrl + "\n\nThe relay operator can see:\n\u2022 Your IP address and connection metadata\n\u2022 All game traffic (chat, coordinates, etc.)\n\nOnly continue if you trust the relay operator.\nOfficial relays: See documentation", 0xFF0000, this::startTunnelConfirmed));
            return;
        }
        this.startTunnelConfirmed();
    }

    private void startTunnelConfirmed() {
        String serverName = this.serverNameBox != null ? this.serverNameBox.getValue().trim() : "Minecraft Server";
        int maxPlayers = 8;
        if (this.maxPlayersBox != null && !this.maxPlayersBox.getValue().isEmpty()) {
            try {
                maxPlayers = Integer.parseInt(this.maxPlayersBox.getValue());
                if (maxPlayers < 1 || maxPlayers > 20) {
                    this.statusMessage = "\u00a7cMax players must be between 1 and 20";
                    this.statusColor = 0xFF0000;
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.statusMessage = "\u00a7cInvalid max players value";
                this.statusColor = 0xFF0000;
                return;
            }
        }
        TunnelConfig.getInstance().setMaxPlayers(maxPlayers);
        this.statusMessage = "\u00a7eStarting tunnel...";
        this.statusColor = 0xFFFF00;
        String visibility = this.selectedVisibility;
        ArrayList<PortForwardingConfig> enabledPorts = new ArrayList<PortForwardingConfig>();
        for (PortForwardingConfig portConfig : this.availablePortForwards) {
            if (!portConfig.isEnabled()) continue;
            enabledPorts.add(portConfig);
        }
        new Thread(() -> {
            boolean success = this.manager.initializeTunnel((MinecraftServer)this.minecraft.getSingleplayerServer(), visibility, serverName, enabledPorts);
            this.minecraft.execute(() -> {
                if (success) {
                    int portCount = enabledPorts.size();
                    this.statusMessage = portCount > 0 ? "\u00a7aTunnel started with " + portCount + " additional port(s)!" : "\u00a7aTunnel started!";
                    this.statusColor = 65280;
                    this.minecraft.setScreen((Screen)new HostGameScreen(this.parent));
                } else {
                    this.statusMessage = "\u00a7cFailed to start. Check logs.";
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-Start").start();
    }

    private void stopTunnel() {
        this.statusMessage = "\u00a7eStopping...";
        this.statusColor = 0xFFFF00;
        this.manager.shutdownTunnel();
        this.statusMessage = "\u00a7aStopped";
        this.statusColor = 65280;
        this.minecraft.setScreen((Screen)new HostGameScreen(this.parent));
    }

    private void cycleActiveVisibility() {
        switch (this.currentServerVisibility) {
            case "invite_only": {
                this.currentServerVisibility = "friends_only";
                break;
            }
            case "friends_only": {
                this.currentServerVisibility = "public";
                break;
            }
            case "public": {
                this.currentServerVisibility = "invite_only";
                break;
            }
            default: {
                this.currentServerVisibility = "invite_only";
            }
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.sessionId != null) {
            this.statusMessage = "\u00a7eUpdating...";
            this.statusColor = 0xFFFF00;
            String newVisibility = this.currentServerVisibility;
            new Thread(() -> {
                boolean success = this.manager.updateServerVisibility(newVisibility);
                this.minecraft.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aUpdated!";
                        this.statusColor = 65280;
                    } else {
                        this.statusMessage = "\u00a7cFailed to update";
                        this.statusColor = 0xFF0000;
                    }
                });
            }, "Tunnely-Toggle").start();
        }
    }

    private Component getActiveVisibilityButtonText() {
        switch (this.currentServerVisibility) {
            case "public": {
                return Component.literal((String)"\ud83c\udf10 Public");
            }
            case "friends_only": {
                return Component.literal((String)"\ud83d\udc65 Friends Only");
            }
            case "invite_only": {
                return Component.literal((String)"\ud83d\udd12 Invite Only");
            }
        }
        return Component.literal((String)"Unknown");
    }

    private void cycleVisibility() {
        switch (this.selectedVisibility) {
            case "invite_only": {
                this.selectedVisibility = "friends_only";
                break;
            }
            case "friends_only": {
                this.selectedVisibility = "public";
                break;
            }
            case "public": {
                this.selectedVisibility = "invite_only";
                break;
            }
            default: {
                this.selectedVisibility = "invite_only";
            }
        }
    }

    private Component getVisibilityButtonText() {
        switch (this.selectedVisibility) {
            case "public": {
                return Component.literal((String)"\ud83c\udf10 Public");
            }
            case "friends_only": {
                return Component.literal((String)"\ud83d\udc65 Friends Only");
            }
            case "invite_only": {
                return Component.literal((String)"\ud83d\udd12 Invite Only");
            }
        }
        return Component.literal((String)"Unknown");
    }

    private String getVisibilityDescription() {
        switch (this.selectedVisibility) {
            case "public": {
                return "Anyone can join";
            }
            case "friends_only": {
                return "Only friends can join";
            }
            case "invite_only": {
                return "Requires invitation (Most Private)";
            }
        }
        return "";
    }

    private void toggleOnlineMode() {
        TunnelConfig config;
        config.setOfflineMode(!(config = TunnelConfig.getInstance()).isOfflineMode());
        if (config.isOfflineMode()) {
            this.statusMessage = "\u00a7eOffline mode enabled - Authentication disabled";
            this.statusColor = 0xFFAA00;
        } else {
            this.statusMessage = "\u00a7aOnline mode enabled - Authentication required";
            this.statusColor = 65280;
        }
    }

    private Component getOnlineModeButtonText() {
        boolean isOffline = TunnelConfig.getInstance().isOfflineMode();
        if (isOffline) {
            return Component.literal((String)"\ud83d\udd13 Offline Mode");
        }
        return Component.literal((String)"\ud83d\udd12 Online Mode");
    }

    private void cycleGamemode() {
        String current;
        TunnelConfig config = TunnelConfig.getInstance();
        String next = switch (current = config.getDefaultGamemode()) {
            case "survival" -> "creative";
            case "creative" -> "adventure";
            case "adventure" -> "spectator";
            case "spectator" -> "survival";
            default -> "survival";
        };
        config.setDefaultGamemode(next);
        this.statusMessage = "\u00a7aGamemode: " + this.capitalize(next);
        this.statusColor = 65280;
    }

    private Component getGamemodeButtonText() {
        String gamemode;
        return Component.literal((String)((switch (gamemode = TunnelConfig.getInstance().getDefaultGamemode()) {
            case "creative" -> "\ud83c\udfa8";
            case "adventure" -> "\ud83d\uddfa\ufe0f";
            case "spectator" -> "\ud83d\udc7b";
            default -> "\u2694\ufe0f";
        }) + " " + this.capitalize(gamemode)));
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void copyToClipboard(String text) {
        this.minecraft.keyboardHandler.setClipboard(text);
        this.statusMessage = "\u00a7aCopied!";
        this.statusColor = 65280;
    }

    private int getTrackX() {
        return this.scrollRight + 6;
    }

    private int getTrackHeight() {
        return this.scrollBottom - this.scrollTop;
    }

    private int getThumbHeight(int trackHeight) {
        return Math.max(20, (int)((float)trackHeight * (float)trackHeight / (float)(this.contentHeight + 1)));
    }

    private int getThumbY(int trackTop, int trackHeight, int thumbHeight) {
        int range = Math.max(1, trackHeight - thumbHeight);
        return trackTop + (this.maxScroll == 0 ? 0 : (int)((float)this.scrollOffset / (float)this.maxScroll * (float)range));
    }

    private void registerScrollableWidget(AbstractWidget widget, int baseY) {
        this.scrollWidgets.add(widget);
        this.widgetBaseY.put(widget, baseY);
    }

    private void layoutScrollWidgets() {
        for (AbstractWidget widget : this.scrollWidgets) {
            boolean within;
            Integer baseY = this.widgetBaseY.get(widget);
            if (baseY == null) continue;
            int newY = baseY - this.scrollOffset;
            widget.setY(newY);
            widget.visible = within = newY + widget.getHeight() >= this.scrollTop && newY <= this.scrollBottom;
            widget.active = within;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (!status.connected && mouseY >= (double)this.scrollTop && mouseY <= (double)this.scrollBottom && this.maxScroll > 0) {
            this.scrollOffset -= (int)(scrollY * 20.0);
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            this.layoutScrollWidgets();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean dragging) {
        double mouseX = event.x();
        double mouseY = event.y();
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (!status.connected && this.maxScroll > 0) {
            int trackX = this.getTrackX();
            int trackTop = this.scrollTop;
            int trackHeight = this.getTrackHeight();
            int thumbHeight = this.getThumbHeight(trackHeight);
            int thumbY = this.getThumbY(trackTop, trackHeight, thumbHeight);
            if (mouseX >= (double)trackX && mouseX <= (double)(trackX + 4) && mouseY >= (double)trackTop && mouseY <= (double)this.scrollBottom) {
                if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                    this.draggingScrollbar = true;
                    this.dragStartMouseY = (int)mouseY;
                    this.dragStartScrollOffset = this.scrollOffset;
                } else {
                    int page = this.scrollBottom - this.scrollTop - 20;
                    this.scrollOffset = mouseY < (double)thumbY ? Math.max(0, this.scrollOffset - page) : Math.min(this.maxScroll, this.scrollOffset + page);
                    this.layoutScrollWidgets();
                }
                return true;
            }
        }
        return super.mouseClicked(event, dragging);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dx, double dy) {
        double mouseY = event.y();
        if (this.draggingScrollbar && this.maxScroll > 0) {
            int trackHeight = this.getTrackHeight();
            int thumbHeight = this.getThumbHeight(trackHeight);
            int range = Math.max(1, trackHeight - thumbHeight);
            int deltaY = (int)mouseY - this.dragStartMouseY;
            int deltaScroll = (int)((double)deltaY * (double)this.maxScroll / (double)range);
            this.scrollOffset = this.dragStartScrollOffset + deltaScroll;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            this.layoutScrollWidgets();
            return true;
        }
        return super.mouseDragged(event, dx, dy);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.mouseReleased(event);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        int prevOffset = this.scrollOffset;
        super.resize(minecraft, width, height);
        this.scrollOffset = Math.min(Math.max(prevOffset, 0), this.maxScroll);
        this.layoutScrollWidgets();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static /* synthetic */ void lambda$init$0(Button button) {
    }
}

