/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.OAuthHelper;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.TermsOfServiceScreen;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;

public class LoginScreen
extends Screen {
    private final Screen parent;
    private EditBox emailBox;
    private EditBox passwordBox;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private boolean isLoading = false;
    private String uiMode = "main";
    private int formStartY;
    private int emailLabelY;
    private int emailInputY;
    private int passwordLabelY;
    private int passwordInputY;

    public LoginScreen(Screen parent) {
        super((Component)Component.literal((String)"Tunnely - Login"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        if (this.uiMode.equals("main")) {
            this.initMainMenu();
        } else if (this.uiMode.equals("email")) {
            this.initEmailPasswordForm();
        } else if (this.uiMode.equals("reset")) {
            this.initPasswordResetForm();
        }
    }

    private void initMainMenu() {
        int buttonWidth = Math.min(280, this.width - 40);
        int buttonHeight = 30;
        int centerX = this.width / 2 - buttonWidth / 2;
        int availableHeight = this.height - 120;
        int totalContentHeight = 170;
        int startY = 70 + Math.max(10, (availableHeight - totalContentHeight) / 2);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udd37 Sign in with Microsoft"), button -> this.handleMicrosoftLogin()).bounds(centerX, startY, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2709 Sign in with Email"), button -> {
            this.uiMode = "email";
            this.statusMessage = "";
            this.rebuildWidgets();
        }).bounds(centerX, startY + 70, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190 Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX, this.height - 30, buttonWidth, 20).build());
    }

    private void initEmailPasswordForm() {
        int inputWidth = Math.min(300, this.width - 60);
        int inputHeight = 20;
        int centerX = this.width / 2 - inputWidth / 2;
        int labelHeight = 12;
        int labelGap = 12;
        int inputToInputGap = 30;
        int buttonGap = 8;
        int buttonHeight = 20;
        int totalFormHeight = labelHeight + labelGap + inputHeight + inputToInputGap + labelHeight + labelGap + inputHeight + buttonGap + buttonHeight + buttonGap + buttonHeight + buttonGap + buttonHeight;
        int titleHeight = 60;
        int bottomMargin = 30;
        int statusMargin = 60;
        int availableHeight = this.height - titleHeight - bottomMargin - statusMargin;
        this.formStartY = totalFormHeight > availableHeight ? titleHeight + 10 : titleHeight + (availableHeight - totalFormHeight) / 2;
        this.emailLabelY = this.formStartY;
        this.emailInputY = this.emailLabelY + labelHeight + labelGap;
        this.emailBox = new EditBox(this.font, centerX, this.emailInputY, inputWidth, inputHeight, (Component)Component.literal((String)"Email"));
        this.emailBox.setMaxLength(100);
        this.emailBox.setHint((Component)Component.literal((String)"Enter your email"));
        this.addRenderableWidget((GuiEventListener)this.emailBox);
        this.passwordLabelY = this.emailInputY + inputHeight + inputToInputGap;
        this.passwordInputY = this.passwordLabelY + labelHeight + labelGap;
        this.passwordBox = new EditBox(this.font, centerX, this.passwordInputY, inputWidth, inputHeight, (Component)Component.literal((String)"Password"));
        this.passwordBox.setMaxLength(100);
        this.passwordBox.setHint((Component)Component.literal((String)"Enter your password"));
        this.addRenderableWidget((GuiEventListener)this.passwordBox);
        int buttonY = this.passwordInputY + inputHeight + buttonGap;
        int halfWidth = (inputWidth - 8) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Login"), button -> this.handleLogin()).bounds(centerX, buttonY, halfWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Register"), button -> this.handleRegister()).bounds(centerX + halfWidth + 8, buttonY, halfWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Forgot Password?"), button -> {
            this.uiMode = "reset";
            this.statusMessage = "";
            this.rebuildWidgets();
        }).bounds(centerX, buttonY += buttonHeight + buttonGap, inputWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190 Other Sign-In Options"), button -> {
            this.uiMode = "main";
            this.statusMessage = "";
            this.rebuildWidgets();
        }).bounds(centerX, buttonY += buttonHeight + buttonGap, inputWidth, buttonHeight).build());
    }

    private void handleMicrosoftLogin() {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.statusMessage = "Opening browser for Microsoft login...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            try {
                OAuthHelper oauthHelper = new OAuthHelper();
                OAuthHelper.OAuthResult result = oauthHelper.startMicrosoftOAuth().get();
                this.minecraft.execute(() -> {
                    if (result.success) {
                        this.processMicrosoftAuthResult(result);
                    } else {
                        this.isLoading = false;
                        this.statusMessage = "Microsoft login failed: " + result.error;
                        this.statusColor = 0xFF0000;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely] OAuth error: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.isLoading = false;
                    this.statusMessage = "OAuth failed: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-OAuth").start();
    }

    private void processMicrosoftAuthResult(OAuthHelper.OAuthResult oauthResult) {
        this.statusMessage = "Validating Microsoft account...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            SupabaseClient.AuthResult authResult;
            SupabaseClient client = new SupabaseClient();
            if (oauthResult.isAuthCode) {
                String redirectUri = "http://localhost:54321/auth/callback";
                authResult = client.exchangeCodeForToken(oauthResult.token, redirectUri);
            } else {
                authResult = client.signInWithOAuth(oauthResult.token);
            }
            this.minecraft.execute(() -> {
                this.isLoading = false;
                if (authResult.success) {
                    String currentTosVersion;
                    TunnelConfig config = TunnelConfig.getInstance();
                    if (config.needsTosAcceptance(currentTosVersion = this.getTosVersionFromResource())) {
                        this.statusMessage = "You must accept our Terms of Service";
                        this.statusColor = 0xFFFF00;
                        this.minecraft.setScreen((Screen)new TermsOfServiceScreen(this, () -> {
                            this.minecraft.setScreen((Screen)this);
                            this.completeOAuthLogin(authResult.userId);
                        }));
                    } else {
                        this.recordTosToDatabase();
                        this.completeOAuthLogin(authResult.userId);
                    }
                } else {
                    this.statusMessage = authResult.error;
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-ValidateOAuth").start();
    }

    private void completeOAuthLogin(String userId) {
        this.statusMessage = "Completing login...";
        this.statusColor = 0xFFFF00;
        this.recordTosToDatabase();
        this.createProfileAndReturn(userId);
    }

    private void handleLogin() {
        String currentTosVersion;
        if (this.isLoading) {
            return;
        }
        String email = this.emailBox.getValue().trim();
        String password = this.passwordBox.getValue();
        if (email.isEmpty() || password.isEmpty()) {
            this.statusMessage = "Please enter email and password";
            this.statusColor = 0xFF0000;
            return;
        }
        TunnelConfig config = TunnelConfig.getInstance();
        if (config.needsTosAcceptance(currentTosVersion = this.getTosVersionFromResource())) {
            this.statusMessage = "You must accept the Terms of Service to continue";
            this.statusColor = 0xFFFF00;
            this.minecraft.setScreen((Screen)new TermsOfServiceScreen(this, () -> {
                this.minecraft.setScreen((Screen)this);
                this.proceedWithLogin(email, password);
            }));
            return;
        }
        this.proceedWithLogin(email, password);
    }

    private void proceedWithLogin(String email, String password) {
        this.isLoading = true;
        this.statusMessage = "Logging in...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            SupabaseClient.AuthResult result = TunnelManager.getInstance().login(email, password);
            this.minecraft.execute(() -> {
                this.isLoading = false;
                if (result.success) {
                    this.recordTosToDatabase();
                    this.createProfileAndReturn(result.userId);
                } else {
                    this.statusMessage = result.error;
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-Login").start();
    }

    private void recordTosToDatabase() {
        TunnelConfig config = TunnelConfig.getInstance();
        String tosVersion = config.getAcceptedTosVersion();
        if (tosVersion != null && !tosVersion.isEmpty()) {
            new Thread(() -> {
                try {
                    SupabaseClient client = new SupabaseClient();
                    boolean recorded = client.recordTosAcceptance(tosVersion);
                    if (recorded) {
                        System.out.println("[Tunnely] TOS acceptance logged to database");
                    } else {
                        System.err.println("[Tunnely] Failed to log TOS acceptance to database");
                    }
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Error logging TOS to database: " + e.getMessage());
                }
            }, "Tunnely-RecordTOS").start();
        }
    }

    private void createProfileAndReturn(String userId) {
        this.statusMessage = "\u00a7aLogin successful! Loading profile...";
        this.statusColor = 65280;
        new Thread(() -> {
            try {
                Thread.sleep(500L);
                SupabaseClient client = new SupabaseClient();
                JsonObject profile = client.getOwnProfile();
                if (profile == null || !profile.has("minecraft_name")) {
                    System.out.println("[Tunnely UI] No username found, prompting for username selection");
                    this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new UsernameSelectionScreen(this.parent, true)));
                } else {
                    String username = profile.get("minecraft_name").getAsString();
                    System.out.println("[Tunnely UI] Profile found with username: " + username);
                    this.minecraft.execute(() -> new Thread(() -> {
                        try {
                            Thread.sleep(500L);
                            this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new TunnelyMainScreen(this.parent)));
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }).start());
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error checking profile: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new UsernameSelectionScreen(this.parent, true)));
            }
        }, "Tunnely-CheckProfile").start();
    }

    private void handleRegister() {
        String currentTosVersion;
        if (this.isLoading) {
            return;
        }
        String email = this.emailBox.getValue().trim();
        String password = this.passwordBox.getValue();
        if (email.isEmpty() || password.isEmpty()) {
            this.statusMessage = "Please enter email and password";
            this.statusColor = 0xFF0000;
            return;
        }
        if (password.length() < 6) {
            this.statusMessage = "Password must be at least 6 characters";
            this.statusColor = 0xFF0000;
            return;
        }
        TunnelConfig config = TunnelConfig.getInstance();
        if (config.needsTosAcceptance(currentTosVersion = this.getTosVersionFromResource())) {
            this.minecraft.setScreen((Screen)new TermsOfServiceScreen(this, () -> this.proceedWithRegistration(email, password)));
        } else {
            this.proceedWithRegistration(email, password);
        }
    }

    private void proceedWithRegistration(String email, String password) {
        this.minecraft.setScreen((Screen)this);
        this.isLoading = true;
        this.statusMessage = "Registering...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            String minecraftName = "Player";
            if (this.minecraft.player != null) {
                minecraftName = this.minecraft.player.getName().getString();
            }
            String finalMinecraftName = minecraftName;
            SupabaseClient.AuthResult result = TunnelManager.getInstance().register(email, password, finalMinecraftName);
            this.minecraft.execute(() -> {
                this.isLoading = false;
                if (result.success) {
                    this.recordTosToDatabase();
                    this.statusMessage = "Registration successful! Please check your email to verify.";
                    this.statusColor = 65280;
                    this.passwordBox.setValue("");
                } else {
                    this.statusMessage = result.error;
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-Register").start();
    }

    private void initPasswordResetForm() {
        int inputWidth = Math.min(300, this.width - 60);
        int inputHeight = 20;
        int centerX = this.width / 2 - inputWidth / 2;
        int labelHeight = 12;
        int labelGap = 12;
        int buttonGap = 8;
        int buttonHeight = 20;
        int totalFormHeight = labelHeight + labelGap + inputHeight + buttonGap + buttonHeight + buttonGap + buttonHeight;
        int titleHeight = 80;
        int bottomMargin = 30;
        int statusMargin = 60;
        int availableHeight = this.height - titleHeight - bottomMargin - statusMargin;
        int startY = totalFormHeight > availableHeight ? titleHeight + 10 : titleHeight + (availableHeight - totalFormHeight) / 2;
        int emailLabelY = startY;
        int emailInputY = emailLabelY + labelHeight + labelGap;
        this.emailBox = new EditBox(this.font, centerX, emailInputY, inputWidth, inputHeight, (Component)Component.literal((String)"Email"));
        this.emailBox.setMaxLength(100);
        this.emailBox.setHint((Component)Component.literal((String)"Enter your email"));
        this.addRenderableWidget((GuiEventListener)this.emailBox);
        int buttonY = emailInputY + inputHeight + buttonGap;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Send Reset Email"), button -> this.handlePasswordReset()).bounds(centerX, buttonY, inputWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190 Back to Login"), button -> {
            this.uiMode = "email";
            this.statusMessage = "";
            this.rebuildWidgets();
        }).bounds(centerX, buttonY += buttonHeight + buttonGap, inputWidth, buttonHeight).build());
        this.emailLabelY = emailLabelY;
    }

    private void handlePasswordReset() {
        if (this.isLoading) {
            return;
        }
        String email = this.emailBox.getValue().trim();
        if (email.isEmpty()) {
            this.statusMessage = "Please enter your email address";
            this.statusColor = 0xFF0000;
            return;
        }
        if (!email.contains("@") || !email.contains(".")) {
            this.statusMessage = "Please enter a valid email address";
            this.statusColor = 0xFF0000;
            return;
        }
        this.isLoading = true;
        this.statusMessage = "Sending password reset email...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            SupabaseClient client = new SupabaseClient();
            boolean success = client.requestPasswordReset(email);
            this.minecraft.execute(() -> {
                this.isLoading = false;
                if (success) {
                    this.statusMessage = "\u00a7aPassword reset email sent! Check your inbox.";
                    this.statusColor = 65280;
                    this.emailBox.setValue("");
                    new Thread(() -> {
                        try {
                            Thread.sleep(3000L);
                            this.minecraft.execute(() -> {
                                this.uiMode = "email";
                                this.statusMessage = "";
                                this.rebuildWidgets();
                            });
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }, "Tunnely-ResetRedirect").start();
                } else {
                    this.statusMessage = "Failed to send reset email. Please try again.";
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-PasswordReset").start();
    }

    private String getTosVersionFromResource() {
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/terms-of-service.json");
            if (stream != null) {
                InputStreamReader reader = new InputStreamReader(stream);
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                return json.has("version") ? json.get("version").getAsString() : "1.0.0";
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error reading TOS version: " + e.getMessage());
        }
        return "1.0.0";
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int titleY = 30;
        graphics.drawCenteredString(this.font, "\u00a76\u00a7lTunnely", this.width / 2, titleY, ColorUtil.opaque(0xFFFFFF));
        if (this.uiMode.equals("main")) {
            graphics.drawCenteredString(this.font, "\u00a7fChoose your sign-in method", this.width / 2, titleY + 25, ColorUtil.opaque(0xAAAAAA));
            int availableHeight = this.height - 120;
            int totalContentHeight = 170;
            int startY = 70 + Math.max(10, (availableHeight - totalContentHeight) / 2);
            int dividerY = startY + 45;
            int dividerWidth = Math.min(100, (this.width - 40) / 3);
            int centerX = this.width / 2;
            graphics.fill(centerX - dividerWidth, dividerY, centerX - 25, dividerY + 1, -10066330);
            graphics.fill(centerX + 25, dividerY, centerX + dividerWidth, dividerY + 1, -10066330);
            graphics.drawCenteredString(this.font, "\u00a77OR", centerX, dividerY - 4, ColorUtil.opaque(0x888888));
            graphics.drawCenteredString(this.font, "\u00a77New users will be registered automatically", this.width / 2, this.height - 50, ColorUtil.opaque(0x888888));
        } else if (this.uiMode.equals("email")) {
            graphics.drawCenteredString(this.font, "\u00a7fSign in with Email & Password", this.width / 2, titleY + 25, ColorUtil.opaque(0xAAAAAA));
            inputWidth = Math.min(300, this.width - 60);
            centerX = this.width / 2 - inputWidth / 2;
            graphics.drawString(this.font, "\u00a7fEmail:", centerX, this.emailLabelY, ColorUtil.opaque(0xFFFFFF));
            graphics.drawString(this.font, "\u00a7fPassword:", centerX, this.passwordLabelY, ColorUtil.opaque(0xFFFFFF));
        } else if (this.uiMode.equals("reset")) {
            graphics.drawCenteredString(this.font, "\u00a76Reset Your Password", this.width / 2, titleY + 25, ColorUtil.opaque(0xFFFFFF));
            graphics.drawCenteredString(this.font, "\u00a77Enter your email to receive a reset link", this.width / 2, titleY + 40, ColorUtil.opaque(0x888888));
            inputWidth = Math.min(300, this.width - 60);
            centerX = this.width / 2 - inputWidth / 2;
            graphics.drawString(this.font, "\u00a7fEmail:", centerX, this.emailLabelY, ColorUtil.opaque(0xFFFFFF));
        }
        if (!this.statusMessage.isEmpty()) {
            int statusY = this.height - 45;
            int maxWidth = this.width - 60;
            if (this.font.width(this.statusMessage) > maxWidth) {
                String[] words = this.statusMessage.split(" ");
                StringBuilder line = new StringBuilder();
                int yOffset = 0;
                for (String word : words) {
                    String testLine;
                    String string = testLine = line.length() > 0 ? String.valueOf(line) + " " + word : word;
                    if (this.font.width(testLine) > maxWidth) {
                        graphics.drawCenteredString(this.font, line.toString(), this.width / 2, statusY + yOffset, ColorUtil.opaque(this.statusColor));
                        line = new StringBuilder(word);
                        yOffset += 10;
                        continue;
                    }
                    line = new StringBuilder(testLine);
                }
                if (line.length() > 0) {
                    graphics.drawCenteredString(this.font, line.toString(), this.width / 2, statusY + yOffset, ColorUtil.opaque(this.statusColor));
                }
            } else {
                graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, statusY, ColorUtil.opaque(this.statusColor));
            }
        }
        if (this.isLoading) {
            graphics.drawCenteredString(this.font, "\u23f3 Please wait...", this.width / 2, this.height - 20, ColorUtil.opaque(0xFFFF00));
        }
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

