/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.EncryptionKeyManager;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.DirectJoinScreen;
import org.texboobcat.tunnelyrefab.ui.screens.HostGameScreen;
import org.texboobcat.tunnelyrefab.ui.screens.InvitesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.PublicLobbiesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.SettingsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UnifiedFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;

public class TunnelyMainScreen
extends Screen {
    private final Screen parent;
    private final TunnelConfig config;
    private final TunnelManager manager;
    private final List<Button> menuButtons = new ArrayList<Button>();
    private int buttonWidth;
    private final int buttonHeight = 20;
    private int safeTop;
    private final int safeBottom = 70;
    private int spacing;
    private int stackStartY;
    private int stackTotalH;
    private boolean scrollable;
    private double scroll;
    private String footerMessage = "";
    private int footerColor = 0xFFFFFF;
    private int tickCounter = 0;
    private Button hostButton;
    private Button donateButton;
    private Button backButton;

    public TunnelyMainScreen(Screen parent) {
        super((Component)Component.literal((String)"Tunnely"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
        this.manager = TunnelManager.getInstance();
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        this.computeHeaderSafeTop();
        this.computeButtons();
        this.addBottomBar();
        this.manager.setDisconnectListener(() -> this.minecraft.execute(() -> this.updateHostButtonText()));
        if (this.config.isAuthenticated()) {
            new Thread(() -> {
                try {
                    SupabaseClient client = new SupabaseClient();
                    if (client.needsLogin()) {
                        this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new LoginScreen(this.parent)));
                        return;
                    }
                    JsonObject profile = client.getOwnProfile();
                    if (profile == null || !profile.has("minecraft_name")) {
                        System.out.println("[Tunnely] User missing profile or username, redirecting to username selection");
                        this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new UsernameSelectionScreen(this.parent, true)));
                        return;
                    }
                    PresenceManager.getInstance().start();
                    MessageManager.getInstance().start();
                    EncryptionKeyManager.initializeKeys();
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Background initialization error: " + e.getMessage());
                }
            }, "Tunnely-Init").start();
        }
    }

    private void computeHeaderSafeTop() {
        this.safeTop = 45;
    }

    private void computeButtons() {
        this.menuButtons.clear();
        this.buttonWidth = Math.min(240, Math.max(160, (int)((double)this.width * 0.3)));
        int centerX = this.width / 2 - this.buttonWidth / 2;
        boolean authed = this.config.isAuthenticated();
        if (!authed) {
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Login / Register"), b -> this.minecraft.setScreen((Screen)new LoginScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
        } else {
            boolean inSingleplayer = this.minecraft.getSingleplayerServer() != null;
            boolean isHosting = this.manager.isHosting();
            String buttonText = isHosting ? "Manage" : "Host Game";
            this.hostButton = Button.builder((Component)Component.literal((String)buttonText), b -> {
                if (this.minecraft.getSingleplayerServer() != null) {
                    this.minecraft.setScreen((Screen)new HostGameScreen(this));
                } else {
                    this.setFooterMessage("\u00a7cPlease create or load a world first before hosting!", 0xFF5555);
                }
            }).bounds(centerX, 0, this.buttonWidth, 20).build();
            this.hostButton.active = inSingleplayer;
            this.menuButtons.add(this.hostButton);
            if (!inSingleplayer) {
                this.setFooterMessage("\u00a77Tip: Create or load a world to enable hosting", 0xAAAAAA);
            }
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Friends & Servers"), b -> this.minecraft.setScreen((Screen)new UnifiedFriendsScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Direct Join"), b -> this.minecraft.setScreen((Screen)new DirectJoinScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Invites"), b -> this.minecraft.setScreen((Screen)new InvitesScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Public Lobbies"), b -> this.minecraft.setScreen((Screen)new PublicLobbiesScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
            this.menuButtons.add(Button.builder((Component)Component.literal((String)"Settings"), b -> this.minecraft.setScreen((Screen)new SettingsScreen(this))).bounds(centerX, 0, this.buttonWidth, 20).build());
        }
        int count = this.menuButtons.size();
        int areaH = Math.max(0, this.height - this.safeTop - 70);
        int ideal = 22;
        int min = 5;
        this.spacing = ideal;
        int needed = count * 20 + (count - 1) * this.spacing;
        if (needed > areaH) {
            int neededMin = count * 20 + (count - 1) * min;
            this.spacing = neededMin > areaH ? min : (areaH - count * 20) / Math.max(1, count - 1);
        }
        this.stackTotalH = count * 20 + (count - 1) * this.spacing;
        boolean bl = this.scrollable = this.stackTotalH > areaH;
        if (!this.scrollable) {
            this.scroll = 0.0;
        }
        this.stackStartY = this.safeTop + Math.max(0, (areaH - this.stackTotalH) / 2);
        for (Button b2 : this.menuButtons) {
            this.addRenderableWidget((GuiEventListener)b2);
        }
        this.layoutButtons();
    }

    private void layoutButtons() {
        int y = this.stackStartY - (int)Math.max(0.0, this.scroll);
        int centerX = this.width / 2 - this.buttonWidth / 2;
        for (Button b : this.menuButtons) {
            b.setX(centerX);
            b.setY(y);
            y += 20 + this.spacing;
        }
    }

    private void addBottomBar() {
        int centerX = this.width / 2 - this.buttonWidth / 2;
        this.donateButton = Button.builder((Component)Component.literal((String)"Donate"), btn -> this.openDonate()).bounds(centerX, this.height - 55, this.buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.donateButton);
        this.backButton = Button.builder((Component)Component.literal((String)"Back"), btn -> this.minecraft.setScreen(this.parent)).bounds(centerX, this.height - 30, this.buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
    }

    private void openDonate() {
        try {
            Util.getPlatform().openUri("https://ko-fi.com/bobcatmods");
            this.footerMessage = "";
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Failed to open browser: " + e.getMessage());
            this.footerMessage = "\u00a7cFailed to open browser";
            this.footerColor = 0xFF5555;
        }
    }

    public void tick() {
        super.tick();
        ++this.tickCounter;
        if (this.tickCounter >= 40) {
            this.tickCounter = 0;
            this.updateHostButtonText();
        }
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float delta) {
        g.drawCenteredString(this.font, "\u00a76\u00a7lTunnely", this.width / 2, 15, ColorUtil.opaque(0xFFFFFF));
        g.drawCenteredString(this.font, "\u00a77NAT Traversal", this.width / 2, 28, ColorUtil.opaque(0xAAAAAA));
        int clipTop = this.safeTop;
        int clipBottom = this.height - 70;
        g.enableScissor(0, clipTop, this.width, clipBottom);
        for (Button btn : this.menuButtons) {
            btn.render(g, mouseX, mouseY, delta);
        }
        g.disableScissor();
        if (this.donateButton != null) {
            this.donateButton.render(g, mouseX, mouseY, delta);
        }
        if (this.backButton != null) {
            this.backButton.render(g, mouseX, mouseY, delta);
        }
        if (!this.footerMessage.isEmpty()) {
            g.drawCenteredString(this.font, this.footerMessage, this.width / 2, this.height - 70, ColorUtil.opaque(this.footerColor));
        }
        if (this.scrollable) {
            int areaTop = this.safeTop;
            int areaH = Math.max(10, this.height - this.safeTop - 70);
            int barX = this.width - 10;
            int total = Math.max(1, this.stackTotalH);
            int thumbH = Math.max(20, areaH * areaH / total);
            int maxScroll = Math.max(1, this.stackTotalH - areaH);
            int thumbY = areaTop + (int)(this.scroll * (double)(areaH - thumbH) / (double)maxScroll);
            g.fill(barX, areaTop, barX + 6, areaTop + areaH, 0x40FFFFFF);
            g.fill(barX, thumbY, barX + 6, thumbY + thumbH, -2130706433);
        }
        super.render(g, mouseX, mouseY, delta);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.scrollable) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        int areaH = Math.max(10, this.height - this.safeTop - 70);
        int maxScroll = Math.max(0, this.stackTotalH - areaH);
        this.scroll = Math.max(0.0, Math.min((double)maxScroll, this.scroll - scrollY * 22.0));
        this.layoutButtons();
        return true;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean dragging) {
        double mouseX = event.x();
        double mouseY = event.y();
        if (this.donateButton != null && this.donateButton.mouseClicked(event, dragging)) {
            return true;
        }
        if (this.backButton != null && this.backButton.mouseClicked(event, dragging)) {
            return true;
        }
        int clipTop = this.safeTop;
        int clipBottom = this.height - 70;
        if (mouseY >= (double)clipTop && mouseY <= (double)clipBottom) {
            for (Button btn : this.menuButtons) {
                if (!btn.mouseClicked(event, dragging)) continue;
                return true;
            }
        }
        return super.mouseClicked(event, dragging);
    }

    public void resize(Minecraft mc, int w, int h) {
        super.resize(mc, w, h);
        this.clearWidgets();
        this.init();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void setFooterMessage(String message, int color) {
        this.footerMessage = message;
        this.footerColor = color;
    }

    private void updateHostButtonText() {
        if (this.hostButton != null) {
            boolean isHosting = this.manager.isHosting();
            String buttonText = isHosting ? "Manage" : "Host Game";
            this.hostButton.setMessage((Component)Component.literal((String)buttonText));
            System.out.println("[Tunnely] Host button updated: " + buttonText);
        }
    }
}

