/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;

public class SafeDisconnect {
    public static boolean isInWorldOrServer() {
        Minecraft minecraft = Minecraft.getInstance();
        return minecraft.level != null || minecraft.player != null;
    }

    public static boolean isInMultiplayer() {
        Minecraft minecraft = Minecraft.getInstance();
        return minecraft.getCurrentServer() != null;
    }

    public static boolean isInSingleplayer() {
        Minecraft minecraft = Minecraft.getInstance();
        return minecraft.level != null && minecraft.getCurrentServer() == null && minecraft.hasSingleplayerServer();
    }

    public static boolean disconnect(Screen returnScreen) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!SafeDisconnect.isInWorldOrServer()) {
            System.out.println("[Tunnely SafeDisconnect] Not in world or server, no disconnect needed");
            return false;
        }
        System.out.println("[Tunnely SafeDisconnect] Disconnecting from current world/server...");
        if (SafeDisconnect.isInSingleplayer()) {
            System.out.println("[Tunnely SafeDisconnect] In singleplayer world - saving and exiting");
            minecraft.level.disconnect((Component)Component.empty());
            minecraft.clearClientLevel((Screen)new TitleScreen());
        } else if (SafeDisconnect.isInMultiplayer()) {
            System.out.println("[Tunnely SafeDisconnect] In multiplayer server - disconnecting");
            minecraft.level.disconnect((Component)Component.empty());
            minecraft.clearClientLevel((Screen)new TitleScreen());
        } else {
            System.out.println("[Tunnely SafeDisconnect] Unknown state - clearing level");
            minecraft.clearClientLevel((Screen)new TitleScreen());
        }
        return true;
    }

    public static void disconnectAndThen(Runnable callback) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!SafeDisconnect.isInWorldOrServer()) {
            System.out.println("[Tunnely SafeDisconnect] Not in world, running callback immediately");
            callback.run();
            return;
        }
        System.out.println("[Tunnely SafeDisconnect] Disconnecting, will run callback after disconnect");
        boolean disconnected = SafeDisconnect.disconnect(null);
        if (disconnected) {
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    minecraft.execute(callback);
                    System.out.println("[Tunnely SafeDisconnect] Callback executed after disconnect");
                }
                catch (InterruptedException e) {
                    System.err.println("[Tunnely SafeDisconnect] Error waiting for disconnect: " + e.getMessage());
                    e.printStackTrace();
                }
            }, "Tunnely-SafeDisconnect").start();
        } else {
            callback.run();
        }
    }

    public static String getConnectionStateDescription() {
        if (SafeDisconnect.isInSingleplayer()) {
            return "singleplayer world";
        }
        if (SafeDisconnect.isInMultiplayer()) {
            return "multiplayer server";
        }
        if (SafeDisconnect.isInWorldOrServer()) {
            return "world";
        }
        return "none";
    }
}

